/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.magnetitem;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.block.core.BlockBaseHasTile;
import com.lothrazar.cyclicmagic.block.magnetitem.TileEntityMagnet;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.registry.BlockRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMagnet
extends BlockBaseHasTile
implements IHasRecipe,
IContent {
    protected static final AxisAlignedBB BOUNDS = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.03125, 0.9375);
    private boolean enabled;

    public BlockMagnet() {
        super(Material.field_151573_f);
        this.func_149711_c(3.0f).func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setTranslucent();
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        return new TileEntityMagnet();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDS;
    }

    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, World worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public boolean func_181623_g() {
        return true;
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Block)this), "sbs", "bxb", "sbs", Character.valueOf('s'), "nuggetIron", Character.valueOf('b'), "plankWood", Character.valueOf('x'), "dyePurple");
    }

    @Override
    public void register() {
        BlockRegistry.registerBlock((Block)this, "magnet_block", GuideCategory.BLOCKPLATE);
        GameRegistry.registerTileEntity(TileEntityMagnet.class, (String)"magnet_block_te");
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("MagnetBlock", "cyclicmagic.content", true, "Set false to delete - requires restart");
        TileEntityMagnet.TIMER_FULL = config.getInt("MagnetBlockTimer", "modpacks", 100, 5, 5000, "How fast it pulses.  Smaller numbers are faster");
        TileEntityMagnet.ITEM_HRADIUS = config.getInt("MagnetBlockDistance", "modpacks", 16, 2, 128, "Distance it pulls items from.");
        TileEntityMagnet.ITEM_VRADIUS = config.getInt("MagnetBlockHeight", "modpacks", 2, 1, 128, "Height it pulls at items");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        String s = UtilChat.lang("tile.magnet_block.tooltip").replace("$t$", TileEntityMagnet.TIMER_FULL + "");
        tooltip.add(s);
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }
}

