/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.dropt.modules.dropt.rule.drop;

import com.codetaylor.mc.athenaeum.util.WeightedPicker;
import com.codetaylor.mc.dropt.api.reference.EnumDropStrategy;
import com.codetaylor.mc.dropt.api.reference.EnumReplaceStrategy;
import com.codetaylor.mc.dropt.api.reference.EnumXPReplaceStrategy;
import com.codetaylor.mc.dropt.modules.dropt.rule.data.Rule;
import com.codetaylor.mc.dropt.modules.dropt.rule.data.RuleDrop;
import com.codetaylor.mc.dropt.modules.dropt.rule.log.DebugFileWrapper;
import com.codetaylor.mc.dropt.modules.dropt.rule.match.ItemMatchEntry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DropModifier {
    private static final Random RANDOM = new Random();

    public List<ItemStack> modifyDrops(World world, BlockPos pos, Rule rule, List<ItemStack> currentDrops, boolean isSilkTouching, int fortuneLevel, int experience, DebugFileWrapper logFile, boolean debug) {
        if (debug) {
            logFile.debug("");
        }
        if (rule.replaceStrategy == EnumReplaceStrategy.REPLACE_ALL) {
            currentDrops.clear();
            if (debug) {
                logFile.debug("[DROP] Cleared drop list, replace strategy: " + (Object)((Object)rule.replaceStrategy));
            }
        }
        WeightedPicker picker = new WeightedPicker();
        if (debug) {
            logFile.debug("[DROP] Selecting drop candidates...");
        }
        int candidatesFound = 0;
        for (RuleDrop drop : rule.drops) {
            if (!drop.selector.isValidCandidate(isSilkTouching, fortuneLevel, logFile, debug)) continue;
            int weight = drop.selector.weight.value + fortuneLevel * drop.selector.weight.fortuneModifier;
            if (weight > 0) {
                picker.add(weight, (Object)drop);
                ++candidatesFound;
                if (!debug) continue;
                logFile.debug("[DROP] Added drop to weighted picker: " + drop.item.toString());
                logFile.debug("[DROP] Added drop using weight value: " + weight);
                continue;
            }
            if (!debug) continue;
            logFile.debug("[DROP] Skipped adding drop " + drop.item.toString() + " to weighted picker due to calculated weight <= 0: " + weight);
        }
        if (picker.getTotal() == 0) {
            if (debug) {
                logFile.debug("[DROP] No valid drop candidates were found");
                logFile.debug("[DROP] Returning drop list: " + currentDrops);
            }
            return currentDrops;
        }
        if (debug) {
            logFile.debug("[DROP] Valid drop candidates found: " + candidatesFound);
            logFile.debug("[DROP] Total weight: " + picker.getTotal());
        }
        int dropCount = rule.dropCount.get(RANDOM, fortuneLevel);
        if (debug) {
            logFile.debug("[DROP] Drop count: " + dropCount);
        }
        ArrayList<ItemStack> newDrops = new ArrayList<ItemStack>();
        for (int i = 0; i < dropCount && picker.getSize() != 0; ++i) {
            RuleDrop ruleDrop;
            if (rule.dropStrategy == EnumDropStrategy.UNIQUE) {
                ruleDrop = (RuleDrop)picker.getAndRemove();
                if (debug) {
                    logFile.debug("[DROP] Removed drop from picker: " + ruleDrop.toString());
                }
            } else {
                ruleDrop = (RuleDrop)picker.get();
            }
            int itemQuantity = ruleDrop.item.quantity.get(RANDOM, fortuneLevel);
            if (debug) {
                logFile.debug("[DROP] Selected drop: " + ruleDrop.toString());
                logFile.debug("[DROP] Selected drop quantity: " + itemQuantity);
            }
            int xp = ruleDrop.xp.get(RANDOM, fortuneLevel);
            if (ruleDrop.xpReplaceStrategy == EnumXPReplaceStrategy.ADD) {
                xp += experience;
            }
            if (xp > 0) {
                if (debug) {
                    logFile.debug("[DROP] Dropping xp: " + xp);
                }
                while (xp > 0) {
                    int xpDrop = EntityXPOrb.func_70527_a((int)xp);
                    xp -= xpDrop;
                    world.func_72838_d((Entity)new EntityXPOrb(world, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p(), xpDrop));
                }
            } else if (debug) {
                logFile.debug("[DROP] Dropped zero xp");
            }
            if (itemQuantity <= 0) {
                if (!debug) continue;
                logFile.debug("[DROP] Skipping selected drop due to low item quantity roll: " + itemQuantity);
                continue;
            }
            if (ruleDrop.item._items.isEmpty()) {
                if (!debug) continue;
                logFile.debug("[DROP] Skipping selected drop due to empty drop item list");
                continue;
            }
            ItemStack copy = ruleDrop.item._items.get(RANDOM.nextInt(ruleDrop.item._items.size())).func_77946_l();
            copy.func_190920_e(itemQuantity);
            newDrops.add(copy);
            if (!debug) continue;
            logFile.debug("[DROP] Added ItemStack to drop list: " + copy);
        }
        if (rule.replaceStrategy == EnumReplaceStrategy.REPLACE_ALL_IF_SELECTED && !newDrops.isEmpty()) {
            currentDrops.clear();
            if (debug) {
                logFile.debug("[DROP] Cleared drop list, replace strategy: " + (Object)((Object)rule.replaceStrategy));
            }
        }
        boolean removeMatchedItems = false;
        if (rule.replaceStrategy == EnumReplaceStrategy.REPLACE_ITEMS && !rule.match.drops._drops.isEmpty()) {
            removeMatchedItems = true;
        }
        if (rule.replaceStrategy == EnumReplaceStrategy.REPLACE_ITEMS_IF_SELECTED && !newDrops.isEmpty() && !rule.match.drops._drops.isEmpty()) {
            removeMatchedItems = true;
        }
        if (removeMatchedItems) {
            if (debug) {
                logFile.debug("[DROP] Removing all items specified in the item matcher, replace strategy: " + (Object)((Object)rule.replaceStrategy));
            }
            Iterator<ItemStack> it = currentDrops.iterator();
            block3: while (it.hasNext()) {
                ItemStack itemStack = it.next();
                for (ItemMatchEntry itemMatchEntry : rule.match.drops._drops) {
                    if (itemMatchEntry.matches(itemStack, logFile, debug, "[DROP] ")) {
                        it.remove();
                        if (!debug) continue block3;
                        logFile.debug("[DROP] Removed: " + itemStack);
                        continue block3;
                    }
                    if (!debug) continue;
                    logFile.debug("[DROP] Skipping: " + itemStack);
                }
            }
        }
        currentDrops.addAll(newDrops);
        if (debug) {
            logFile.debug("Returning drop list: " + currentDrops);
        }
        return currentDrops;
    }
}

