/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.client.render.item;

import codechicken.lib.model.ItemQuadBakery;
import codechicken.lib.model.bakedmodels.ModelProperties;
import codechicken.lib.model.bakedmodels.PerspectiveAwareBakedModel;
import codechicken.lib.util.ResourceUtils;
import codechicken.lib.util.TransformUtils;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import morph.avaritia.api.ICosmicRenderItem;
import morph.avaritia.client.render.item.WrappedItemRenderer;
import morph.avaritia.client.render.shader.CosmicShaderHelper;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.model.IModelState;

public class CosmicItemRender
extends WrappedItemRenderer {
    private static final HashMap<TextureAtlasSprite, IBakedModel> spriteQuadCache = new HashMap();

    public CosmicItemRender(IModelState state, IBakedModel wrapped) {
        super(state, wrapped);
    }

    public CosmicItemRender(IModelState state, WrappedItemRenderer.IWrappedModelGetter getter) {
        super(state, getter);
    }

    public void renderItem(ItemStack item, ItemCameraTransforms.TransformType transformType) {
        this.processLightLevel(transformType);
        if (transformType == ItemCameraTransforms.TransformType.GUI) {
            this.renderInventory(item, this.renderEntity);
        } else {
            this.renderSimple(item, this.renderEntity);
        }
    }

    protected void renderSimple(ItemStack stack, EntityLivingBase player) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        World world = player != null ? player.field_70170_p : null;
        IBakedModel model = this.wrapped.func_188617_f().handleItemState(this.wrapped, stack, world, player);
        CosmicItemRender.renderModel(model, stack);
        if (stack.func_77973_b() instanceof ICosmicRenderItem) {
            ICosmicRenderItem cri = (ICosmicRenderItem)stack.func_77973_b();
            GlStateManager.func_179118_c();
            GlStateManager.func_179143_c((int)514);
            TextureAtlasSprite cosmicSprite = cri.getMaskTexture(stack, player);
            IBakedModel cosmicModel = spriteQuadCache.computeIfAbsent(cosmicSprite, CosmicItemRender::computeModel);
            CosmicShaderHelper.cosmicOpacity = cri.getMaskOpacity(stack, player);
            CosmicShaderHelper.useShader();
            CosmicItemRender.renderModel(cosmicModel, stack);
            CosmicShaderHelper.releaseShader();
            GlStateManager.func_179143_c((int)515);
            GlStateManager.func_179141_d();
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    protected void renderInventory(ItemStack stack, EntityLivingBase player) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179118_c();
        GlStateManager.func_179097_i();
        World world = player != null ? player.field_70170_p : null;
        IBakedModel model = this.wrapped.func_188617_f().handleItemState(this.wrapped, stack, world, player);
        CosmicItemRender.renderModel(model, stack);
        if (stack.func_77973_b() instanceof ICosmicRenderItem) {
            ICosmicRenderItem cri = (ICosmicRenderItem)stack.func_77973_b();
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179118_c();
            GlStateManager.func_179097_i();
            TextureAtlasSprite sprite = cri.getMaskTexture(stack, player);
            IBakedModel cosmicModel = spriteQuadCache.computeIfAbsent(sprite, CosmicItemRender::computeModel);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            CosmicShaderHelper.cosmicOpacity = cri.getMaskOpacity(stack, player);
            CosmicShaderHelper.inventoryRender = true;
            CosmicShaderHelper.useShader();
            CosmicItemRender.renderModel(cosmicModel, stack);
            CosmicShaderHelper.releaseShader();
            CosmicShaderHelper.inventoryRender = false;
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179141_d();
        GlStateManager.func_179091_B();
        GlStateManager.func_179126_j();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    private static IBakedModel computeModel(TextureAtlasSprite sprite) {
        List quads = ItemQuadBakery.bakeItem((List)ImmutableList.of((Object)sprite));
        return new PerspectiveAwareBakedModel(quads, (IModelState)TransformUtils.DEFAULT_ITEM, new ModelProperties(true, false));
    }

    protected void processLightLevel(ItemCameraTransforms.TransformType transformType) {
        switch (transformType) {
            case GROUND: {
                if (this.entityPos == null) break;
                CosmicShaderHelper.setLightFromLocation(this.world, this.entityPos);
                return;
            }
            case THIRD_PERSON_LEFT_HAND: 
            case THIRD_PERSON_RIGHT_HAND: 
            case FIRST_PERSON_LEFT_HAND: 
            case FIRST_PERSON_RIGHT_HAND: 
            case HEAD: {
                if (this.renderEntity == null) break;
                CosmicShaderHelper.setLightFromLocation(this.world, this.entityPos);
                return;
            }
            case GUI: {
                CosmicShaderHelper.setLightLevel(1.2f);
                return;
            }
        }
        CosmicShaderHelper.setLightLevel(1.0f);
    }

    static {
        ResourceUtils.registerReloadListener(resourceManager -> spriteQuadCache.clear());
    }
}

