/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecture.client.render.shape;

import com.elytradev.architecture.client.render.shape.RenderShape;
import com.elytradev.architecture.client.render.target.RenderTargetBase;
import com.elytradev.architecture.client.render.texture.ITexture;
import com.elytradev.architecture.common.helpers.Trans3;
import com.elytradev.architecture.common.helpers.Vector3;
import com.elytradev.architecture.common.shape.Shape;
import com.elytradev.architecture.common.tile.TileShape;
import java.util.Arrays;
import net.minecraft.util.EnumFacing;

public class RenderRoof
extends RenderShape {
    protected static final Shape[] ridgeShapes = new Shape[]{Shape.ROOF_RIDGE, Shape.ROOF_SMART_RIDGE};
    protected static final Shape[] ridgeOrSlopeShapes = new Shape[]{Shape.ROOF_RIDGE, Shape.ROOF_SMART_RIDGE, Shape.ROOF_TILE, Shape.ROOF_OUTER_CORNER, Shape.ROOF_INNER_CORNER};
    protected static final Shape[] valleyShapes = new Shape[]{Shape.ROOF_VALLEY, Shape.ROOF_SMART_VALLEY};
    protected static final Shape[] valleyOrSlopeShapes = new Shape[]{Shape.ROOF_VALLEY, Shape.ROOF_SMART_VALLEY, Shape.ROOF_TILE, Shape.ROOF_INNER_CORNER};
    protected EnumFacing face;
    protected boolean outerFace;
    protected boolean renderBase;
    protected boolean renderSecondary;

    public RenderRoof(TileShape te, ITexture[] textures, Trans3 t, RenderTargetBase target, boolean renderBase, boolean renderSecondary, int baseColourMult, int secondaryColourMult) {
        super(te, textures, t, target);
        this.renderBase = renderBase;
        this.renderSecondary = renderSecondary;
        this.setBaseColourMult(baseColourMult);
        this.setSecondaryColourMult(secondaryColourMult);
    }

    @Override
    public void render() {
        switch (this.te.shape) {
            case ROOF_TILE: {
                this.renderSlope();
                break;
            }
            case ROOF_OUTER_CORNER: {
                this.renderOuterCorner();
                break;
            }
            case ROOF_INNER_CORNER: {
                this.renderInnerCorner();
                break;
            }
            case ROOF_RIDGE: {
                this.renderRidge();
                break;
            }
            case ROOF_SMART_RIDGE: {
                this.renderSmartRidge();
                break;
            }
            case ROOF_VALLEY: {
                this.renderValley();
                break;
            }
            case ROOF_SMART_VALLEY: {
                StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                boolean handleItemState = Arrays.stream(stackTrace).anyMatch(stackTraceElement -> stackTraceElement.getMethodName().startsWith("handleItemState"));
                if (!handleItemState) {
                    this.renderSmartValley();
                    break;
                }
                this.renderSmartValley();
            }
        }
    }

    protected void renderSlope() {
        boolean valley = this.valleyAt(0, 0, 1);
        if (this.renderSecondary) {
            this.beginNegZSlope();
            if (valley) {
                this.beginTriangle();
                this.vertex(1.0, 1.0, 1.0, 0.0, 0.0);
                this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
                this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
                this.newTriangle();
                this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
                this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
                this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
                this.newTriangle();
                this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
                this.vertex(0.0, 1.0, 1.0, 1.0, 0.0);
                this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
                this.endFace();
                this.connectValleyBack();
            } else {
                this.beginQuad();
                this.vertex(1.0, 1.0, 1.0, 0.0, 0.0);
                this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
                this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
                this.vertex(0.0, 1.0, 1.0, 1.0, 0.0);
                this.endFace();
            }
        }
        if (this.renderBase) {
            this.leftTriangle();
            this.rightTriangle();
            this.bottomQuad();
            if (!valley) {
                this.backQuad();
            }
        }
        if (this.renderSecondary && this.ridgeAt(0, 0, -1)) {
            this.connectRidgeFront();
        }
    }

    protected void renderOuterCorner() {
        if (this.renderSecondary) {
            this.beginNegZSlope();
            this.beginTriangle();
            this.vertex(0.0, 1.0, 1.0, 1.0, 0.0);
            this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
            this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
            this.endFace();
            this.beginPosXSlope();
            this.beginTriangle();
            this.vertex(0.0, 1.0, 1.0, 0.0, 0.0);
            this.vertex(1.0, 0.0, 1.0, 0.0, 1.0);
            this.vertex(1.0, 0.0, 0.0, 1.0, 1.0);
            this.endFace();
        }
        if (this.renderBase) {
            this.beginPosZFace();
            this.beginTriangle();
            this.vertex(0.0, 1.0, 1.0, 0.0, 0.0);
            this.vertex(0.0, 0.0, 1.0, 0.0, 1.0);
            this.vertex(1.0, 0.0, 1.0, 1.0, 1.0);
            this.endFace();
            this.rightTriangle();
            this.bottomQuad();
        }
        if (this.renderSecondary) {
            if (this.ridgeAt(0, 0, -1)) {
                this.connectRidgeFront();
            }
            if (this.ridgeAt(1, 0, 0)) {
                this.connectRidgeLeft();
            }
        }
    }

    protected void renderInnerCorner() {
        if (this.renderSecondary) {
            this.beginPosXSlope();
            this.beginTriangle();
            this.vertex(0.0, 1.0, 0.0, 1.0, 0.0);
            this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
            this.vertex(1.0, 0.0, 0.0, 1.0, 1.0);
            this.endFace();
            this.beginNegZSlope();
            this.beginTriangle();
            this.vertex(1.0, 1.0, 1.0, 0.0, 0.0);
            this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
            this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
            this.endFace();
        }
        if (this.renderBase) {
            this.beginNegZFace();
            this.beginTriangle();
            this.vertex(0.0, 1.0, 0.0, 1.0, 0.0);
            this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
            this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
            this.endFace();
            this.leftTriangle();
            this.bottomQuad();
        }
        if (this.valleyAt(0, 0, 1)) {
            this.connectValleyBack();
        } else {
            this.terminateValleyBack();
        }
        if (this.valleyAt(-1, 0, 0)) {
            this.connectValleyRight();
        } else {
            this.terminateValleyRight();
        }
    }

    protected void renderRidge() {
        if (this.renderSecondary) {
            this.beginNegZSlope();
            this.beginQuad();
            this.vertex(1.0, 0.5, 0.5, 0.0, 0.5);
            this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
            this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
            this.vertex(0.0, 0.5, 0.5, 1.0, 0.5);
            this.endFace();
            this.ridgeBackSlope();
            this.ridgeFront(false);
            this.ridgeBack(false);
        }
        if (this.renderBase) {
            this.ridgeLeftFace();
            this.ridgeRightFace();
            this.bottomQuad();
        }
    }

    protected void renderSmartRidge() {
        if (this.renderSecondary) {
            this.ridgeLeft();
            this.ridgeRight();
            this.ridgeBack(true);
            this.ridgeFront(true);
        }
        if (this.renderBase) {
            this.bottomQuad();
        }
    }

    protected void renderValley() {
        this.connectValleyLeft();
        this.connectValleyRight();
        this.smartValleyFront();
        this.smartValleyBack();
        if (this.renderBase) {
            this.bottomQuad();
        }
    }

    protected void renderSmartValley() {
        this.smartValleyLeft();
        this.smartValleyRight();
        this.smartValleyFront();
        this.smartValleyBack();
        if (this.renderBase) {
            this.bottomQuad();
        }
    }

    protected void smartValleyLeft() {
        if (this.valleyOrSlopeAt(1, 0, 0)) {
            this.connectValleyLeft();
        } else {
            this.terminateValleyLeft();
        }
    }

    protected void terminateValleyLeft() {
        if (this.renderSecondary) {
            this.beginNegXSlope();
            this.beginTriangle();
            this.vertex(1.0, 1.0, 0.0, 0.0, 0.0);
            this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
            this.vertex(1.0, 1.0, 1.0, 1.0, 0.0);
            this.endFace();
        }
        if (this.renderBase) {
            this.leftQuad();
        }
    }

    protected void smartValleyRight() {
        if (this.valleyOrSlopeAt(-1, 0, 0)) {
            this.connectValleyRight();
        } else {
            this.terminateValleyRight();
        }
    }

    protected void terminateValleyRight() {
        if (this.renderSecondary) {
            this.beginPosXSlope();
            this.beginTriangle();
            this.vertex(0.0, 1.0, 1.0, 0.0, 0.0);
            this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
            this.vertex(0.0, 1.0, 0.0, 1.0, 0.0);
            this.endFace();
        }
        if (this.renderBase) {
            this.rightQuad();
        }
    }

    protected void smartValleyFront() {
        if (this.valleyOrSlopeAt(0, 0, -1)) {
            this.connectValleyFront();
        } else {
            this.terminateValleyFront();
        }
    }

    protected void terminateValleyFront() {
        if (this.renderSecondary) {
            this.beginPosZSlope();
            this.beginTriangle();
            this.vertex(0.0, 1.0, 0.0, 0.0, 0.0);
            this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
            this.vertex(1.0, 1.0, 0.0, 1.0, 0.0);
            this.endFace();
        }
        if (this.renderBase) {
            this.frontQuad();
        }
    }

    protected void smartValleyBack() {
        if (this.valleyOrSlopeAt(0, 0, 1)) {
            this.connectValleyBack();
        } else {
            this.terminateValleyBack();
        }
    }

    protected void terminateValleyBack() {
        if (this.renderSecondary) {
            this.beginNegZSlope();
            this.beginTriangle();
            this.vertex(1.0, 1.0, 1.0, 0.0, 0.0);
            this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
            this.vertex(0.0, 1.0, 1.0, 1.0, 0.0);
            this.endFace();
        }
        if (this.renderBase) {
            this.backQuad();
        }
    }

    protected void leftQuad() {
        this.beginPosXFace();
        this.beginQuad();
        this.vertex(1.0, 1.0, 1.0, 0.0, 0.0);
        this.vertex(1.0, 0.0, 1.0, 0.0, 1.0);
        this.vertex(1.0, 0.0, 0.0, 1.0, 1.0);
        this.vertex(1.0, 1.0, 0.0, 1.0, 0.0);
        this.endFace();
    }

    protected void rightQuad() {
        this.beginNegXFace();
        this.beginQuad();
        this.vertex(0.0, 1.0, 0.0, 0.0, 0.0);
        this.vertex(0.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(0.0, 0.0, 1.0, 1.0, 1.0);
        this.vertex(0.0, 1.0, 1.0, 1.0, 0.0);
        this.endFace();
    }

    protected void frontQuad() {
        this.beginNegZFace();
        this.beginQuad();
        this.vertex(1.0, 1.0, 0.0, 0.0, 0.0);
        this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
        this.vertex(0.0, 1.0, 0.0, 1.0, 0.0);
        this.endFace();
    }

    protected void backQuad() {
        this.beginPosZFace();
        this.beginQuad();
        this.vertex(0.0, 1.0, 1.0, 0.0, 0.0);
        this.vertex(0.0, 0.0, 1.0, 0.0, 1.0);
        this.vertex(1.0, 0.0, 1.0, 1.0, 1.0);
        this.vertex(1.0, 1.0, 1.0, 1.0, 0.0);
        this.endFace();
    }

    protected void bottomQuad() {
        this.beginBottomFace();
        this.beginQuad();
        this.vertex(0.0, 0.0, 1.0, 0.0, 0.0);
        this.vertex(0.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(1.0, 0.0, 0.0, 1.0, 1.0);
        this.vertex(1.0, 0.0, 1.0, 1.0, 0.0);
        this.endFace();
    }

    protected void leftTriangle() {
        this.beginPosXFace();
        this.beginTriangle();
        this.vertex(1.0, 1.0, 1.0, 0.0, 0.0);
        this.vertex(1.0, 0.0, 1.0, 0.0, 1.0);
        this.vertex(1.0, 0.0, 0.0, 1.0, 1.0);
        this.endFace();
    }

    protected void rightTriangle() {
        this.beginNegXFace();
        this.beginTriangle();
        this.vertex(0.0, 1.0, 1.0, 1.0, 0.0);
        this.vertex(0.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(0.0, 0.0, 1.0, 1.0, 1.0);
        this.endFace();
    }

    protected void ridgeLeftFace() {
        this.beginPosXFace();
        this.beginTriangle();
        this.vertex(1.0, 0.5, 0.5, 0.5, 0.5);
        this.vertex(1.0, 0.0, 1.0, 0.0, 1.0);
        this.vertex(1.0, 0.0, 0.0, 1.0, 1.0);
        this.endFace();
    }

    protected void ridgeRightFace() {
        this.beginNegXFace();
        this.beginTriangle();
        this.vertex(0.0, 0.5, 0.5, 0.5, 0.5);
        this.vertex(0.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(0.0, 0.0, 1.0, 1.0, 1.0);
        this.endFace();
    }

    protected void ridgeBackFace() {
        this.beginPosZFace();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 1.0, 0.5, 0.5);
        this.vertex(0.0, 0.0, 1.0, 0.0, 1.0);
        this.vertex(1.0, 0.0, 1.0, 1.0, 1.0);
        this.endFace();
    }

    protected void ridgeFrontFace() {
        this.beginNegZFace();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.0, 0.5, 0.5);
        this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
        this.endFace();
    }

    protected void ridgeFrontSlope() {
        this.beginNegZSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
        this.endFace();
    }

    protected void ridgeBackSlope() {
        this.beginPosZSlope();
        this.beginQuad();
        this.vertex(0.0, 0.5, 0.5, 0.0, 0.5);
        this.vertex(0.0, 0.0, 1.0, 0.0, 1.0);
        this.vertex(1.0, 0.0, 1.0, 1.0, 1.0);
        this.vertex(1.0, 0.5, 0.5, 1.0, 0.5);
        this.endFace();
    }

    protected void ridgeLeft() {
        if (this.ridgeOrSlopeAt(1, 0, 0)) {
            this.connectRidgeLeft();
        } else {
            this.beginPosXSlope();
            this.beginTriangle();
            this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
            this.vertex(1.0, 0.0, 1.0, 0.0, 1.0);
            this.vertex(1.0, 0.0, 0.0, 1.0, 1.0);
            this.endFace();
        }
    }

    protected void connectRidgeLeft() {
        this.beginNegZSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(1.0, 0.5, 0.5, 0.0, 0.5);
        this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
        this.endFace();
        this.beginPosZSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(1.0, 0.0, 1.0, 1.0, 1.0);
        this.vertex(1.0, 0.5, 0.5, 1.0, 0.5);
        this.endFace();
    }

    protected void ridgeRight() {
        if (this.ridgeOrSlopeAt(-1, 0, 0)) {
            this.connectRidgeRight();
        } else {
            this.beginNegXSlope();
            this.beginTriangle();
            this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
            this.vertex(0.0, 0.0, 0.0, 0.0, 1.0);
            this.vertex(0.0, 0.0, 1.0, 1.0, 1.0);
            this.endFace();
        }
    }

    protected void connectRidgeRight() {
        this.beginNegZSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
        this.vertex(0.0, 0.5, 0.5, 1.0, 0.5);
        this.endFace();
        this.beginPosZSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(0.0, 0.5, 0.5, 0.0, 0.5);
        this.vertex(0.0, 0.0, 1.0, 0.0, 1.0);
        this.endFace();
    }

    protected void ridgeFront(boolean fill) {
        if (this.ridgeOrSlopeAt(0, 0, -1)) {
            this.connectRidgeFront();
        } else if (fill) {
            this.beginNegZSlope();
            this.beginTriangle();
            this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
            this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
            this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
            this.endFace();
        }
    }

    protected void connectRidgeFront() {
        this.beginPosXSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(1.0, 0.0, 0.0, 1.0, 1.0);
        this.vertex(0.5, 0.5, 0.0, 1.0, 0.5);
        this.endFace();
        this.beginNegXSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(0.5, 0.5, 0.0, 0.0, 0.5);
        this.vertex(0.0, 0.0, 0.0, 0.0, 1.0);
        this.endFace();
    }

    protected void ridgeBack(boolean fill) {
        if (this.ridgeOrSlopeAt(0, 0, 1)) {
            this.connectRidgeBack();
        } else if (fill) {
            this.beginPosZSlope();
            this.beginTriangle();
            this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
            this.vertex(0.0, 0.0, 1.0, 0.0, 1.0);
            this.vertex(1.0, 0.0, 1.0, 1.0, 1.0);
            this.endFace();
        }
    }

    protected void connectRidgeBack() {
        this.beginPosXSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(0.5, 0.5, 1.0, 0.0, 0.5);
        this.vertex(1.0, 0.0, 1.0, 0.0, 1.0);
        this.endFace();
        this.beginNegXSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(0.0, 0.0, 1.0, 1.0, 1.0);
        this.vertex(0.5, 0.5, 1.0, 1.0, 0.5);
        this.endFace();
    }

    protected void connectValleyLeft() {
        this.beginPosZSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(1.0, 0.5, 0.5, 1.0, 0.5);
        this.vertex(1.0, 1.0, 0.0, 1.0, 0.0);
        this.endFace();
        this.beginNegZSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(1.0, 1.0, 1.0, 0.0, 0.0);
        this.vertex(1.0, 0.5, 0.5, 0.0, 0.5);
        this.endFace();
        this.valleyEndLeft();
    }

    protected void connectValleyRight() {
        this.beginPosZSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(0.0, 1.0, 0.0, 0.0, 0.0);
        this.vertex(0.0, 0.5, 0.5, 0.0, 0.5);
        this.endFace();
        this.beginNegZSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(0.0, 0.5, 0.5, 1.0, 0.5);
        this.vertex(0.0, 1.0, 1.0, 1.0, 0.0);
        this.endFace();
        this.valleyEndRight();
    }

    protected void connectValleyFront() {
        this.beginPosXSlope();
        this.beginTriangle();
        this.vertex(0.0, 1.0, 0.0, 1.0, 0.0);
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(0.5, 0.5, 0.0, 1.0, 0.5);
        this.endFace();
        this.beginNegXSlope();
        this.beginTriangle();
        this.vertex(1.0, 1.0, 0.0, 0.0, 0.0);
        this.vertex(0.5, 0.5, 0.0, 0.0, 0.5);
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.endFace();
        this.valleyEndFront();
    }

    protected void connectValleyBack() {
        this.beginPosXSlope();
        this.beginTriangle();
        this.vertex(0.0, 1.0, 1.0, 0.0, 0.0);
        this.vertex(0.5, 0.5, 1.0, 0.0, 0.5);
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.endFace();
        this.beginNegXSlope();
        this.beginTriangle();
        this.vertex(1.0, 1.0, 1.0, 1.0, 0.0);
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(0.5, 0.5, 1.0, 1.0, 0.5);
        this.endFace();
        this.valleyEndBack();
    }

    protected void valleyEndLeft() {
        this.beginPosXFace();
        this.beginTriangle();
        this.vertex(1.0, 1.0, 1.0, 0.0, 0.0);
        this.vertex(1.0, 0.0, 1.0, 0.0, 1.0);
        this.vertex(1.0, 0.5, 0.5, 0.5, 0.5);
        this.newTriangle();
        this.vertex(1.0, 0.0, 1.0, 0.0, 1.0);
        this.vertex(1.0, 0.0, 0.0, 1.0, 1.0);
        this.vertex(1.0, 0.5, 0.5, 0.5, 0.5);
        this.newTriangle();
        this.vertex(1.0, 0.0, 0.0, 1.0, 1.0);
        this.vertex(1.0, 1.0, 0.0, 1.0, 0.0);
        this.vertex(1.0, 0.5, 0.5, 0.5, 0.5);
        this.endFace();
    }

    protected void valleyEndRight() {
        this.beginNegXFace();
        this.beginTriangle();
        this.vertex(0.0, 0.0, 1.0, 1.0, 1.0);
        this.vertex(0.0, 1.0, 1.0, 1.0, 0.0);
        this.vertex(0.0, 0.5, 0.5, 0.5, 0.5);
        this.newTriangle();
        this.vertex(0.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(0.0, 0.0, 1.0, 1.0, 1.0);
        this.vertex(0.0, 0.5, 0.5, 0.5, 0.5);
        this.newTriangle();
        this.vertex(0.0, 1.0, 0.0, 0.0, 0.0);
        this.vertex(0.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(0.0, 0.5, 0.5, 0.5, 0.5);
        this.endFace();
    }

    protected void valleyEndFront() {
        this.beginNegZFace();
        this.beginTriangle();
        this.vertex(1.0, 1.0, 0.0, 0.0, 0.0);
        this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(0.5, 0.5, 0.0, 0.5, 0.5);
        this.newTriangle();
        this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(1.0, 0.0, 0.0, 1.0, 1.0);
        this.vertex(0.5, 0.5, 0.0, 0.5, 0.5);
        this.newTriangle();
        this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
        this.vertex(0.0, 1.0, 0.0, 1.0, 0.0);
        this.vertex(0.5, 0.5, 0.0, 0.5, 0.5);
        this.endFace();
    }

    protected void valleyEndBack() {
        this.beginPosZFace();
        this.beginTriangle();
        this.vertex(0.0, 1.0, 1.0, 0.0, 0.0);
        this.vertex(0.0, 0.0, 1.0, 0.0, 1.0);
        this.vertex(0.5, 0.5, 1.0, 0.5, 0.5);
        this.newTriangle();
        this.vertex(0.0, 0.0, 1.0, 0.0, 1.0);
        this.vertex(1.0, 0.0, 1.0, 1.0, 1.0);
        this.vertex(0.5, 0.5, 1.0, 0.5, 0.5);
        this.newTriangle();
        this.vertex(1.0, 0.0, 1.0, 1.0, 1.0);
        this.vertex(1.0, 1.0, 1.0, 1.0, 0.0);
        this.vertex(0.5, 0.5, 1.0, 0.5, 0.5);
        this.endFace();
    }

    protected boolean ridgeAt(int dx, int dy, int dz) {
        return this.hasNeighbour(dx, dy, dz, ridgeShapes);
    }

    protected boolean ridgeOrSlopeAt(int dx, int dy, int dz) {
        return this.hasNeighbour(dx, dy, dz, ridgeOrSlopeShapes);
    }

    protected boolean valleyAt(int dx, int dy, int dz) {
        return this.hasNeighbour(dx, dy, dz, valleyShapes);
    }

    protected boolean valleyOrSlopeAt(int dx, int dy, int dz) {
        return this.hasNeighbour(dx, dy, dz, valleyOrSlopeShapes);
    }

    protected boolean hasNeighbour(int dx, int dy, int dz, Shape[] shapes) {
        EnumFacing dir = this.t.v(dx, dy, dz).facing();
        TileShape nte = this.te.getConnectedNeighbourGlobal(dir);
        if (nte != null) {
            for (int i = 0; i < shapes.length; ++i) {
                if (nte.shape != shapes[i]) continue;
                return true;
            }
        }
        return false;
    }

    protected void beginTopFace() {
        this.beginOuterFaces(Vector3.unitY);
    }

    protected void beginBottomFace() {
        this.beginOuterFaces(Vector3.unitNY);
    }

    protected void beginPosXFace() {
        this.beginOuterFaces(Vector3.unitX);
    }

    protected void beginNegXFace() {
        this.beginOuterFaces(Vector3.unitNX);
    }

    protected void beginPosZFace() {
        this.beginOuterFaces(Vector3.unitZ);
    }

    protected void beginNegZFace() {
        this.beginOuterFaces(Vector3.unitNZ);
    }

    protected void beginPosXSlope() {
        this.beginInnerFaces(Vector3.unitPXPY);
    }

    protected void beginNegXSlope() {
        this.beginInnerFaces(Vector3.unitNXPY);
    }

    protected void beginPosZSlope() {
        this.beginInnerFaces(Vector3.unitPYPZ);
    }

    protected void beginNegZSlope() {
        this.beginInnerFaces(Vector3.unitPYNZ);
    }

    protected void beginInnerFaces(Vector3 n) {
        this.outerFace = false;
        this.normal(n);
        this.target.setTexture(this.textures[2]);
        this.target.setColor(this.getSecondaryColourMult());
    }

    protected void beginOuterFaces(Vector3 n) {
        this.outerFace = true;
        this.normal(n);
        this.target.setTexture(this.textures[1]);
        this.target.setColor(this.getBaseColourMult());
    }

    protected void beginTriangle() {
        this.target.beginTriangle();
    }

    protected void beginQuad() {
        this.target.beginQuad();
    }

    protected void newTriangle() {
        this.endFace();
        this.beginTriangle();
    }

    protected void newQuad() {
        this.endFace();
        this.beginQuad();
    }

    protected void endFace() {
        this.target.endFace();
    }

    protected void normal(Vector3 n) {
        Vector3 tn = this.t.v(n);
        this.face = tn.facing();
        this.target.setNormal(tn);
    }

    protected void vertex(double x, double y, double z, double u, double v) {
        Vector3 q = this.t.p(x - 0.5, y - 0.5, z - 0.5);
        this.target.addVertex(q, u, v);
    }
}

