/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.components;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.superfactory.Localization;
import vswe.superfactory.components.ComponentMenu;
import vswe.superfactory.components.FlowComponent;
import vswe.superfactory.components.RadioButton;
import vswe.superfactory.components.RadioButtonList;
import vswe.superfactory.components.TextBoxNumber;
import vswe.superfactory.components.TextBoxNumberList;
import vswe.superfactory.interfaces.ContainerManager;
import vswe.superfactory.interfaces.GuiManager;
import vswe.superfactory.network.packets.DataBitHelper;
import vswe.superfactory.network.packets.DataReader;
import vswe.superfactory.network.packets.DataWriter;
import vswe.superfactory.network.packets.PacketHandler;

public class ComponentMenuRedstoneOutput
extends ComponentMenu {
    private static final String NBT_NUMBER = "Strength";
    private static final String NBT_TYPE = "OutputType";
    private static final int RADIO_BUTTON_X = 5;
    private static final int RADIO_BUTTON_Y = 22;
    private static final int RADIO_SPACING_X = 68;
    private static final int RADIO_SPACING_Y = 12;
    private static final int TEXT_BOX_X = 80;
    private static final int TEXT_BOX_Y = 5;
    private static final int TEXT_X = 5;
    private static final int TEXT_Y = 9;
    private RadioButtonList radioButtons;
    private TextBoxNumber textBox;
    private TextBoxNumberList textBoxes = new TextBoxNumberList();

    public ComponentMenuRedstoneOutput(FlowComponent parent) {
        super(parent);
        this.textBox = new TextBoxNumber(80, 5, 2, true){

            @Override
            public int getMaxNumber() {
                return 15;
            }

            @Override
            public void onNumberChanged() {
                DataWriter dw = ComponentMenuRedstoneOutput.this.getWriterForServerComponentPacket();
                dw.writeBoolean(true);
                dw.writeData(this.getNumber(), DataBitHelper.MENU_REDSTONE_ANALOG);
                PacketHandler.sendDataToServer(dw);
            }
        };
        this.textBoxes.addTextBox(this.textBox);
        this.textBox.setNumber(15);
        this.radioButtons = new RadioButtonList(){

            @Override
            public void updateSelectedOption(int selectedOption) {
                this.setSelectedOption(selectedOption);
                DataWriter dw = ComponentMenuRedstoneOutput.this.getWriterForServerComponentPacket();
                dw.writeBoolean(false);
                dw.writeData(selectedOption, DataBitHelper.MENU_REDSTONE_OUTPUT_TYPE);
                PacketHandler.sendDataToServer(dw);
            }
        };
        for (int i = 0; i < Settings.values().length; ++i) {
            int ix = i % 2;
            int iy = i / 2;
            int x = 5 + ix * 68;
            int y = 22 + iy * 12;
            this.radioButtons.add(new RadioButton(x, y, Settings.values()[i].getName()));
        }
    }

    public int getSelectedStrength() {
        return this.textBox.getNumber();
    }

    @Override
    public String getName() {
        return Localization.REDSTONE_OUTPUT_MENU.toString();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiManager gui, int mX, int mY) {
        if (this.useStrengthSetting()) {
            gui.drawString(Localization.REDSTONE_STRENGTH.toString(), 5, 9, 0.7f, 0x404040);
            this.textBoxes.draw(gui, mX, mY);
        } else {
            gui.drawString(Localization.DIGITAL_TOGGLE.toString(), 5, 9, 0.7f, 0x404040);
        }
        this.radioButtons.draw(gui, mX, mY);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawMouseOver(GuiManager gui, int mX, int mY) {
    }

    @Override
    public void onClick(int mX, int mY, int button) {
        if (this.useStrengthSetting()) {
            this.textBoxes.onClick(mX, mY, button);
        }
        this.radioButtons.onClick(mX, mY, button);
    }

    @Override
    public void onDrag(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    public void onRelease(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onKeyStroke(GuiManager gui, char c, int k) {
        if (this.useStrengthSetting()) {
            return this.textBoxes.onKeyStroke(gui, c, k);
        }
        return super.onKeyStroke(gui, c, k);
    }

    @Override
    public void writeData(DataWriter dw) {
        dw.writeData(this.textBox.getNumber(), DataBitHelper.MENU_REDSTONE_ANALOG);
        dw.writeData(this.radioButtons.getSelectedOption(), DataBitHelper.MENU_REDSTONE_OUTPUT_TYPE);
    }

    @Override
    public void readData(DataReader dr) {
        this.textBox.setNumber(dr.readData(DataBitHelper.MENU_REDSTONE_ANALOG));
        this.radioButtons.setSelectedOption(dr.readData(DataBitHelper.MENU_REDSTONE_OUTPUT_TYPE));
    }

    @Override
    public void copyFrom(ComponentMenu menu) {
        ComponentMenuRedstoneOutput menuOutput = (ComponentMenuRedstoneOutput)menu;
        this.textBox.setNumber(menuOutput.textBox.getNumber());
        this.radioButtons.setSelectedOption(menuOutput.radioButtons.getSelectedOption());
    }

    @Override
    public void refreshData(ContainerManager container, ComponentMenu newData) {
        DataWriter dw;
        ComponentMenuRedstoneOutput newDataOutput = (ComponentMenuRedstoneOutput)newData;
        if (this.textBox.getNumber() != newDataOutput.textBox.getNumber()) {
            this.textBox.setNumber(newDataOutput.textBox.getNumber());
            dw = this.getWriterForClientComponentPacket(container);
            dw.writeBoolean(true);
            dw.writeData(this.textBox.getNumber(), DataBitHelper.MENU_REDSTONE_ANALOG);
            PacketHandler.sendDataToListeningClients(container, dw);
        }
        if (this.radioButtons.getSelectedOption() != newDataOutput.radioButtons.getSelectedOption()) {
            this.radioButtons.setSelectedOption(newDataOutput.radioButtons.getSelectedOption());
            dw = this.getWriterForClientComponentPacket(container);
            dw.writeBoolean(false);
            dw.writeData(this.radioButtons.getSelectedOption(), DataBitHelper.MENU_REDSTONE_OUTPUT_TYPE);
            PacketHandler.sendDataToListeningClients(container, dw);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound, int version, boolean pickup) {
        this.textBox.setNumber(nbtTagCompound.func_74771_c(NBT_NUMBER));
        this.radioButtons.setSelectedOption(nbtTagCompound.func_74771_c(NBT_TYPE));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound, boolean pickup) {
        nbtTagCompound.func_74774_a(NBT_NUMBER, (byte)this.textBox.getNumber());
        nbtTagCompound.func_74774_a(NBT_TYPE, (byte)this.radioButtons.getSelectedOption());
    }

    private boolean useStrengthSetting() {
        return this.getSelectedSetting() != Settings.TOGGLE;
    }

    public Settings getSelectedSetting() {
        return Settings.values()[this.radioButtons.getSelectedOption()];
    }

    @Override
    public void readNetworkComponent(DataReader dr) {
        boolean isNumber = dr.readBoolean();
        if (isNumber) {
            this.textBox.setNumber(dr.readData(DataBitHelper.MENU_REDSTONE_ANALOG));
        } else {
            int type = dr.readData(DataBitHelper.MENU_REDSTONE_OUTPUT_TYPE);
            this.radioButtons.setSelectedOption(type);
        }
    }

    public static enum Settings {
        FIXED(Localization.FIXED),
        TOGGLE(Localization.TOGGLE),
        MAX(Localization.MAX),
        MIN(Localization.MIN),
        INCREASE(Localization.INCREASE),
        DECREASE(Localization.DECREASE),
        FORWARD(Localization.FORWARD),
        BACKWARD(Localization.BACKWARD);

        private Localization name;

        private Settings(Localization name) {
            this.name = name;
        }

        public Localization getName() {
            return this.name;
        }

        public String toString() {
            return this.name.toString();
        }
    }
}

