/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.util;

import com.bloodnbonesgaming.dimensionalcontrol.DimensionalControl;
import com.bloodnbonesgaming.dimensionalcontrol.config.chunkprovider.ChunkGeneratorDefinition;
import com.bloodnbonesgaming.dimensionalcontrol.config.chunkprovider.ChunkGeneratorDefinitionOverride;
import com.bloodnbonesgaming.dimensionalcontrol.config.chunkprovider.ChunkGeneratorDefinitionSkyIslands;
import com.bloodnbonesgaming.dimensionalcontrol.world.chunkgenerator.ChunkGeneratorCave;
import com.bloodnbonesgaming.dimensionalcontrol.world.chunkgenerator.ChunkGeneratorOverride;
import com.bloodnbonesgaming.dimensionalcontrol.world.chunkgenerator.ChunkGeneratorOverworldCustom;
import com.bloodnbonesgaming.dimensionalcontrol.world.chunkgenerator.ChunkGeneratorRealistic;
import com.bloodnbonesgaming.dimensionalcontrol.world.chunkgenerator.ChunkGeneratorSky2;
import com.bloodnbonesgaming.dimensionalcontrol.world.chunkgenerator.ChunkGeneratorSkyIdealistic;
import com.bloodnbonesgaming.dimensionalcontrol.world.chunkgenerator.ChunkGeneratorVoid;
import com.bloodnbonesgaming.dimensionalcontrol.world.chunkgenerator.ChunkGeneratorWorleyCave;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGeneratorEnd;
import net.minecraft.world.gen.ChunkGeneratorFlat;
import net.minecraft.world.gen.ChunkGeneratorHell;
import net.minecraft.world.gen.ChunkGeneratorOverworld;
import net.minecraft.world.gen.IChunkGenerator;

public enum ChunkGeneratorType {
    SURFACE{

        @Override
        protected IChunkGenerator createChunkGenerator(World world, ChunkGeneratorDefinition definition) {
            String generationOptions = definition == null ? null : definition.getGenerationOptions();
            return new ChunkGeneratorOverworld(world, world.func_72905_C(), world.func_72912_H().func_76089_r(), generationOptions != null ? generationOptions : world.func_72912_H().func_82571_y());
        }

        @Override
        public ChunkGeneratorDefinition createDefinition() {
            return new ChunkGeneratorDefinition();
        }
    }
    ,
    FLAT{

        @Override
        protected IChunkGenerator createChunkGenerator(World world, ChunkGeneratorDefinition definition) {
            String generationOptions = definition == null ? null : definition.getGenerationOptions();
            return new ChunkGeneratorFlat(world, world.func_72905_C(), world.func_72912_H().func_76089_r(), generationOptions != null ? generationOptions : world.func_72912_H().func_82571_y());
        }

        @Override
        public ChunkGeneratorDefinition createDefinition() {
            return new ChunkGeneratorDefinition();
        }
    }
    ,
    HELL{

        @Override
        protected IChunkGenerator createChunkGenerator(World world, ChunkGeneratorDefinition definition) {
            return new ChunkGeneratorHell(world, world.func_72912_H().func_76089_r(), world.func_72905_C());
        }

        @Override
        public ChunkGeneratorDefinition createDefinition() {
            return new ChunkGeneratorDefinition();
        }
    }
    ,
    END{

        @Override
        protected IChunkGenerator createChunkGenerator(World world, ChunkGeneratorDefinition definition) {
            return new ChunkGeneratorEnd(world, world.func_72912_H().func_76089_r(), world.func_72905_C(), world.field_73011_w.func_177496_h());
        }

        @Override
        public ChunkGeneratorDefinition createDefinition() {
            return new ChunkGeneratorDefinition();
        }
    }
    ,
    VOID{

        @Override
        protected IChunkGenerator createChunkGenerator(World world, ChunkGeneratorDefinition definition) {
            String generationOptions = definition == null ? null : definition.getGenerationOptions();
            return new ChunkGeneratorVoid(world, world.func_72905_C(), generationOptions != null ? generationOptions : world.func_72912_H().func_82571_y());
        }

        @Override
        public ChunkGeneratorDefinition createDefinition() {
            return new ChunkGeneratorDefinition();
        }
    }
    ,
    BIOME_OVERRIDE{

        @Override
        protected IChunkGenerator createChunkGenerator(World world, ChunkGeneratorDefinition definition) {
            String generationOptions = definition == null ? null : definition.getGenerationOptions();
            return new ChunkGeneratorOverride(world, world.func_72905_C(), world.func_72912_H().func_76089_r(), generationOptions != null ? generationOptions : world.func_72912_H().func_82571_y(), (ChunkGeneratorDefinitionOverride)definition);
        }

        @Override
        public ChunkGeneratorDefinition createDefinition() {
            return new ChunkGeneratorDefinitionOverride();
        }
    }
    ,
    CAVE{

        @Override
        protected IChunkGenerator createChunkGenerator(World world, ChunkGeneratorDefinition definition) {
            return new ChunkGeneratorCave(world, world.func_72912_H().func_76089_r(), world.func_72905_C());
        }

        @Override
        public ChunkGeneratorDefinition createDefinition() {
            return new ChunkGeneratorDefinition();
        }
    }
    ,
    SKY_ISLANDS{

        @Override
        protected IChunkGenerator createChunkGenerator(World world, ChunkGeneratorDefinition definition) {
            String generationOptions = definition == null ? null : definition.getGenerationOptions();
            return new ChunkGeneratorSkyIdealistic((ChunkGeneratorDefinitionSkyIslands)definition, world, world.func_72905_C(), generationOptions != null ? generationOptions : world.func_72912_H().func_82571_y());
        }

        @Override
        public ChunkGeneratorDefinition createDefinition() {
            return new ChunkGeneratorDefinitionSkyIslands();
        }
    }
    ,
    TEST{

        @Override
        protected IChunkGenerator createChunkGenerator(World world, ChunkGeneratorDefinition definition) {
            return new ChunkGeneratorRealistic(world, world.func_72905_C(), world.func_72912_H().func_76089_r(), world.func_72912_H().func_82571_y());
        }

        @Override
        public ChunkGeneratorDefinition createDefinition() {
            return new ChunkGeneratorDefinition();
        }
    }
    ,
    TEST_OVERWORLD{

        @Override
        protected IChunkGenerator createChunkGenerator(World world, ChunkGeneratorDefinition definition) {
            return new ChunkGeneratorOverworldCustom(world, world.func_72912_H().func_82571_y(), (ChunkGeneratorDefinitionOverride)definition);
        }

        @Override
        public ChunkGeneratorDefinition createDefinition() {
            return new ChunkGeneratorDefinitionOverride();
        }
    }
    ,
    WORLEY_CAVES{

        @Override
        protected IChunkGenerator createChunkGenerator(World world, ChunkGeneratorDefinition definition) {
            return new ChunkGeneratorWorleyCave(world);
        }

        @Override
        public ChunkGeneratorDefinition createDefinition() {
            return new ChunkGeneratorDefinitionOverride();
        }
    }
    ,
    TEST_SKY_ISLANDS{

        @Override
        protected IChunkGenerator createChunkGenerator(World world, ChunkGeneratorDefinition definition) {
            String generationOptions = definition == null ? null : definition.getGenerationOptions();
            return new ChunkGeneratorSky2(world);
        }

        @Override
        public ChunkGeneratorDefinition createDefinition() {
            return new ChunkGeneratorDefinitionSkyIslands();
        }
    };


    protected abstract IChunkGenerator createChunkGenerator(World var1, ChunkGeneratorDefinition var2);

    public IChunkGenerator getChunkGenerator(World world, ChunkGeneratorDefinition definition) {
        IChunkGenerator manager = this.createChunkGenerator(world, definition);
        if (manager == null) {
            DimensionalControl.instance.getLog().error((Object)("No ChunkProvider found for: " + this.toString()));
        }
        return manager;
    }

    public abstract ChunkGeneratorDefinition createDefinition();
}

