/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.config.chunkprovider;

import com.bloodnbonesgaming.dimensionalcontrol.config.chunkprovider.ChunkGeneratorDefinition;
import com.bloodnbonesgaming.dimensionalcontrol.config.data.BlockData;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import net.minecraft.block.state.IBlockState;

@ScriptClassDocumentation(documentationFile="./config/dimensionalcontrol/documentation/chunkgenerators/SkyIslands", classExplaination="This ChunkGenerator is for creating custom sky islands. The islands are generated randomly within a grid system. The set region size is the size of the grid squares. One island will generate in each grid square, placed randomly in the available space. This means the minimum range between islands is 0, and the maximum range is `region size - (island radius * 2)`. Islands are generated by shaping 3D noise with a shaped distance value to create a 'density' value.")
public class ChunkGeneratorDefinitionSkyIslands
extends ChunkGeneratorDefinition {
    protected IBlockState mainBlock;
    protected int regionSize = 512;
    protected int maxIslandRadius = 100;
    protected int minIslandHeight = 0;
    protected int maxIslandHeight = 236;
    protected double minBlockValue = 0.3;
    protected double xStretch = 1.0;
    protected double zStretch = 1.0;
    protected double yBottomStretch = 2.0;
    protected double noiseSizeX = 128.0;
    protected double noiseSizeY = 192.0;
    protected double noiseSizeZ = 128.0;
    protected int noiseOctaves = 6;
    protected double noisePersistence = 0.45;
    protected boolean generateBiomeBlocks = true;
    protected boolean decorateBiomes = true;
    protected boolean populateAnimals = true;
    protected boolean populateIce = true;
    protected boolean populateLakes = true;
    protected boolean populateLavaLakes = true;

    @ScriptMethodDocumentation(defaultValues="minecraft:stone", args="String", usage="block id", notes="Sets the main block for the island.")
    public void setMainBlock(String blockName) {
        this.setMainBlock(blockName, null);
    }

    @ScriptMethodDocumentation(args="String, Integer", usage="block id, meta", notes="Sets the main block for the island.")
    public void setMainBlock(String blockName, Integer meta) {
        BlockData data = new BlockData();
        data.setBlock(blockName, meta);
        this.setMainBlock(data);
    }

    public void setMainBlock(BlockData data) {
        this.mainBlock = data.buildBlockState();
    }

    @ScriptMethodDocumentation(defaultValues="512", args="int", usage="region size", notes="Sets the island region size.")
    public void setRegionSize(int regionSize) {
        this.regionSize = regionSize;
    }

    @ScriptMethodDocumentation(defaultValues="0", args="int", usage="height", notes="Sets the minimum height for the bottom of the island.")
    public void setIslandHeightMin(int height) {
        this.minIslandHeight = height;
    }

    @ScriptMethodDocumentation(defaultValues="236", args="int", usage="height", notes="Sets the maximum height for the top of the island.")
    public void setIslandHeightMax(int height) {
        this.maxIslandHeight = height;
    }

    @ScriptMethodDocumentation(defaultValues="100", args="int", usage="radius", notes="Sets the max island radius.")
    public void setMaxIslandRadius(int radius) {
        this.maxIslandRadius = radius;
    }

    @ScriptMethodDocumentation(defaultValues="0.3", args="double", usage="density", notes="Sets the minimum `density` value required for blocks to be placed.")
    public void setMinBlockDensity(double density) {
        this.minBlockValue = density;
    }

    @ScriptMethodDocumentation(defaultValues="1, 2, 1", args="double, double, double", usage="x stretch, y bottom stretch, z stretch", notes="Sets the distance stretch values for the island.")
    public void setDistanceStretch(double x, double y, double z) {
        this.xStretch = x;
        this.yBottomStretch = y;
        this.zStretch = z;
    }

    @ScriptMethodDocumentation(defaultValues="128, 192, 128", args="double, double, double", usage="x size, y size, z size", notes="Sets the noise sizes for the island.")
    public void setNoiseSize(double x, double y, double z) {
        this.noiseSizeX = x;
        this.noiseSizeY = y;
        this.noiseSizeZ = z;
    }

    @ScriptMethodDocumentation(defaultValues="6", args="int", usage="octaves", notes="Sets the number of octaves used for the island noise.")
    public void setNoiseOctaves(int octaves) {
        this.noiseOctaves = octaves;
    }

    @ScriptMethodDocumentation(defaultValues="0.45", args="double", usage="persistence", notes="Sets how much each octave of noise is used compared to the one before it.")
    public void setNoisePersistence(double persistence) {
        this.noisePersistence = persistence;
    }

    @ScriptMethodDocumentation(defaultValues="true", args="boolean", usage="", notes="Sets if biome blocks should be generated.")
    public void generateBiomeBlocks(boolean bool) {
        this.generateBiomeBlocks = bool;
    }

    @ScriptMethodDocumentation(defaultValues="true", args="boolean", usage="", notes="Sets if biomes should be decorated.")
    public void decorateBiomes(boolean bool) {
        this.decorateBiomes = bool;
    }

    @ScriptMethodDocumentation(defaultValues="true", args="boolean", usage="", notes="Sets if animals should be populated.")
    public void populateAnimals(boolean bool) {
        this.populateAnimals = bool;
    }

    @ScriptMethodDocumentation(defaultValues="true", args="boolean", usage="", notes="Sets if ice/snow should be populated.")
    public void populateIce(boolean bool) {
        this.populateIce = bool;
    }

    @ScriptMethodDocumentation(defaultValues="true", args="boolean", usage="", notes="Sets if lakes should be populated.")
    public void populateLakes(boolean bool) {
        this.populateLakes = bool;
    }

    @ScriptMethodDocumentation(defaultValues="true", args="boolean", usage="", notes="Sets if lava lakes should be populated.")
    public void populateLavaLakes(boolean bool) {
        this.populateLavaLakes = bool;
    }

    public int getMinIslandHeight() {
        return this.minIslandHeight;
    }

    public int getMaxIslandHeight() {
        return this.maxIslandHeight;
    }

    public IBlockState getMainBlock() {
        return this.mainBlock;
    }

    public int getRegionSize() {
        return this.regionSize;
    }

    public int getMaxIslandRadius() {
        return this.maxIslandRadius;
    }

    public double getMinBlockValue() {
        return this.minBlockValue;
    }

    public double getxStretch() {
        return this.xStretch;
    }

    public double getzStretch() {
        return this.zStretch;
    }

    public double getyBottomStretch() {
        return this.yBottomStretch;
    }

    public double getNoiseSizeX() {
        return this.noiseSizeX;
    }

    public double getNoiseSizeY() {
        return this.noiseSizeY;
    }

    public double getNoiseSizeZ() {
        return this.noiseSizeZ;
    }

    public int getNoiseOctaves() {
        return this.noiseOctaves;
    }

    public double getNoisePersistence() {
        return this.noisePersistence;
    }

    public boolean isGenerateBiomeBlocks() {
        return this.generateBiomeBlocks;
    }

    public boolean isDecorateBiomes() {
        return this.decorateBiomes;
    }

    public boolean isPopulateAnimals() {
        return this.populateAnimals;
    }

    public boolean isPopulateIce() {
        return this.populateIce;
    }

    public boolean isPopulateLakes() {
        return this.populateLakes;
    }

    public boolean isPopulateLavaLakes() {
        return this.populateLavaLakes;
    }
}

