/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.config;

import com.bloodnbonesgaming.dimensionalcontrol.config.data.ItemData;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class PortalDefinition {
    private int dimensionID1;
    private int dimensionID2;
    private Block block = null;
    private Integer meta = null;
    private IBlockState state = null;
    private String oreDict = null;
    private ItemData igniter = null;
    private ItemPredicate predicate = null;

    public void setDimension(int dimensionID1, int dimensionID2) {
        this.dimensionID1 = dimensionID1;
        this.dimensionID2 = dimensionID2;
    }

    public void setBlock(String blockID, Integer meta) throws Exception {
        Block block = Block.func_149684_b((String)blockID);
        if (block == null) {
            throw new Exception("Cannot find block: " + blockID);
        }
        this.block = block;
        this.meta = meta;
        this.state = meta != null ? block.func_176203_a(meta.intValue()) : block.func_176223_P();
        this.oreDict = null;
    }

    public void setOreDict(String oreDict) throws Exception {
        this.oreDict = oreDict;
        NonNullList ores = OreDictionary.getOres((String)this.oreDict, (boolean)false);
        IBlockState state = null;
        if (!ores.isEmpty()) {
            for (ItemStack stack : ores) {
                if (!(stack.func_77973_b() instanceof ItemBlock)) continue;
                state = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
                break;
            }
        } else {
            throw new Exception("Ore dict is empty!");
        }
        this.state = state;
    }

    public ItemData getIgniter() {
        if (this.igniter == null) {
            this.igniter = new ItemData();
        }
        return this.igniter;
    }

    public ItemPredicate getIgniterPredicate() {
        if (this.predicate == null && this.igniter != null) {
            this.predicate = this.igniter.buildItemPredicate();
        }
        return this.predicate;
    }

    public int getDimensionID1() {
        return this.dimensionID1;
    }

    public int getDimensionID2() {
        return this.dimensionID2;
    }

    public boolean correctBlock(IBlockState state) {
        if (this.oreDict != null) {
            Block block = state.func_177230_c();
            Item item = Item.func_150898_a((Block)block);
            if (item != Items.field_190931_a) {
                ItemStack itemStack = new ItemStack(item, 1, block.func_180651_a(state));
                NonNullList ores = OreDictionary.getOres((String)this.oreDict, (boolean)false);
                if (!ores.isEmpty()) {
                    for (ItemStack stack : ores) {
                        if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)itemStack, (boolean)false)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        return this.meta != null ? state == this.state : state.func_177230_c() == this.block;
    }

    public IBlockState getStateForPlacement() {
        return this.state;
    }
}

