/*
 * Decompiled with CFR 0.152.
 */
package scavenge.world.blockEffects;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.ChoiceElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.BlockEntry;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.IntCounter;
import scavenge.api.utils.JsonUtil;
import scavenge.api.world.IDelivered;
import scavenge.api.world.IWorldHandler;

public class PropPerBlock
extends BaseResourceProperty
implements IResourceEffect {
    String id;
    int usage;
    int max;
    int min;
    boolean decrease;
    BlockEntry replacement;
    double chance;

    public PropPerBlock(JsonObject obj) {
        super(obj, "per_block_limit");
        this.addIncompats("per_block_limit", "per_player_limit", "per_chunk_limit");
        this.id = JsonUtil.getOrDefault(obj, "id", null);
        if (JsonUtil.getOrDefault(obj, "increase", true)) {
            this.decrease = false;
            this.min = 0;
            this.max = obj.get("max").getAsInt();
            this.usage = JsonUtil.getOrDefault(obj, "usage", 1);
        } else {
            this.decrease = true;
            this.min = JsonUtil.getOrDefault(obj, "min", 0);
            this.max = obj.get("max").getAsInt();
            this.usage = JsonUtil.getOrDefault(obj, "usage", 1);
        }
        if (obj.has("replacement")) {
            obj = obj.getAsJsonObject("replacement");
            this.replacement = JsonUtil.createBlockWithMeta(obj);
            this.chance = obj.get("chance").getAsDouble();
        } else {
            this.replacement = new BlockEntry(Blocks.field_150350_a, 0);
            this.chance = 0.0;
        }
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        IWorldHandler handler = this.getHandler(world);
        IDelivered<IntCounter> helper = handler.getCounterPerBlock(this.id == null ? resourceID : this.id, pos);
        IntCounter counter = helper.get();
        if (this.decrease) {
            if (counter.getCurrentValue() < this.min) {
                return false;
            }
            counter.decrease(this.usage, this.min);
            helper.onChanged();
            world.func_175715_c(pos.hashCode(), pos, this.getValue(counter.getCurrentValue()));
            return false;
        }
        counter.increase(this.usage);
        helper.onChanged();
        if (counter.getCurrentValue() >= this.max) {
            helper.remove();
            world.func_175715_c(pos.hashCode(), pos, 10);
            handler.removeBlockUnbreaking(pos);
            if (this.chance >= world.field_73012_v.nextDouble() * 100.0) {
                world.func_175656_a(pos, this.replacement.getBlockState());
                return true;
            }
            world.func_175698_g(pos);
            return false;
        }
        return false;
    }

    public int getValue(int value) {
        float result = (float)value / (float)this.max;
        return (int)(result * 9.0f);
    }

    public static class PerBlockFactory
    extends BaseResourceFactory {
        public PerBlockFactory() {
            super("per_block_limit", IResourceFactory.PropertyType.Effect);
            this.setCompatState(CompatState.INCOMPATIBLE);
            this.addIncompat("per_player_limit", CompatState.INCOMPATIBLE);
            this.addIncompat("per_chunk_limit", CompatState.INCOMPATIBLE);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropPerBlock(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new TextElement("id", "ResourceID", "Custom ID for the Counter for the per Block Data"));
            map.addElement(new BooleanElement("increase", true, "If the it should be used up or reduced"));
            ChoiceElement choice = new ChoiceElement("", 2);
            choice.addElement(0, new IntElement("usage", 1, "How much the Value should increase"));
            choice.addElement(0, new IntElement("max", 0).setDescription("How much the limit should be"));
            choice.addElement(1, new IntElement("usage", 1, "How much the Value should decrease"));
            choice.addElement(1, new IntElement("max", 0).setDescription("What the max should be (for the progress-animation)"));
            choice.addElement(1, new IntElement("min", 0, "What the lower value should be."));
            map.addElement(choice);
            map.setDescription("Allows to limit the Usage of a Block per Block");
            MapElement obj = new MapElement("replacement");
            obj.setDescription("Which replacement Block should be used").setDefaultValue("Air Block");
            obj.addElement(new TextElement("name", "").setDescription("The Block that should be used as replacement"));
            obj.addElement(new IntElement("meta", 0, "Metadata of the Block that should be used"));
            map.addElement(obj);
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("usage", (Number)1);
            obj.addProperty("max", (Number)10);
            JsonObject object = new JsonObject();
            object.addProperty("name", "minecraft:wool");
            object.addProperty("meta", (Number)12);
        }
    }
}

