/*
 * Decompiled with CFR 0.152.
 */
package scavenge.world.blockConditions;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.OptionalArrayElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.BlockEntry;
import scavenge.api.utils.JsonUtil;

public class PropIsStructure
extends BaseResourceProperty
implements IResourceCondition {
    Map<BlockPos, BlockEntry> positions = new LinkedHashMap<BlockPos, BlockEntry>();
    boolean require;

    public PropIsStructure(JsonObject obj) {
        super(obj, "has_block_structure");
        this.require = JsonUtil.getOrDefault(obj, "require", true);
        JsonUtil.convertToObject(obj.get("blocks"), new Consumer<JsonObject>(){

            @Override
            public void accept(JsonObject t) {
                final BlockEntry entry = JsonUtil.createCompareBlockEntry(t);
                JsonUtil.convertToObject(t.get("positions"), new Consumer<JsonObject>(){

                    @Override
                    public void accept(JsonObject t) {
                        PropIsStructure.this.positions.put(new BlockPos(t.get("x").getAsInt(), t.get("y").getAsInt(), t.get("z").getAsInt()), entry);
                    }
                });
            }
        });
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        if (this.require) {
            for (Map.Entry<BlockPos, BlockEntry> entry : this.positions.entrySet()) {
                if (entry.getValue().matches(world.func_180495_p(entry.getKey().func_177971_a((Vec3i)pos)))) continue;
                return false;
            }
            return true;
        }
        for (Map.Entry<BlockPos, BlockEntry> entry : this.positions.entrySet()) {
            if (!entry.getValue().matches(world.func_180495_p(entry.getKey().func_177971_a((Vec3i)pos)))) continue;
            return false;
        }
        return true;
    }

    public static class PropIsStructureFactory
    extends BaseResourceFactory {
        public PropIsStructureFactory() {
            super("has_block_structure", IResourceFactory.PropertyType.Condition);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropIsStructure(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            JsonObject position = new JsonObject();
            position.addProperty("x", (Number)-1);
            position.addProperty("y", (Number)-1);
            position.addProperty("z", (Number)-1);
            JsonObject blocks = new JsonObject();
            JsonArray array = new JsonArray();
            array.add((JsonElement)position);
            blocks.add("positions", (JsonElement)array);
            blocks.addProperty("name", "minecraft:dirt");
            array = new JsonArray();
            array.add((JsonElement)blocks);
            obj.add("blocks", (JsonElement)array);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.setDescription("Allows to check for a custom Made Structure.");
            MapElement positions = new MapElement("");
            positions.addElement(new IntElement("x", 0).setDescription("The XOffset for the Block that should be checkt for of the Clicked Block."));
            positions.addElement(new IntElement("y", 0).setDescription("The YOffset for the Block that should be checkt for of the Clicked Block."));
            positions.addElement(new IntElement("z", 0).setDescription("The ZOffset for the Block that should be checkt for of the Clicked Block."));
            MapElement block = new MapElement("");
            block.addElement(new TextElement("name", "").setDescription("Which Block should be checked for"));
            block.addElement(new IntElement("meta", Short.MAX_VALUE, "Which metadata should be used to check with"));
            block.addElement(new OptionalArrayElement("positions", positions));
            map.addElement(new OptionalArrayElement("blocks", block));
            map.addElement(new BooleanElement("require", true, "If the Structure is required or not"));
            return map;
        }
    }
}

