/*
 * Decompiled with CFR 0.152.
 */
package scavenge.utils.blockEffects;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.OptionalArrayElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.JsonUtil;

public class PropEffectedOffsets
extends BaseResourceProperty
implements IResourceEffect {
    Map<BlockPos, IResourceEffect> effects = new LinkedHashMap<BlockPos, IResourceEffect>();

    public PropEffectedOffsets(JsonObject obj) {
        super(obj, "offset_effect_adv");
        JsonUtil.convertToObject(obj.get("effects"), new Consumer<JsonObject>(){

            @Override
            public void accept(JsonObject t) {
                final IResourceEffect effect = PropEffectedOffsets.this.createEffect(t.getAsJsonObject("effect"));
                JsonUtil.convertToObject(t.get("positions"), new Consumer<JsonObject>(){

                    @Override
                    public void accept(JsonObject t) {
                        PropEffectedOffsets.this.effects.put(new BlockPos(t.get("x").getAsInt(), t.get("y").getAsInt(), t.get("z").getAsInt()), effect);
                    }
                });
            }
        });
    }

    @Override
    public void addJEIData(IResourceProperty.IJEIBlockHandler collector) {
        collector.addExtraLayer("Offset Effects");
        for (Map.Entry<BlockPos, IResourceEffect> entry : this.effects.entrySet()) {
            BlockPos pos = entry.getKey();
            collector.addInfo("Effect Offset by: x=" + pos.func_177958_n() + " y=" + pos.func_177956_o() + " z=" + pos.func_177952_p());
            entry.getValue().addJEIData(collector);
        }
        collector.finishLayer();
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        BlockPos newPos = BlockPos.field_177992_a;
        for (Map.Entry<BlockPos, IResourceEffect> entry : this.effects.entrySet()) {
            newPos = entry.getKey().func_177971_a((Vec3i)pos);
            state = world.func_180495_p(newPos);
            entry.getValue().applyEffects(state, world, newPos, player, left, side, resourceID, container);
        }
        return true;
    }

    public static class EffectedOffsets
    extends BaseResourceFactory {
        public EffectedOffsets() {
            super("offset_effect_adv", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropEffectedOffsets(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            JsonObject effectEntry = new JsonObject();
            JsonObject effect = new JsonObject();
            effect.addProperty("type", "exampleEffect");
            effectEntry.add("effect", (JsonElement)effect);
            JsonObject pos = new JsonObject();
            pos.addProperty("x", (Number)-1);
            pos.addProperty("y", (Number)-1);
            pos.addProperty("z", (Number)-1);
            JsonArray posArray = new JsonArray();
            posArray.add((JsonElement)pos);
            effectEntry.add("positions", (JsonElement)posArray);
            JsonArray array = new JsonArray();
            array.add((JsonElement)effectEntry);
            obj.add("effects", (JsonElement)array);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement positions = new MapElement("");
            positions.addElement(new IntElement("x", 0).setDescription("The XOffset of the Effect that should be applied"));
            positions.addElement(new IntElement("y", 0).setDescription("The YOffset of the Effect that should be applied"));
            positions.addElement(new IntElement("z", 0).setDescription("The ZOffset of the Effect that should be applied"));
            MapElement entry = new MapElement("");
            entry.addElement(new OptionalArrayElement("positions", positions));
            entry.addElement(new MapElement("effect").setDescription("The Effect that should be applied"));
            MapElement map = super.getDocumentation();
            map.addElement(new OptionalArrayElement("effects", entry));
            return map;
        }
    }
}

