/*
 * Decompiled with CFR 0.152.
 */
package scavenge.utils.blockConditions;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.DoubleElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.JsonUtil;

public class PropRandom
extends BaseResourceProperty
implements IResourceCondition {
    double chance;

    public PropRandom(JsonObject obj) {
        super(obj, "random_chance");
        this.chance = JsonUtil.getOrDefault(obj, "chance", 100.0);
        this.setJEIInfo("[" + this.chance + "%] Chance to work");
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        return this.chance >= world.field_73012_v.nextDouble() * 100.0;
    }

    public static class RandomFactory
    extends BaseResourceFactory {
        public RandomFactory() {
            super("random_chance", IResourceFactory.PropertyType.Condition);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropRandom(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("chance", (Number)100.0);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new DoubleElement("chance", 100.0, "How likely it is in % that the Random returns true"));
            map.setDescription("Allows to add a Random Factor into your condition");
            return map;
        }
    }
}

