/*
 * Decompiled with CFR 0.152.
 */
package scavenge.player.blockEffects;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.FloatElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.JsonUtil;

public class PropChangeHealth
extends BaseResourceProperty
implements IResourceEffect {
    boolean increase;
    float amount;

    public PropChangeHealth(JsonObject obj) {
        super(obj, "change_health");
        this.increase = JsonUtil.getOrDefault(obj, "increase", true);
        this.amount = obj.get("amount").getAsFloat();
        if (this.increase) {
            this.setJEIInfo("Increases health by " + this.amount);
        } else {
            this.setJEIInfo("Decreases health by " + this.amount);
        }
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        if (this.increase) {
            player.func_70606_j(player.func_110143_aJ() + this.amount);
            return true;
        }
        player.func_70606_j(player.func_110143_aJ() - this.amount);
        return true;
    }

    public static class ChangeHeathFactory
    extends BaseResourceFactory {
        public ChangeHeathFactory() {
            super("change_health", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropChangeHealth(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("increase", Boolean.valueOf(false));
            obj.addProperty("amount", (Number)2);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new BooleanElement("increase", true, "If the health should be increased or not"));
            map.addElement(new FloatElement("amount", 0.0f).setDescription("How much the health should be increased or decreased"));
            map.setDescription("Allows to increase/decrease the Players health");
            return map;
        }
    }
}

