/*
 * Decompiled with CFR 0.152.
 */
package scavenge.player.blockConditions;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.ScavengeAPI;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.LootUtil;

public class PropHasTool
extends BaseResourceProperty
implements IResourceCondition {
    String tool;
    int level;

    public PropHasTool(JsonObject obj) {
        super(obj, "require_tool");
        this.addIncompats("require_item", "require_item_list", "require_tool", "require_empty_Hand");
        this.tool = obj.get("tool").getAsString();
        this.level = obj.get("level").getAsInt();
        this.setJEIInfo("Player requires a [" + this.tool + "] with level " + this.level + " or higher");
    }

    @Override
    public void addJEIData(IResourceProperty.IJEIBlockHandler collector) {
        for (ItemStack stack : ScavengeAPI.INSTANCE.getClientRegistry().getTools(this.tool, this.level)) {
            collector.addRequiredItem(stack);
        }
        super.addJEIData(collector);
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        ItemStack stack = player.func_184614_ca();
        if (LootUtil.isStackEmpty(stack)) {
            return false;
        }
        return stack.func_77973_b().getHarvestLevel(stack, this.tool, player, state) >= this.level;
    }

    public static class HasToolFactory
    extends BaseResourceFactory {
        public HasToolFactory() {
            super("require_tool", IResourceFactory.PropertyType.Condition);
            this.addIncompats(CompatState.INCOMPATIBLE, "require_item", "require_item_list", "require_tool", "require_empty_Hand");
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropHasTool(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new TextElement("tool", "").setDescription("Which tool should be required"));
            map.addElement(new IntElement("level", 0).setDescription("Which level the tool should have"));
            map.setDescription("Allows to check if a player has a tool in the hand");
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("tool", "pickaxe");
            obj.addProperty("level", (Number)1);
        }
    }
}

