/*
 * Decompiled with CFR 0.152.
 */
package scavenge.core.loaders;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import scavenge.api.ScavengeAPI;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceProperty;
import scavenge.api.loot.ILootProperty;
import scavenge.api.utils.JsonUtil;
import scavenge.core.builder.block.BlockResourceBuilder;
import scavenge.core.builder.loot.LootBuilder;
import scavenge.core.handlers.ScavengeHandler;
import scavenge.core.loot.ILoot;

public class ScriptLoader {
    JsonParser parser = new JsonParser();
    List<String> errors = new ArrayList<String>();

    public void loadFile(String text, String fileName) {
        JsonElement base = this.readText(text);
        if (base == null) {
            return;
        }
        if (!base.isJsonObject()) {
            this.errors.add("File [" + fileName + "] doesn't start with a Json Object!");
            return;
        }
        JsonUtil.convertToObject(base.getAsJsonObject().get("block_pools"), new Consumer<JsonObject>(){

            @Override
            public void accept(JsonObject t) {
                ScriptLoader.this.generateBlockPool(t);
            }
        });
    }

    private void generateBlockPool(JsonObject obj) {
        String name = obj.get("name").getAsString();
        final BlockResourceBuilder builder = BlockResourceBuilder.createBuilder(obj.getAsJsonObject("type"));
        if (builder == null) {
            this.errors.add("ID [" + name + "] couldn't create a Resource Builder. Data [" + obj.getAsJsonObject("type") + "]");
            return;
        }
        builder.addName(name);
        if (obj.has("clicktype")) {
            String clickType = obj.get("clicktype").getAsString();
            if (clickType.equalsIgnoreCase("right") || clickType.equalsIgnoreCase("rightclick")) {
                builder.setRightClickState(obj.has("blockRightClick") ? (obj.get("blockRightClick").getAsBoolean() ? 1 : 2) : 1);
            } else if (clickType.equalsIgnoreCase("left") || clickType.equalsIgnoreCase("leftclick")) {
                builder.setRightClickState(0);
                builder.setLeftClickState(obj.has("blockLeftClick") ? (obj.get("blockLeftClick").getAsBoolean() ? 1 : 2) : 1);
            } else if (clickType.equalsIgnoreCase("both")) {
                builder.setRightClickState(obj.has("blockRightClick") ? (obj.get("blockRightClick").getAsBoolean() ? 1 : 2) : 1);
                builder.setLeftClickState(obj.has("blockLeftClick") ? (obj.get("blockLeftClick").getAsBoolean() ? 1 : 2) : 1);
            } else if (clickType.equalsIgnoreCase("break")) {
                builder.setBreakingType();
            } else if (clickType.equalsIgnoreCase("place")) {
                builder.setPlacing();
            }
        }
        if (obj.has("disableJEI")) {
            builder.setVisibility(!obj.get("disableJEI").getAsBoolean());
        }
        if (obj.has("properties")) {
            JsonUtil.convertToObject(obj.get("properties"), new Consumer<JsonObject>(){

                @Override
                public void accept(JsonObject t) {
                    ScriptLoader.this.generateProperties(t, builder);
                }
            });
        }
        if (obj.has("drops")) {
            JsonUtil.convertToObject(obj.get("drops"), new Consumer<JsonObject>(){

                @Override
                public void accept(JsonObject t) {
                    ScriptLoader.this.generateLoot(t, builder);
                }
            });
        }
        if (obj.has("messages")) {
            JsonUtil.convertToObject(obj.get("messages"), new Consumer<JsonObject>(){

                @Override
                public void accept(JsonObject t) {
                    ScriptLoader.this.generateMessages(t, builder);
                }
            });
        }
        if (!builder.isValid()) {
            this.errors.add("Block Modifier has no Effects or Loot Drops so its not going to be added!");
            return;
        }
        ScavengeHandler.INSTANCE.addResource(builder.create());
    }

    private void generateMessages(JsonObject object, BlockResourceBuilder builder) {
        String id = object.get("id").getAsString();
        String message = object.get("message").getAsString();
        if (id == null || id.isEmpty()) {
            this.errors.add("Message Object [" + object + "] is having a null ID for messages");
            return;
        }
        if (message == null || message.isEmpty()) {
            this.errors.add("Message ID [" + id + "] is a null Message");
            return;
        }
        builder.addMessage(id, message);
    }

    private void generateLoot(JsonObject object, BlockResourceBuilder builder) {
        ILoot entry;
        ItemStack stack = JsonUtil.createStackWithNBT(object);
        if (stack == null) {
            this.errors.add("Object [" + object + "] couldn't create a ItemStack to make loot!");
            return;
        }
        final LootBuilder loot = new LootBuilder(stack);
        loot.setProperties(object);
        if (object.has("properties")) {
            JsonUtil.convertToObject(object.get("properties"), new Consumer<JsonObject>(){

                @Override
                public void accept(JsonObject t) {
                    ScriptLoader.this.generateLootProp(t, loot);
                }
            });
        }
        if ((entry = loot.build()) == null) {
            this.errors.add("Loot [" + object + "] returns into a Impossible Loot by default. It got skipped!");
            return;
        }
        if (object.has("conditions")) {
            if (entry.usesWeight()) {
                this.errors.add("Loot[" + object + "] is weight based and wants conditions. Thats not allowed!");
                return;
            }
            final ArrayList<IResourceCondition> conditions = new ArrayList<IResourceCondition>();
            JsonUtil.convertToObject(object.get("conditions"), new Consumer<JsonObject>(){

                @Override
                public void accept(JsonObject t) {
                    String type = t.get("type").getAsString();
                    try {
                        IResourceProperty prop = ScavengeAPI.INSTANCE.createResourceProperty(type, t);
                        if (prop == null) {
                            ScriptLoader.this.errors.add("LootCondtion [" + type + "] has returned a null. This is a bug!");
                            return;
                        }
                        if (!(prop instanceof IResourceCondition)) {
                            ScriptLoader.this.errors.add("LootCondtion [" + type + "] is not a Condition. It will be skipped");
                            return;
                        }
                        conditions.add((IResourceCondition)prop);
                    }
                    catch (Exception e) {
                        ScriptLoader.this.errors.add("LootCondtion [" + type + "] couldn't be created! Reason: " + e.getMessage());
                    }
                }
            });
            if (conditions.size() > 0) {
                builder.addConditionalLoot(entry, conditions);
                return;
            }
        }
        builder.addLoot(entry);
    }

    private void generateLootProp(JsonObject obj, LootBuilder builder) {
        String type = obj.get("type").getAsString();
        try {
            ILootProperty prop = ScavengeAPI.INSTANCE.createLootProperty(type, obj);
            if (prop == null) {
                this.errors.add("Loot-Property [" + type + "] has returned a null. This is a bug!");
                return;
            }
            if (!builder.addProperty(prop)) {
                this.errors.add("Loot-Property [" + type + "] wasn't added to the Builder because of Incompatiblity!");
            }
        }
        catch (Exception e) {
            this.errors.add("Loot-Property [" + type + "] couldn't be created! Reason: " + e.getMessage());
        }
    }

    private void generateProperties(JsonObject object, BlockResourceBuilder builder) {
        String type = object.get("type").getAsString();
        try {
            IResourceProperty prop = ScavengeAPI.INSTANCE.createResourceProperty(type, object);
            if (prop == null) {
                this.errors.add("Block-Property [" + type + "] has returned a null. This is a bug!");
                return;
            }
            if (!builder.addProperty(prop)) {
                this.errors.add("Block-Property [" + type + "] wasn't added to the Builder because of Incompatiblity!");
            }
        }
        catch (Exception e) {
            this.errors.add("Block-Property [" + type + "] couldn't be created! Reason: " + e.getMessage());
        }
    }

    public JsonElement readText(String s) {
        try {
            return this.parser.parse(s);
        }
        catch (Exception e) {
            this.errors.add(e.getMessage());
            return null;
        }
    }

    public List<String> getErrors() {
        ArrayList<String> list = new ArrayList<String>(this.errors);
        this.errors.clear();
        return list;
    }

    public boolean hasErros() {
        return this.errors.size() > 0;
    }
}

