/*
 * Decompiled with CFR 0.152.
 */
package scavenge.core.jei;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import scavenge.api.block.IResourceProperty;
import scavenge.api.utils.LootUtil;

public class JEIHolder
implements IResourceProperty.IJEIBlockHandler {
    List<ItemStack> requiredItems = new ArrayList<ItemStack>();
    List<ItemStack> transformBlocks = new ArrayList<ItemStack>();
    InfoComponent base;
    InfoComponent currentLayer = this.base = new InfoComponent("");

    @Override
    public void addInfo(String s) {
        this.currentLayer.addInfo(s);
    }

    @Override
    public void addRequiredItem(ItemStack stack) {
        String layerName = this.currentLayer.getText();
        if (layerName != null && layerName.length() > 0) {
            LootUtil.addToolTip(stack, "Added By Special Requirement: [" + layerName + "]");
        }
        this.requiredItems.add(stack);
    }

    @Override
    public void addTransformation(ItemStack stack, double chance) {
        String layerName = this.currentLayer.getText();
        if (layerName != null && layerName.length() > 0) {
            LootUtil.addToolTip(stack, "Added By Special Requirement: [" + layerName + "]");
        }
        if (chance < 100.0) {
            LootUtil.addToolTip(stack, "Chance of Happening: [" + chance + "%]");
        }
        this.transformBlocks.add(stack);
    }

    @Override
    public void addExtraLayer(String layerName) {
        this.currentLayer = new InfoComponent(layerName, this.currentLayer);
    }

    @Override
    public void finishLayer() {
        this.currentLayer = this.currentLayer.parent;
    }

    public static class InfoComponent
    implements IndexComponent {
        String name;
        List<IndexComponent> list = new ArrayList<IndexComponent>();
        InfoComponent parent;

        public InfoComponent(String theName) {
            this.name = theName;
        }

        public InfoComponent(String theName, InfoComponent theParent) {
            this.name = theName;
            this.parent = theParent;
            this.parent.addLayer(this);
        }

        public void addInfo(String s) {
            this.list.add(new TextComponent(s));
        }

        public void addLayer(InfoComponent layer) {
            this.list.add(layer);
        }

        @Override
        public boolean hasSubComponents() {
            return true;
        }

        @Override
        public List<IndexComponent> getSubComponents() {
            return this.list;
        }

        @Override
        public String getText() {
            return this.name;
        }
    }

    public static class TextComponent
    implements IndexComponent {
        String text;

        public TextComponent(String s) {
            this.text = s;
        }

        @Override
        public boolean hasSubComponents() {
            return false;
        }

        @Override
        public List<IndexComponent> getSubComponents() {
            return new ArrayList<IndexComponent>();
        }

        @Override
        public String getText() {
            return this.text;
        }
    }

    public static interface IndexComponent {
        public boolean hasSubComponents();

        public List<IndexComponent> getSubComponents();

        public String getText();
    }
}

