/*
 * Decompiled with CFR 0.152.
 */
package scavenge.api;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import scavenge.api.IClientRegistry;
import scavenge.api.IScavengeFactory;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.loot.ILootFactory;
import scavenge.api.loot.ILootProperty;
import scavenge.api.math.IMathModifier;
import scavenge.api.math.IMathOperation;
import scavenge.api.math.IMathRegistry;
import scavenge.api.math.impl.ArrayMathOperation;
import scavenge.api.math.impl.EmptyMathOperation;
import scavenge.api.world.IWorldRegistry;

public final class ScavengeAPI {
    public static boolean printDocumentation = false;
    public static boolean printInCurseFormat = false;
    public static final Logger APILogger = LogManager.getLogger((String)"ScavengeAPI");
    public static final ScavengeAPI INSTANCE = new ScavengeAPI();
    Map<String, IResourceFactory> blockProperties = new LinkedHashMap<String, IResourceFactory>();
    Map<String, ILootFactory> lootProperties = new LinkedHashMap<String, ILootFactory>();
    Map<String, NBTTagCompound> nbtStorage = new LinkedHashMap<String, NBTTagCompound>();
    IClientRegistry clientRegistry;
    IMathRegistry mathRegistry;
    IWorldRegistry worldRegistry;

    public void clearTemporaryStorage() {
        this.nbtStorage.clear();
    }

    public void setMathRegistry(IMathRegistry registry) {
        if (this.mathRegistry != null || registry == null) {
            return;
        }
        this.mathRegistry = registry;
        this.mathRegistry.registerOperationFactory(new EmptyMathOperation.EmptyOperationFactory());
        this.mathRegistry.registerOperationFactory(new ArrayMathOperation.ArrayFactory());
    }

    public void setWorldRegistry(IWorldRegistry registry) {
        if (this.worldRegistry != null || registry == null) {
            return;
        }
        this.worldRegistry = registry;
    }

    public void setClientRegistry(IClientRegistry registry) {
        if (this.clientRegistry != null || registry == null) {
            return;
        }
        this.clientRegistry = registry;
    }

    public void registerResourceProperty(IResourceFactory factory) {
        String id = factory.getID();
        if (id == null || id.isEmpty()) {
            APILogger.error("ID for factory [" + factory.toString() + "] is null or Empty. Its required to have a ID!");
            return;
        }
        if (this.blockProperties.containsKey(id = id.toLowerCase(Locale.ENGLISH))) {
            APILogger.error("ID [" + id + "] is already being used!");
            return;
        }
        this.blockProperties.put(id, factory);
    }

    public void registerLootProperty(ILootFactory factory) {
        String id = factory.getID();
        if (id == null || id.isEmpty()) {
            APILogger.error("ID for factory [" + factory.toString() + "] is null or Empty. Its required to have a ID!");
            return;
        }
        if (this.lootProperties.containsKey(id = id.toLowerCase(Locale.ENGLISH))) {
            APILogger.error("ID [" + id + "] is already being used!");
            return;
        }
        this.lootProperties.put(id, factory);
    }

    public void storeNBT(String id, NBTTagCompound nbt) {
        if (id == null || id.isEmpty()) {
            APILogger.error("Compund [" + nbt.toString() + "] is registered with a Empty ID");
            return;
        }
        id = id.toLowerCase(Locale.ENGLISH);
        if (nbt == null) {
            APILogger.error("Compound with the ID [" + id + "] is null. That is not allowed");
            return;
        }
        this.nbtStorage.put(id, nbt.func_74737_b());
    }

    public IResourceProperty createResourceProperty(String id, JsonObject obj) {
        IScavengeFactory factory = this.blockProperties.get(id.toLowerCase(Locale.ENGLISH));
        if (factory == null) {
            throw new RuntimeException("ID [" + id + "] has no factory!");
        }
        return (IResourceProperty)factory.createObject(obj);
    }

    public ILootProperty createLootProperty(String id, JsonObject obj) {
        IScavengeFactory factory = this.lootProperties.get(id.toLowerCase(Locale.ENGLISH));
        if (factory == null) {
            throw new RuntimeException("ID [" + id + "] has no factory!");
        }
        return (ILootProperty)factory.createObject(obj);
    }

    public IMathOperation getMathOperation(String id, JsonObject obj) {
        return this.mathRegistry.getOperation(id, obj);
    }

    public IMathModifier getMathModifier(String id, JsonObject obj) {
        return this.mathRegistry.getModifier(id, obj);
    }

    public IMathRegistry getMathRegistry() {
        return this.mathRegistry;
    }

    public IWorldRegistry getWorldRegistry() {
        return this.worldRegistry;
    }

    public IClientRegistry getClientRegistry() {
        return this.clientRegistry;
    }

    public boolean hasCompound(String id) {
        return this.nbtStorage.containsKey(id.toLowerCase(Locale.ENGLISH));
    }

    public NBTTagCompound getCompound(String id) {
        NBTTagCompound nbt = this.nbtStorage.get(id.toLowerCase(Locale.ENGLISH));
        if (nbt == null) {
            return null;
        }
        return nbt.func_74737_b();
    }

    public List<ILootFactory> getLootFactories() {
        return new ArrayList<ILootFactory>(this.lootProperties.values());
    }

    public List<IResourceFactory> getResourceFactory() {
        return new ArrayList<IResourceFactory>(this.blockProperties.values());
    }
}

