/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.repackage.com.therandomlabs.randomlib.config;

import com.therandomlabs.randompatches.repackage.com.therandomlabs.randomlib.config.TRLTypeAdapter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class ResourceLocationTypeAdapter<V extends IForgeRegistryEntry<V>>
implements TRLTypeAdapter {
    private final Class<V> registryEntryClass;
    private final IForgeRegistry<V> registry;
    private final boolean isArray;

    public ResourceLocationTypeAdapter(Class<V> registryEntryClass, boolean isArray) {
        this.registryEntryClass = registryEntryClass;
        this.registry = GameRegistry.findRegistry(registryEntryClass);
        this.isArray = isArray;
    }

    @Override
    public Object getValue(Property property) {
        if (this.isArray) {
            String[] array = property.getStringList();
            ArrayList<IForgeRegistryEntry> values = new ArrayList<IForgeRegistryEntry>(array.length);
            for (String element : array) {
                IForgeRegistryEntry object = this.registry.getValue(new ResourceLocation(element));
                if (object == null) continue;
                values.add(object);
            }
            return values.toArray((IForgeRegistryEntry[])Array.newInstance(this.registryEntryClass, 0));
        }
        IForgeRegistryEntry object = this.registry.getValue(new ResourceLocation(property.getString()));
        return object == null ? this.registry.getValue(new ResourceLocation(property.getDefault())) : object;
    }

    @Override
    public String asString(Object value) {
        return value == null ? "" : ((IForgeRegistryEntry)value).getRegistryName().toString();
    }

    @Override
    public Property.Type getType() {
        return Property.Type.STRING;
    }

    @Override
    public boolean isArray() {
        return this.isArray;
    }
}

