/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.item.block.ItemBlockSpecialFlower;

public class SpecialFlowerModel
implements IModel {
    private static final ModelResourceLocation MISSING = new ModelResourceLocation("builtin/missing", "missing");
    private final ModelResourceLocation baseModel;
    private final ImmutableMap<String, ModelResourceLocation> blockModels;
    private final ImmutableMap<String, ModelResourceLocation> itemModels;

    private SpecialFlowerModel(ModelResourceLocation baseModel, ImmutableMap<String, ModelResourceLocation> blockModels, ImmutableMap<String, ModelResourceLocation> itemModels) {
        this.baseModel = baseModel;
        this.blockModels = blockModels;
        this.itemModels = itemModels;
    }

    public Collection<ResourceLocation> getDependencies() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (!MISSING.equals((Object)this.baseModel)) {
            builder.add((Object)this.baseModel);
        }
        builder.addAll((Iterable)this.blockModels.values());
        builder.addAll((Iterable)this.itemModels.values());
        builder.addAll(BotaniaAPIClient.getRegisteredIslandTypeModels().values());
        return builder.build();
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.of();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap transforms = PerspectiveMapWrapper.getTransforms((IModelState)state);
        SimpleModelState transformState = new SimpleModelState(transforms);
        IBakedModel baseModelBaked = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)this.baseModel).bake((IModelState)transformState, DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
        ImmutableMap.Builder bakedBlockBuilder = ImmutableMap.builder();
        for (Map.Entry e : this.blockModels.entrySet()) {
            IModel model = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)((ResourceLocation)e.getValue()));
            if (model == ModelLoaderRegistry.getMissingModel()) continue;
            bakedBlockBuilder.put(e.getKey(), (Object)model.bake((IModelState)transformState, DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter()));
        }
        ImmutableMap.Builder bakedItemBuilder = ImmutableMap.builder();
        for (Map.Entry e : this.itemModels.entrySet()) {
            IModel model = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)((ResourceLocation)e.getValue()));
            if (model == ModelLoaderRegistry.getMissingModel()) continue;
            bakedItemBuilder.put(e.getKey(), (Object)model.bake((IModelState)transformState, DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter()));
        }
        return new SpecialFlowerBakedModel(baseModelBaked, (ImmutableMap<String, IBakedModel>)bakedBlockBuilder.build(), (ImmutableMap<String, IBakedModel>)bakedItemBuilder.build(), (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)transforms);
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public IModel process(ImmutableMap<String, String> customData) {
        ModelResourceLocation base = this.baseModel;
        if (customData.containsKey((Object)"base")) {
            base = new ModelResourceLocation(((String)customData.get((Object)"base")).substring(1, ((String)customData.get((Object)"base")).length() - 1));
        }
        ImmutableMap blockModels = ImmutableMap.copyOf(BotaniaAPIClient.getRegisteredSubtileBlockModels());
        ImmutableMap itemModels = ImmutableMap.copyOf(BotaniaAPIClient.getRegisteredSubtileItemModels());
        return new SpecialFlowerModel(base, (ImmutableMap<String, ModelResourceLocation>)blockModels, (ImmutableMap<String, ModelResourceLocation>)itemModels);
    }

    private static class SpecialFlowerBakedModel
    implements IBakedModel {
        private final IBakedModel baseModel;
        private final ImmutableMap<String, IBakedModel> bakedBlockModels;
        private final ImmutableMap<String, IBakedModel> bakedItemModels;
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        private final ItemStack roseFallback = new ItemStack((Block)Blocks.field_150328_O);
        private final ItemOverrideList itemHandler = new ItemOverrideList((List)ImmutableList.of()){

            @Nonnull
            public IBakedModel handleItemState(@Nonnull IBakedModel original, ItemStack stack, World world, EntityLivingBase living) {
                IBakedModel model = (IBakedModel)bakedItemModels.get((Object)ItemBlockSpecialFlower.getType(stack));
                if (model == null) {
                    model = (IBakedModel)bakedBlockModels.get((Object)ItemBlockSpecialFlower.getType(stack));
                }
                if (model == null) {
                    model = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(roseFallback);
                }
                return model;
            }
        };

        SpecialFlowerBakedModel(IBakedModel baseModel, ImmutableMap<String, IBakedModel> bakedBlockModels, ImmutableMap<String, IBakedModel> bakedItemModels, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> cameraTransforms) {
            this.baseModel = baseModel;
            this.bakedBlockModels = bakedBlockModels;
            this.bakedItemModels = bakedItemModels;
            this.transforms = cameraTransforms;
        }

        @Nonnull
        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing face, long rand) {
            IExtendedBlockState extendedState = (IExtendedBlockState)state;
            String subtileId = (String)extendedState.getValue(BotaniaStateProps.SUBTILE_ID);
            IBakedModel model = (IBakedModel)this.bakedBlockModels.get((Object)(subtileId == null ? "" : subtileId));
            if (model == null) {
                model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a();
            }
            return model.func_188616_a(state, face, rand);
        }

        @Nonnull
        public ItemOverrideList func_188617_f() {
            return this.itemHandler;
        }

        public boolean func_177555_b() {
            return this.baseModel.func_177555_b();
        }

        public boolean func_177556_c() {
            return this.baseModel.func_177556_c();
        }

        public boolean func_188618_c() {
            return this.baseModel.func_188618_c();
        }

        @Nonnull
        public TextureAtlasSprite func_177554_e() {
            return this.baseModel.func_177554_e();
        }

        @Nonnull
        public ItemCameraTransforms func_177552_f() {
            return this.baseModel.func_177552_f();
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)cameraTransformType);
        }
    }

    public static enum Loader implements ICustomModelLoader
    {
        INSTANCE{

            public void func_110549_a(@Nonnull IResourceManager resourceManager) {
            }

            public boolean accepts(ResourceLocation modelLocation) {
                return modelLocation.func_110624_b().equals("botania_special") && (modelLocation.func_110623_a().equals("specialflower") || modelLocation.func_110623_a().equals("models/block/specialflower") || modelLocation.func_110623_a().equals("models/item/specialflower"));
            }

            public IModel loadModel(ResourceLocation modelLocation) {
                return new SpecialFlowerModel(new ModelResourceLocation("builtin/missing", "missing"), ImmutableMap.of(), ImmutableMap.of());
            }
        };

    }
}

