/*
 * Decompiled with CFR 0.152.
 */
package gregicadditions.recipes;

import com.google.common.collect.ImmutableMap;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.util.EnumValidationResult;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ValidationResult;
import java.util.List;
import java.util.Map;

public class NoEURecipeBuilder
extends RecipeBuilder<NoEURecipeBuilder> {
    public NoEURecipeBuilder() {
    }

    public NoEURecipeBuilder(Recipe recipe, RecipeMap<NoEURecipeBuilder> recipeMap) {
        super(recipe, recipeMap);
    }

    public NoEURecipeBuilder(RecipeBuilder<NoEURecipeBuilder> recipeBuilder) {
        super(recipeBuilder);
    }

    public NoEURecipeBuilder copy() {
        return new NoEURecipeBuilder(this);
    }

    public ValidationResult<Recipe> build() {
        return ValidationResult.newResult((EnumValidationResult)this.finalizeAndValidate(), (Object)new Recipe(this.inputs, (List)this.outputs, this.chancedOutputs, this.fluidInputs, this.fluidOutputs, (Map)ImmutableMap.of(), this.duration, this.EUt, this.hidden, this.canBeBuffered, this.needsEmptyOutput));
    }

    protected EnumValidationResult validate() {
        if (this.recipeMap == null) {
            GTLog.logger.error("RecipeMap cannot be null", (Throwable)new IllegalArgumentException());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        if (!GTUtility.isBetweenInclusive((long)this.recipeMap.getMinInputs(), (long)this.recipeMap.getMaxInputs(), (long)this.inputs.size())) {
            GTLog.logger.error("Invalid amount of recipe inputs. Actual: {}. Should be between {} and {} inclusive.", (Object)this.inputs.size(), (Object)this.recipeMap.getMinInputs(), (Object)this.recipeMap.getMaxInputs());
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        if (!GTUtility.isBetweenInclusive((long)this.recipeMap.getMinOutputs(), (long)this.recipeMap.getMaxOutputs(), (long)(this.outputs.size() + this.chancedOutputs.size()))) {
            GTLog.logger.error("Invalid amount of recipe outputs. Actual: {}. Should be between {} and {} inclusive.", (Object)(this.outputs.size() + this.chancedOutputs.size()), (Object)this.recipeMap.getMinOutputs(), (Object)this.recipeMap.getMaxOutputs());
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        if (!GTUtility.isBetweenInclusive((long)this.recipeMap.getMinFluidInputs(), (long)this.recipeMap.getMaxFluidInputs(), (long)this.fluidInputs.size())) {
            GTLog.logger.error("Invalid amount of recipe fluid inputs. Actual: {}. Should be between {} and {} inclusive.", (Object)this.fluidInputs.size(), (Object)this.recipeMap.getMinFluidInputs(), (Object)this.recipeMap.getMaxFluidInputs());
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        if (!GTUtility.isBetweenInclusive((long)this.recipeMap.getMinFluidOutputs(), (long)this.recipeMap.getMaxFluidOutputs(), (long)this.fluidOutputs.size())) {
            GTLog.logger.error("Invalid amount of recipe fluid outputs. Actual: {}. Should be between {} and {} inclusive.", (Object)this.fluidOutputs.size(), (Object)this.recipeMap.getMinFluidOutputs(), (Object)this.recipeMap.getMaxFluidOutputs());
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        if (this.duration <= 0) {
            GTLog.logger.error("Duration cannot be less or equal to 0", (Throwable)new IllegalArgumentException());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        if (this.recipeStatus == EnumValidationResult.INVALID) {
            GTLog.logger.error("Invalid recipe, read the errors above: {}", (Object)this);
        }
        return this.recipeStatus;
    }
}

