/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook.elements;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import gigaherz.guidebook.guidebook.IBookGraphics;
import gigaherz.guidebook.guidebook.IConditionSource;
import gigaherz.guidebook.guidebook.conditions.ConditionContext;
import gigaherz.guidebook.guidebook.drawing.Point;
import gigaherz.guidebook.guidebook.drawing.Rect;
import gigaherz.guidebook.guidebook.drawing.VisualElement;
import gigaherz.guidebook.guidebook.elements.Element;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ElementPanel
extends Element {
    public final List<Element> innerElements;
    public boolean asPercent;
    public Integer space;

    public ElementPanel() {
        this.innerElements = Lists.newArrayList();
    }

    public ElementPanel(List<Element> innerElements) {
        this.innerElements = Lists.newArrayList(innerElements);
    }

    @Override
    public void parse(IConditionSource book, NamedNodeMap attributes) {
        super.parse(book, attributes);
        Node attr = attributes.getNamedItem("height");
        if (attr != null) {
            String t = attr.getTextContent();
            if (t.endsWith("%")) {
                this.asPercent = true;
                t = t.substring(0, t.length() - 1);
            }
            this.space = Ints.tryParse((String)t);
        }
    }

    @Override
    public boolean reevaluateConditions(ConditionContext ctx) {
        boolean oldValue = this.conditionResult;
        this.conditionResult = this.condition == null || this.condition.test(ctx);
        boolean anyChanged = this.conditionResult != oldValue;
        for (Element element : this.innerElements) {
            anyChanged |= element.reevaluateConditions(ctx);
        }
        return anyChanged;
    }

    @Override
    public int reflow(List<VisualElement> list, IBookGraphics nav, Rect bounds, Rect pageBounds) {
        Point adjustedPosition = this.applyPosition(bounds.position, bounds.position);
        Rect adjustedBounds = new Rect(adjustedPosition, bounds.size);
        int yBottom = adjustedPosition.y;
        for (Element element : this.innerElements) {
            yBottom = element.reflow(list, nav, adjustedBounds, pageBounds);
        }
        if (this.position != 0) {
            return bounds.position.y;
        }
        return this.space != null ? adjustedPosition.y + this.space : yBottom;
    }

    @Override
    public void findTextures(Set<ResourceLocation> textures) {
        for (Element child : this.innerElements) {
            child.findTextures(textures);
        }
    }

    @Override
    public Element copy() {
        ElementPanel space = super.copy(new ElementPanel());
        space.asPercent = this.asPercent;
        space.space = this.space;
        return space;
    }

    @Override
    @Nullable
    public Element applyTemplate(IConditionSource book, List<Element> sourceElements) {
        if (this.innerElements.size() == 0) {
            return null;
        }
        ElementPanel paragraph = super.copy(new ElementPanel());
        paragraph.space = this.space;
        for (Element element : this.innerElements) {
            Element t = element.applyTemplate(book, sourceElements);
            if (t == null) continue;
            paragraph.innerElements.add(t);
        }
        if (paragraph.innerElements.size() == 0) {
            return null;
        }
        return paragraph;
    }

    @Override
    public boolean supportsPageLevel() {
        return true;
    }
}

