/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook.elements;

import com.google.common.collect.Lists;
import gigaherz.guidebook.guidebook.IBookGraphics;
import gigaherz.guidebook.guidebook.IConditionSource;
import gigaherz.guidebook.guidebook.SectionRef;
import gigaherz.guidebook.guidebook.drawing.VisualElement;
import gigaherz.guidebook.guidebook.drawing.VisualLink;
import gigaherz.guidebook.guidebook.drawing.VisualText;
import gigaherz.guidebook.guidebook.elements.Element;
import gigaherz.guidebook.guidebook.elements.ElementSpan;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ElementLink
extends ElementSpan {
    public String textTarget;
    public String textAction;
    public SectionRef target;
    public int colorHover = -8926106;

    public ElementLink(String text) {
        super(text, true, true);
        this.underline = true;
        this.color = -8952116;
    }

    @Override
    public List<VisualElement> measure(IBookGraphics nav, int width, int firstLineWidth) {
        List<VisualElement> texts = super.measure(nav, width, firstLineWidth);
        ArrayList links = Lists.newArrayList();
        VisualLink.SharedHoverContext ctx = null;
        Iterator<VisualElement> iterator = texts.iterator();
        while (iterator.hasNext()) {
            VisualElement e;
            VisualElement el = e = iterator.next();
            if (e instanceof VisualText) {
                VisualText text = (VisualText)e;
                VisualLink link = new VisualLink(text.text, text.size, this.position, this.baseline, this.verticalAlignment, this.scale);
                if (ctx == null) {
                    ctx = link.hoverContext;
                } else {
                    link.hoverContext = ctx;
                }
                link.color = this.color;
                link.target = this.target;
                link.colorHover = this.colorHover;
                link.textTarget = this.textTarget;
                link.textAction = this.textAction;
                el = link;
            }
            links.add(el);
        }
        return links;
    }

    @Override
    public void parse(IConditionSource book, NamedNodeMap attributes) {
        super.parse(book, attributes);
        Node attr = attributes.getNamedItem("ref");
        if (attr != null) {
            String ref = attr.getTextContent();
            this.target = SectionRef.fromString(ref);
        }
        if ((attr = attributes.getNamedItem("href")) != null) {
            this.textTarget = attr.getTextContent();
            this.textAction = "openUrl";
        }
        if ((attr = attributes.getNamedItem("text")) != null) {
            this.textTarget = attr.getTextContent();
        }
        if ((attr = attributes.getNamedItem("action")) != null) {
            this.textAction = attr.getTextContent();
        }
    }

    @Override
    public Element copy() {
        ElementLink link = super.copy(new ElementLink(this.text));
        link.color = this.color;
        link.bold = this.bold;
        link.italics = this.italics;
        link.underline = this.underline;
        link.target = this.target.copy();
        link.colorHover = this.colorHover;
        link.textTarget = this.textTarget;
        link.textAction = this.textAction;
        return link;
    }
}

