/*
 * Decompiled with CFR 0.152.
 */
package teamroots.emberroot.entity.slimedirt;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import teamroots.emberroot.config.ConfigSpawnEntity;
import teamroots.emberroot.util.SpawnUtil;

public class EntityDireSlime
extends EntityMagmaCube {
    public static final String NAME = "slime";
    public static final DataParameter<Integer> variant = EntityDataManager.func_187226_a(EntityDireSlime.class, (DataSerializer)DataSerializers.field_187192_b);
    public static ConfigSpawnEntity config = new ConfigSpawnEntity(EntityDireSlime.class, EnumCreatureType.MONSTER);

    public int func_70641_bl() {
        return EntityDireSlime.config.settings.max;
    }

    public boolean func_70601_bi() {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        BlockPos blockpos = new BlockPos(i, j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), k = MathHelper.func_76128_c((double)this.field_70161_v));
        boolean canSpawn = this.field_70170_p.func_180495_p(blockpos.func_177977_b()).func_177230_c() != Blocks.field_150350_a && this.field_70170_p.func_175699_k(blockpos) < 7 && super.func_70601_bi() && this.field_70146_Z.nextInt(EntityDireSlime.config.settings.weightedProb) == 0;
        return canSpawn;
    }

    public EntityDireSlime(World world) {
        super(world);
        this.func_70799_a(1, false);
    }

    public Integer getVariant() {
        return (Integer)this.func_184212_Q().func_187225_a(variant);
    }

    public VariantColors getVariantEnum() {
        return VariantColors.values()[this.getVariant()];
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(variant, (Object)this.field_70146_Z.nextInt(VariantColors.values().length));
    }

    private boolean blockHereMatches(Block target, BlockPos pos) {
        Block blockBelow = this.field_70170_p.func_180495_p(pos).func_177230_c();
        return OreDictionary.itemMatches((ItemStack)new ItemStack(target), (ItemStack)new ItemStack(blockBelow), (boolean)false);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        Biome biome = this.field_70170_p.func_180494_b(this.func_180425_c());
        BlockPos posHere = this.func_180425_c();
        BlockPos posDown = posHere.func_177977_b();
        int newVariant = -1;
        if (biome.equals(Biomes.field_76778_j) || this.blockHereMatches(Blocks.field_150424_aL, posDown)) {
            newVariant = VariantColors.NETHER.ordinal();
            newVariant = VariantColors.NETHER.ordinal();
        } else if (biome.equals(Biomes.field_76779_k) || this.blockHereMatches(Blocks.field_150377_bs, posDown)) {
            newVariant = VariantColors.END.ordinal();
        } else if (this.blockHereMatches(Blocks.field_150433_aE, posHere) || this.blockHereMatches(Blocks.field_150431_aC, posHere)) {
            newVariant = VariantColors.SNOW.ordinal();
        } else if (this.blockHereMatches(Blocks.field_150346_d, posDown) || this.blockHereMatches((Block)Blocks.field_150349_c, posDown)) {
            newVariant = VariantColors.DIRT.ordinal();
        } else if (this.blockHereMatches((Block)Blocks.field_150354_m, posDown) || this.blockHereMatches(Blocks.field_150322_A, posDown)) {
            newVariant = VariantColors.SAND.ordinal();
        } else if (this.blockHereMatches(Blocks.field_150348_b, posDown) || this.blockHereMatches(Blocks.field_150347_e, posDown)) {
            newVariant = VariantColors.STONE.ordinal();
        } else if (this.blockHereMatches(Blocks.field_150351_n, posDown)) {
            newVariant = VariantColors.GRAVEL.ordinal();
        } else if (biome.func_150559_j() || this.blockHereMatches(Blocks.field_150433_aE, posDown)) {
            newVariant = VariantColors.SNOW.ordinal();
        }
        if (newVariant >= 0 && newVariant != this.getVariant()) {
            this.field_70180_af.func_187227_b(variant, (Object)newVariant);
            this.field_70180_af.func_187217_b(variant);
        }
    }

    public void func_70799_a(int size, boolean doFullHeal) {
        super.func_70799_a(size, doFullHeal);
        SlimeConf conf = SlimeConf.getConfForSize(size);
        this.func_70606_j(this.func_110138_aP());
    }

    public void func_70645_a(DamageSource damageSource) {
        SlimeConf nextConf;
        super.func_70645_a(damageSource);
        if (!this.field_70170_p.field_72995_K && damageSource != null && damageSource.func_76346_g() instanceof EntityPlayer && (nextConf = SlimeConf.getConfForSize(this.func_70809_q()).bigger()) != null && (double)this.field_70170_p.field_73012_v.nextFloat() <= nextConf.chance) {
            EntityDireSlime spawn = new EntityDireSlime(this.field_70170_p);
            spawn.func_70799_a(nextConf.size, true);
            spawn.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            spawn.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)this)), null);
            if (SpawnUtil.isSpaceAvailableForSpawn(this.field_70170_p, (EntityLiving)spawn, false)) {
                this.field_70170_p.func_72838_d((Entity)spawn);
            }
        }
    }

    public void func_70106_y() {
        this.field_70128_L = true;
    }

    protected EnumParticleTypes func_180487_n() {
        return EnumParticleTypes.BLOCK_CRACK;
    }

    protected boolean spawnCustomParticles() {
        int i = this.func_70809_q();
        for (int j = 0; j < i * 8; ++j) {
            float f = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
            float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
            float f2 = MathHelper.func_76126_a((float)f) * (float)i * 0.5f * f1;
            float f3 = MathHelper.func_76134_b((float)f) * (float)i * 0.5f * f1;
            World world = this.field_70170_p;
            EnumParticleTypes enumparticletypes = this.func_180487_n();
            double d0 = this.field_70165_t + (double)f2;
            double d1 = this.field_70161_v + (double)f3;
            world.func_175688_a(enumparticletypes, d0, this.func_174813_aQ().field_72338_b, d1, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)Blocks.field_150346_d.func_176223_P())});
        }
        return true;
    }

    protected EntitySlime func_70802_j() {
        return new EntityDireSlime(this.field_70170_p);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        if (!this.field_70170_p.func_175623_d(new BlockPos(i, 0, j = MathHelper.func_76128_c((double)this.field_70161_v)))) {
            double d0 = (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) * 0.66;
            int k = MathHelper.func_76128_c((double)(this.field_70163_u - this.func_70033_W() + d0));
            return this.field_70170_p.func_175626_b(new BlockPos(i, k, j), 0);
        }
        return 0;
    }

    public float func_70013_c() {
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        if (!this.field_70170_p.func_175623_d(new BlockPos(i, 0, j = MathHelper.func_76128_c((double)this.field_70161_v)))) {
            double d0 = (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) * 0.66;
            int k = MathHelper.func_76128_c((double)(this.field_70163_u - this.func_70033_W() + d0));
            return this.field_70170_p.func_175724_o(new BlockPos(i, k, j));
        }
        return 0.0f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        ConfigSpawnEntity.syncInstance((EntityLivingBase)this, EntityDireSlime.config.settings);
    }

    protected int func_70805_n() {
        int res = (int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        return res;
    }

    protected void func_70105_a(float p_70105_1_, float p_70105_2_) {
        int i = this.func_70809_q();
        super.func_70105_a((float)i, (float)i);
    }

    public void func_70100_b_(EntityPlayer player) {
        int i = this.func_70809_q();
        if (this.func_70685_l((Entity)player) && this.func_70068_e((Entity)player) < (double)i * (double)i && player.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_70805_n())) {
            this.func_184185_a(SoundEvents.field_187870_fk, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
        }
    }

    protected float func_70655_b(DamageSource ds, float dmg) {
        if (!ds.func_76363_c()) {
            return Math.min(Math.max(dmg - 3.0f - (float)this.func_70809_q(), (float)this.func_70809_q()) / 2.0f, dmg);
        }
        return dmg;
    }

    protected ResourceLocation func_184647_J() {
        return new ResourceLocation("emberroot", "entity/slime_block");
    }

    public static enum SlimeConf {
        SMALL(1, 0.4),
        MEDIUM(2, 0.2),
        LARGE(4, 0.4);

        public final int size;
        public final double chance;

        private SlimeConf(int size, double chance) {
            this.size = size;
            this.chance = chance;
        }

        static SlimeConf getConfForSize(int size) {
            for (SlimeConf conf : SlimeConf.values()) {
                if (conf.size != size) continue;
                return conf;
            }
            return SMALL;
        }

        SlimeConf bigger() {
            int index = this.ordinal() + 1;
            if (index >= SlimeConf.values().length) {
                return null;
            }
            return SlimeConf.values()[index];
        }
    }

    public static enum VariantColors {
        DIRT,
        SAND,
        STONE,
        GRAVEL,
        NETHER,
        SNOW,
        END;


        public String nameLower() {
            return this.name().toLowerCase();
        }
    }
}

