/*
 * Decompiled with CFR 0.152.
 */
package teamroots.emberroot.entity.mount;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderHorse;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.LayeredTexture;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import teamroots.emberroot.config.ConfigManager;
import teamroots.emberroot.util.RenderUtil;

public class RenderFallenMount
extends RenderHorse {
    private static final String[] horseArmorTextures = new String[]{null, "textures/entity/horse/armor/horse_armor_iron.png", "textures/entity/horse/armor/horse_armor_gold.png", "textures/entity/horse/armor/horse_armor_diamond.png"};
    private static final String textureName = "textures/entity/horse/horse_zombie.png";
    private static final ResourceLocation zombieHorseTexture = new ResourceLocation("textures/entity/horse/horse_zombie.png");
    private static final Map<String, ResourceLocation> textureCache = Maps.newHashMap();

    public RenderFallenMount(RenderManager rm) {
        super(rm);
    }

    public void doRender(EntityHorse entity, double x, double y, double z, float entityYaw, float partialTicks) {
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
        if (ConfigManager.renderDebugHitboxes) {
            RenderUtil.renderEntityBoundingBox((EntityLiving)entity, x, y, z);
        }
    }

    protected ResourceLocation func_110775_a(EntityHorse horse) {
        if (horse.func_70658_aO() == 0) {
            return zombieHorseTexture;
        }
        return this.getArmoredTexture(horse);
    }

    private ResourceLocation getArmoredTexture(EntityHorse horse) {
        String s = horseArmorTextures[horse.func_184783_dl().ordinal()];
        ResourceLocation resourcelocation = textureCache.get(s);
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation("Layered:" + s);
            Minecraft.func_71410_x().func_110434_K().func_110579_a(resourcelocation, (ITextureObject)new LayeredTexture(new String[]{textureName, s}));
            textureCache.put(s, resourcelocation);
        }
        return resourcelocation;
    }

    public static class Factory
    implements IRenderFactory<EntityHorse> {
        public Render<? super EntityHorse> createRenderFor(RenderManager manager) {
            return new RenderFallenMount(manager);
        }
    }
}

