/*
 * Decompiled with CFR 0.152.
 */
package teamroots.emberroot.entity.knight;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import teamroots.emberroot.config.ConfigSpawnEntity;
import teamroots.emberroot.entity.ai.EntityAIMountedAttackOnCollide;
import teamroots.emberroot.entity.mount.EntityFallenMount;
import teamroots.emberroot.util.EntityUtil;
import teamroots.emberroot.util.SpawnUtil;

public class EntityFallenKnight
extends EntitySkeleton {
    public static final String NAME = "knight_fallen";
    public static ConfigSpawnEntity config = new ConfigSpawnEntity(EntityFallenKnight.class, EnumCreatureType.MONSTER);
    public static boolean attackVillagers;
    private final EntityAIBreakDoor breakDoorAI = new EntityAIBreakDoor((EntityLiving)this);
    private boolean canBreakDoors = false;
    private EntityLivingBase lastAttackTarget = null;
    private boolean firstUpdate = true;
    private boolean isMounted = false;
    private boolean spawned = false;
    public static float fallenKnightChanceMounted;
    private float fallenKnightChancePerArmorPiece = 0.66f;
    private float fallenKnightChanceArmorUpgrade = 0.2f;
    private EntityAIMountedAttackOnCollide aiAttackOnCollide;

    public EntityFallenKnight(World world) {
        super(world);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        ConfigSpawnEntity.syncInstance((EntityLivingBase)this, EntityFallenKnight.config.settings);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        if (attackVillagers) {
            this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, false));
        }
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187899_gZ;
    }

    protected SoundEvent func_184601_bQ(DamageSource s) {
        return SoundEvents.field_187934_hh;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187930_hd;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.firstUpdate && !this.field_70170_p.field_72995_K) {
            this.spawnMount();
        }
        if (this.isRidingMount()) {
            EntityLiving entLiving = (EntityLiving)this.func_184187_bx();
            if (this.lastAttackTarget != this.func_70638_az() || this.firstUpdate) {
                EntityUtil.cancelCurrentTasks(entLiving);
                this.lastAttackTarget = this.func_70638_az();
            }
        }
        this.firstUpdate = false;
        if (!this.isMounted == this.isRidingMount()) {
            System.out.println("attack on collide reset");
            this.getAiAttackOnCollide().func_75251_c();
            this.func_70661_as().func_75499_g();
            this.isMounted = this.isRidingMount();
        }
    }

    private boolean isRidingMount() {
        return this.func_184218_aH() && this.func_184187_bx().getClass() == EntityFallenMount.class;
    }

    public void func_184210_p() {
        if (this.field_70128_L || this.func_184187_bx() != null && this.func_184187_bx().field_70128_L) {
            super.func_184210_p();
            return;
        }
    }

    public void func_85036_m() {
        super.func_85036_m();
        if (this.isMounted) {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.getAiAttackOnCollide());
        }
    }

    public EntityAIMountedAttackOnCollide getAiAttackOnCollide() {
        if (this.aiAttackOnCollide == null) {
            this.aiAttackOnCollide = new EntityAIMountedAttackOnCollide((EntityCreature)this, EntityPlayer.class, 2.0, 2.0, false);
        }
        return this.aiAttackOnCollide;
    }

    protected void func_70623_bb() {
        Entity mount = this.func_184187_bx();
        super.func_70623_bb();
        if (this.field_70128_L && mount != null) {
            mount.func_70106_y();
        }
    }

    private void spawnMount() {
        if (this.func_184218_aH() || !this.spawned) {
            return;
        }
        EntityFallenMount mount = null;
        if (this.field_70146_Z.nextFloat() <= fallenKnightChanceMounted) {
            mount = new EntityFallenMount(this.field_70170_p);
            mount.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            DifficultyInstance di = this.field_70170_p.func_175649_E(new BlockPos((Entity)mount));
            mount.func_180482_a(di, null);
            if (!SpawnUtil.isSpaceAvailableForSpawn(this.field_70170_p, (EntityLiving)mount, false)) {
                mount = null;
            }
        }
        if (mount != null) {
            this.func_98053_h(false);
            this.setCanBreakDoors(false);
            this.field_70170_p.func_72838_d((Entity)mount);
            this.func_184220_m((Entity)mount);
        }
    }

    private void addRandomArmor() {
        float occupiedDiffcultyMultiplier = EntityUtil.getDifficultyMultiplierForLocation(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        int equipmentLevel = this.getRandomEquipmentLevel(occupiedDiffcultyMultiplier);
        int armorLevel = equipmentLevel;
        if (armorLevel == 1) {
            ++armorLevel;
        }
        float chancePerPiece = this.fallenKnightChancePerArmorPiece;
        chancePerPiece *= 1.0f + occupiedDiffcultyMultiplier;
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            Item item;
            ItemStack itemStack = this.func_184582_a(slot);
            if (itemStack != null || !(this.field_70146_Z.nextFloat() <= chancePerPiece) || (item = EntityLiving.func_184636_a((EntityEquipmentSlot)slot, (int)armorLevel)) == null) continue;
            ItemStack stack = new ItemStack(item);
            if (armorLevel == 0) {
                ((ItemArmor)item).func_82813_b(stack, 0);
            }
            this.func_184201_a(slot, stack);
        }
    }

    private int getRandomEquipmentLevel(float occupiedDiffcultyMultiplier) {
        float chanceImprovedArmor = this.fallenKnightChanceArmorUpgrade;
        chanceImprovedArmor *= 1.0f + occupiedDiffcultyMultiplier;
        int armorLevel = this.field_70146_Z.nextInt(2);
        for (int i = 0; i < 2; ++i) {
            if (!(this.field_70146_Z.nextFloat() <= chanceImprovedArmor)) continue;
            ++armorLevel;
        }
        return armorLevel;
    }

    protected boolean isHardDifficulty() {
        return EntityUtil.isHardDifficulty(this.field_70170_p);
    }

    private ItemStack getWeaponForLevel() {
        int swordLevel;
        int n = swordLevel = this.isHardDifficulty() ? 2 : 1;
        if (swordLevel < 2) {
            swordLevel += this.field_70146_Z.nextInt(this.isHardDifficulty() ? 3 : 2);
            swordLevel = Math.min(swordLevel, 2);
        }
        switch (swordLevel) {
            case 0: {
                return new ItemStack(Items.field_151041_m);
            }
            case 1: {
                return new ItemStack(Items.field_151052_q);
            }
            case 2: {
                return new ItemStack(Items.field_151040_l);
            }
            case 4: {
                return new ItemStack(Items.field_151048_u);
            }
        }
        return new ItemStack(Items.field_151040_l);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance di, IEntityLivingData livingData) {
        this.spawned = true;
        this.addRandomArmor();
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, this.getWeaponForLevel());
        this.func_180483_b(di);
        float f = di.func_180170_c();
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * f);
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * f);
        this.setCanBreakDoors(this.field_70146_Z.nextFloat() < f * 0.1f);
        return livingData;
    }

    public void func_70014_b(NBTTagCompound root) {
        super.func_70014_b(root);
        root.func_74757_a("canBreakDoors", this.canBreakDoors);
    }

    public void func_70037_a(NBTTagCompound root) {
        super.func_70037_a(root);
        this.setCanBreakDoors(root.func_74767_n("canBreakDoors"));
    }

    private void setCanBreakDoors(boolean val) {
        if (this.canBreakDoors != val) {
            this.canBreakDoors = val;
            if (this.canBreakDoors) {
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.breakDoorAI);
            } else {
                this.field_70714_bg.func_85156_a((EntityAIBase)this.breakDoorAI);
            }
        }
    }

    protected ResourceLocation func_184647_J() {
        return new ResourceLocation("emberroot", "entity/knight_fallen");
    }

    static {
        fallenKnightChanceMounted = 0.75f;
    }
}

