/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.texture.type;

import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import team.chisel.ctm.api.texture.ICTMTexture;
import team.chisel.ctm.api.texture.TextureType;
import team.chisel.ctm.api.util.TextureInfo;
import team.chisel.ctm.client.texture.ctx.TextureContextCTM;
import team.chisel.ctm.client.texture.render.TextureEdges;
import team.chisel.ctm.client.texture.type.TextureTypeCTM;
import team.chisel.ctm.client.util.CTMLogic;
import team.chisel.ctm.client.util.Dir;

@TextureType(value="edges")
public class TextureTypeEdges
extends TextureTypeCTM {
    @Override
    public ICTMTexture<? extends TextureTypeCTM> makeTexture(TextureInfo info) {
        return new TextureEdges(this, info);
    }

    @Override
    public TextureContextCTM getBlockRenderContext(IBlockState state, IBlockAccess world, BlockPos pos, ICTMTexture<?> tex) {
        return new TextureContextCTM(state, world, pos, (TextureEdges)tex){

            @Override
            protected CTMLogic createCTM(IBlockState state) {
                CTMLogic parent = super.createCTM(state);
                CTMLogicEdges ret = new CTMLogicEdges();
                ret.ignoreStates(parent.ignoreStates()).stateComparator(parent.stateComparator());
                ret.disableObscuredFaceCheck = parent.disableObscuredFaceCheck;
                return ret;
            }
        };
    }

    @Override
    public int requiredTextures() {
        return 3;
    }

    public static class CTMLogicEdges
    extends CTMLogic {
        private boolean obscured;

        @Override
        public boolean isConnected(IBlockAccess world, BlockPos current, BlockPos connection, EnumFacing dir, IBlockState state) {
            if (this.isObscured()) {
                return false;
            }
            IBlockState obscuring = world.func_180495_p(current.func_177972_a(dir));
            if (this.stateComparator(state, obscuring, dir)) {
                this.setObscured(true);
                return false;
            }
            IBlockState con = world.func_180495_p(connection);
            IBlockState obscuringcon = world.func_180495_p(connection.func_177972_a(dir));
            if (this.stateComparator(state, con, dir) || this.stateComparator(state, obscuringcon, dir)) {
                Vec3d difference = new Vec3d((Vec3i)connection.func_177973_b((Vec3i)current));
                if (difference.func_189985_c() > 1.0) {
                    Vec3d vB;
                    Vec3d vA;
                    difference = difference.func_72432_b();
                    if (dir.func_176740_k() == EnumFacing.Axis.Z) {
                        difference = difference.func_178785_b(-1.5707964f);
                    }
                    float ang = 0.7853982f;
                    if (dir.func_176740_k().func_176720_b()) {
                        vA = difference.func_178785_b(ang);
                        vB = difference.func_178785_b(-ang);
                    } else {
                        vA = difference.func_178789_a(ang);
                        vB = difference.func_178789_a(-ang);
                    }
                    BlockPos posA = new BlockPos(vA).func_177971_a((Vec3i)current);
                    BlockPos posB = new BlockPos(vB).func_177971_a((Vec3i)current);
                    return world.func_180495_p(posA) == state && !this.stateComparator(state, world.func_180495_p(posA.func_177972_a(dir)), dir) || world.func_180495_p(posB) == state && !this.stateComparator(state, world.func_180495_p(posA.func_177972_a(dir)), dir);
                }
                return true;
            }
            return false;
        }

        @Override
        protected void fillSubmaps(int idx) {
            Dir[] dirs = submapMap[idx];
            if (!this.connectedOr(dirs[0], dirs[1]) && this.connected(dirs[2])) {
                this.submapCache[idx] = submapOffsets[idx];
            } else {
                super.fillSubmaps(idx);
            }
        }

        @Override
        public long serialized() {
            return this.isObscured() ? super.serialized() | 0x100L : super.serialized();
        }

        public void setObscured(boolean obscured) {
            this.obscured = obscured;
        }

        public boolean isObscured() {
            return this.obscured;
        }
    }
}

