/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.helpers;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import squeek.applecore.api.AppleCoreAPI;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroupRegistry;
import squeek.spiceoflife.items.ItemFoodContainer;

public class FoodHelper {
    public static boolean isValidFood(@Nonnull ItemStack itemStack) {
        return FoodHelper.isFood(itemStack) && !FoodHelper.isFoodContainer(itemStack);
    }

    public static boolean canFoodDiminish(@Nonnull ItemStack itemStack) {
        return !FoodGroupRegistry.isFoodBlacklisted(itemStack);
    }

    public static boolean isFood(@Nonnull ItemStack itemStack) {
        return AppleCoreAPI.accessor.isFood(itemStack);
    }

    public static boolean isFoodContainer(@Nonnull ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof ItemFoodContainer;
    }

    public static float getExhaustionLevel(EntityPlayer player) {
        return AppleCoreAPI.accessor.getExhaustion(player);
    }

    public static boolean isDirectlyEdible(@Nonnull ItemStack itemStack) {
        return itemStack.func_77973_b() != Items.field_151105_aU && !FoodHelper.isFoodContainer(itemStack);
    }

    public static float getMaxExhaustionLevel(EntityPlayer player) {
        return AppleCoreAPI.accessor.getMaxExhaustion(player);
    }

    public static float getSaturationModifierFromIncrement(float saturationIncrement, int hunger) {
        return hunger != 0 ? saturationIncrement / ((float)hunger * 2.0f) : 0.0f;
    }
}

