/*
 * Decompiled with CFR 0.152.
 */
package de.lellson.roughmobs2.misc;

import de.lellson.roughmobs2.ai.misc.RoughAISearchForRider;
import de.lellson.roughmobs2.config.RoughConfig;
import de.lellson.roughmobs2.features.HostileHorseFeatures;
import de.lellson.roughmobs2.misc.BossHelper;
import de.lellson.roughmobs2.misc.Constants;
import de.lellson.roughmobs2.misc.FeatureHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntitySkeletonHorse;
import net.minecraft.entity.passive.EntityZombieHorse;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;

public class MountHelper {
    public static final Random RND = new Random();

    public static AbstractHorse createHorse(World world, Entity owner, HorseType type) {
        AbstractHorse horse = type.createInstance(world);
        horse.func_70107_b(owner.field_70165_t, owner.field_70163_u, owner.field_70161_v);
        horse.func_180482_a(world.func_175649_E(owner.func_180425_c()), (IEntityLivingData)null);
        horse.field_70172_ad = 60;
        horse.func_110234_j(true);
        horse.func_70873_a(0);
        horse.getEntityData().func_74757_a(HostileHorseFeatures.ROUGH_HORSE, true);
        world.func_72838_d((Entity)horse);
        return horse;
    }

    public static boolean tryMountHorse(Entity rider, HorseType type, int chance, int minY) {
        if (rider.field_70163_u < (double)minY) {
            return false;
        }
        if (!BossHelper.isBoss(rider) && (chance <= 0 || RND.nextInt(chance) != 0 || rider.func_184218_aH() || rider instanceof EntityZombie && ((EntityZombie)rider).func_70631_g_())) {
            return false;
        }
        if (rider.getEntityData().func_74767_n(Rider.RIDER)) {
            return false;
        }
        AbstractHorse mount = MountHelper.createHorse(rider.field_70170_p, rider, type);
        rider.func_184220_m((Entity)mount);
        return true;
    }

    public static enum HorseType {
        NORMAL,
        ZOMBIE,
        SKELETON;


        public AbstractHorse createInstance(World world) {
            switch (this) {
                case ZOMBIE: {
                    return new EntityZombieHorse(world);
                }
                case SKELETON: {
                    return new EntitySkeletonHorse(world);
                }
            }
            return new EntityHorse(world);
        }
    }

    public static class Rider {
        public static final String RIDER = Constants.unique("isrider");
        private final String name;
        private final String[] defaultEntities;
        private final int defaultChance;
        private String[] entities;
        private int chance;
        private int randomRiderChance;
        private List<EntityEntry> entries;

        public Rider(String name, String[] defaultEntities, int defaultChance) {
            this.name = name;
            this.defaultEntities = defaultEntities;
            this.defaultChance = defaultChance;
        }

        public void initConfigs() {
            this.chance = RoughConfig.getInteger(this.name, "RiderChance", this.defaultChance, 0, Short.MAX_VALUE, "Chance (1 in X) for a " + this.name + " to spawn with another entity riding it\nSet to 0 to disable this feature");
            this.entities = RoughConfig.getStringArray(this.name, "RiderEntities", this.defaultEntities, "Entities which may ride on " + this.name + "s");
            this.randomRiderChance = RoughConfig.getInteger(this.name, "RiderChanceRandom", 10, 0, Short.MAX_VALUE, "Chance (1 in X) that a randomly spawned entity from the RiderEntities list can start riding on random " + this.name + "s\nSet to 0 to disable this feature");
        }

        public void postInit() {
            this.entries = FeatureHelper.getEntitiesFromNames(this.entities);
        }

        public void addAI(EntityLiving mount) {
            if (this.randomRiderChance > 0) {
                mount.field_70714_bg.func_75776_a(1, (EntityAIBase)new RoughAISearchForRider(mount, this.getPossibleRiders(), 32, this.randomRiderChance));
            }
        }

        public void tryAddRider(EntityLivingBase mount) {
            if (this.chance <= 0 || mount == null || this.entries.isEmpty() || mount.getEntityData().func_74767_n(RIDER) || RND.nextInt(this.chance) != 0) {
                return;
            }
            EntityEntry entry = this.entries.get(RND.nextInt(this.entries.size()));
            Entity entity = entry.newInstance(mount.func_130014_f_());
            entity.func_70107_b(mount.field_70165_t, mount.field_70163_u, mount.field_70161_v);
            entity.field_70172_ad = 60;
            entity.getEntityData().func_74757_a(RIDER, true);
            mount.func_130014_f_().func_72838_d(entity);
            if (!(entity.func_184218_aH() || entity.func_184207_aI() || mount.func_184218_aH() || mount.func_184207_aI())) {
                entity.func_184220_m((Entity)mount);
            }
        }

        public boolean isPossibleRider(Entity entity) {
            for (EntityEntry entry : this.entries) {
                if (entry.getEntityClass() != entity.getClass()) continue;
                return true;
            }
            return false;
        }

        public List<Class<? extends Entity>> getPossibleRiders() {
            ArrayList<Class<? extends Entity>> list = new ArrayList<Class<? extends Entity>>();
            for (EntityEntry entry : this.entries) {
                list.add(entry.getEntityClass());
            }
            return list;
        }
    }
}

