/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.worktables.integration.jei;

import com.codetaylor.mc.artisanworktables.api.internal.recipe.IArtisanIngredient;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.IArtisanItemStack;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.OutputWeightPair;
import com.codetaylor.mc.artisanworktables.api.internal.reference.EnumTier;
import com.codetaylor.mc.artisanworktables.api.recipe.ArtisanRecipe;
import com.codetaylor.mc.athenaeum.gui.GuiHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.config.GuiUtils;

public class JEIRecipeWrapper
implements IRecipeWrapper {
    private static final ResourceLocation RECIPE_BACKGROUND = new ResourceLocation("artisanworktables", "textures/gui/recipe_background.png");
    public static EnumTier CATEGORY_TIER = EnumTier.WORKTABLE;
    private ArtisanRecipe artisanRecipe;
    private List<List<ItemStack>> inputs;
    private List<List<ItemStack>> secondaryInputs;
    private List<List<ItemStack>> tools;
    private List<ItemStack> output;

    public JEIRecipeWrapper(ArtisanRecipe artisanRecipe) {
        this.artisanRecipe = artisanRecipe;
        this.inputs = new ArrayList<List<ItemStack>>();
        this.secondaryInputs = new ArrayList<List<ItemStack>>();
        this.tools = new ArrayList<List<ItemStack>>();
        for (IArtisanIngredient input : this.artisanRecipe.getIngredientList()) {
            this.inputs.add(Arrays.asList(input.toIngredient().func_193365_a()));
        }
        for (int i = 0; i < artisanRecipe.getToolCount(); ++i) {
            IArtisanItemStack[] tools = this.artisanRecipe.getTools(i);
            ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>(tools.length);
            for (IArtisanItemStack tool : tools) {
                itemStackList.add(tool.toItemStack());
            }
            this.tools.add(itemStackList);
        }
        List<OutputWeightPair> output = this.artisanRecipe.getOutputWeightPairList();
        this.output = new ArrayList<ItemStack>(output.size());
        for (OutputWeightPair pair : output) {
            this.output.add(pair.getOutput().toItemStack());
        }
        for (IArtisanIngredient ingredient : this.artisanRecipe.getSecondaryIngredients()) {
            this.secondaryInputs.add(Arrays.asList(ingredient.toIngredient().func_193365_a()));
        }
    }

    public List<List<ItemStack>> getInputs() {
        return this.inputs;
    }

    public FluidStack getFluidStack() {
        return this.artisanRecipe.getFluidIngredient();
    }

    public List<OutputWeightPair> getWeightedOutput() {
        return this.artisanRecipe.getOutputWeightPairList();
    }

    public List<ItemStack> getOutput() {
        return this.output;
    }

    public boolean isShaped() {
        return this.artisanRecipe.isShaped();
    }

    public int getWidth() {
        return this.artisanRecipe.getWidth();
    }

    public int getHeight() {
        return this.artisanRecipe.getHeight();
    }

    public List<List<ItemStack>> getTools() {
        return this.tools;
    }

    public List<List<ItemStack>> getSecondaryInputs() {
        return this.secondaryInputs;
    }

    public ItemStack getSecondaryOutput() {
        return this.artisanRecipe.getSecondaryOutput().toItemStack();
    }

    public ItemStack getTertiaryOutput() {
        return this.artisanRecipe.getTertiaryOutput().toItemStack();
    }

    public ItemStack getQuaternaryOutput() {
        return this.artisanRecipe.getQuaternaryOutput().toItemStack();
    }

    public void getIngredients(IIngredients ingredients) {
        ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
        inputs.addAll(this.inputs);
        inputs.addAll(this.tools);
        inputs.addAll(this.secondaryInputs);
        ingredients.setInputLists(ItemStack.class, inputs);
        FluidStack fluidIngredient = this.artisanRecipe.getFluidIngredient();
        if (fluidIngredient != null) {
            ingredients.setInput(FluidStack.class, (Object)fluidIngredient);
        }
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        output.addAll(this.output);
        output.add(this.getSecondaryOutput());
        output.add(this.getTertiaryOutput());
        output.add(this.getQuaternaryOutput());
        ingredients.setOutputs(ItemStack.class, output);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        float chance;
        int yPos;
        int xPos;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1000.0f);
        String experienceString = null;
        if (this.artisanRecipe.getExperienceRequired() > 0) {
            experienceString = this.artisanRecipe.consumeExperience() ? I18n.func_135052_a((String)"jei.artisanworktables.xp.cost", (Object[])new Object[]{this.artisanRecipe.getExperienceRequired()}) : I18n.func_135052_a((String)"jei.artisanworktables.xp.required", (Object[])new Object[]{this.artisanRecipe.getExperienceRequired()});
        } else if (this.artisanRecipe.getLevelRequired() > 0) {
            experienceString = this.artisanRecipe.consumeExperience() ? I18n.func_135052_a((String)"jei.artisanworktables.level.cost", (Object[])new Object[]{this.artisanRecipe.getLevelRequired()}) : I18n.func_135052_a((String)"jei.artisanworktables.level.required", (Object[])new Object[]{this.artisanRecipe.getLevelRequired()});
        }
        if (experienceString != null) {
            this.drawExperienceString(minecraft, recipeHeight, experienceString);
        }
        if (CATEGORY_TIER == EnumTier.WORKTABLE) {
            this.drawToolDamageString(minecraft, 83, 52);
        } else if (CATEGORY_TIER == EnumTier.WORKSTATION) {
            this.drawToolDamageString(minecraft, 83, 33);
        } else if (CATEGORY_TIER == EnumTier.WORKSHOP) {
            this.drawToolDamageString(minecraft, 119, 39);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1000.0f);
        GlStateManager.func_179126_j();
        GlStateManager.func_179094_E();
        if (CATEGORY_TIER == EnumTier.WORKSHOP) {
            xPos = 256;
            yPos = 12;
            if (!this.artisanRecipe.getSecondaryOutput().isEmpty()) {
                chance = this.artisanRecipe.getSecondaryOutputChance();
                this.drawSecondaryOutputChanceString(minecraft, chance, xPos, yPos);
            }
            if (!this.artisanRecipe.getTertiaryOutput().isEmpty()) {
                chance = this.artisanRecipe.getTertiaryOutputChance();
                this.drawSecondaryOutputChanceString(minecraft, chance, xPos + 36, yPos);
            }
            if (!this.artisanRecipe.getQuaternaryOutput().isEmpty()) {
                chance = this.artisanRecipe.getQuaternaryOutputChance();
                this.drawSecondaryOutputChanceString(minecraft, chance, xPos + 72, yPos);
            }
        } else {
            xPos = 331;
            yPos = 32;
            if (!this.artisanRecipe.getSecondaryOutput().isEmpty()) {
                chance = this.artisanRecipe.getSecondaryOutputChance();
                this.drawSecondaryOutputChanceString(minecraft, chance, xPos, yPos);
            }
            if (!this.artisanRecipe.getTertiaryOutput().isEmpty()) {
                chance = this.artisanRecipe.getTertiaryOutputChance();
                this.drawSecondaryOutputChanceString(minecraft, chance, xPos, yPos + 36);
            }
            if (!this.artisanRecipe.getQuaternaryOutput().isEmpty()) {
                chance = this.artisanRecipe.getQuaternaryOutputChance();
                this.drawSecondaryOutputChanceString(minecraft, chance, xPos, yPos + 72);
            }
        }
        GlStateManager.func_179121_F();
        if (!this.artisanRecipe.isShaped()) {
            if (CATEGORY_TIER == EnumTier.WORKSHOP) {
                GuiHelper.drawTexturedRect((Minecraft)minecraft, (ResourceLocation)RECIPE_BACKGROUND, (int)288, (int)58, (int)18, (int)17, (int)0, (double)0.0, (double)0.0, (double)1.0, (double)1.0);
            } else {
                GuiHelper.drawTexturedRect((Minecraft)minecraft, (ResourceLocation)RECIPE_BACKGROUND, (int)234, (int)8, (int)18, (int)17, (int)0, (double)0.0, (double)0.0, (double)1.0, (double)1.0);
            }
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)-8.0f, (float)0.0f);
        if (!this.artisanRecipe.isShaped()) {
            int x = 117;
            int y = 4;
            if (CATEGORY_TIER == EnumTier.WORKSHOP) {
                x = 144;
                y = 29;
            }
            if (mouseX >= x && mouseX <= x + 9 && mouseY >= y && mouseY <= y + 9) {
                ArrayList<String> tooltip = new ArrayList<String>();
                tooltip.add(I18n.func_135052_a((String)"jei.artisanworktables.tooltip.shapeless.recipe", (Object[])new Object[0]));
                GuiUtils.drawHoveringText(tooltip, (int)mouseX, (int)mouseY, (int)minecraft.field_71443_c, (int)minecraft.field_71440_d, (int)200, (FontRenderer)minecraft.field_71466_p);
            }
        }
        GlStateManager.func_179121_F();
    }

    private void drawSecondaryOutputChanceString(Minecraft minecraft, float secondaryOutputChance, int positionX, int positionY) {
        String label = (int)(secondaryOutputChance * 100.0f) + "%";
        minecraft.field_71466_p.func_175065_a(label, (float)positionX - (float)minecraft.field_71466_p.func_78256_a(label) * 0.5f, (float)positionY, -1, true);
    }

    private void drawExperienceString(Minecraft minecraft, int recipeHeight, String experienceString) {
        minecraft.field_71466_p.func_175065_a(experienceString, 5.0f, (float)(recipeHeight - 10), -8323296, true);
    }

    private void drawToolDamageString(Minecraft minecraft, int offsetX, int offsetY) {
        for (int i = 0; i < this.artisanRecipe.getToolCount(); ++i) {
            String label = "-" + this.artisanRecipe.getToolDamage(i);
            minecraft.field_71466_p.func_175065_a(label, (float)offsetX - (float)minecraft.field_71466_p.func_78256_a(label) * 0.5f, (float)(offsetY + 22 * i), -1, true);
        }
    }
}

