/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.worktables.gui;

import com.codetaylor.mc.artisanworktables.api.internal.recipe.ICraftingContext;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.ICraftingMatrixStackHandler;
import com.codetaylor.mc.artisanworktables.api.internal.reference.EnumTier;
import com.codetaylor.mc.artisanworktables.api.internal.util.Util;
import com.codetaylor.mc.artisanworktables.api.recipe.IArtisanRecipe;
import com.codetaylor.mc.artisanworktables.modules.toolbox.tile.TileEntityToolbox;
import com.codetaylor.mc.artisanworktables.modules.worktables.ModuleWorktables;
import com.codetaylor.mc.artisanworktables.modules.worktables.ModuleWorktablesConfig;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.slot.CraftingIngredientSlot;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.slot.CraftingResultSlot;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.slot.CraftingSecondarySlot;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.slot.CraftingToolSlot;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.slot.PatternResultSlot;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.slot.PatternSlot;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.slot.ResultSlot;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.slot.ToolboxSideSlot;
import com.codetaylor.mc.artisanworktables.modules.worktables.network.CPacketWorktableContainerJoinedBlockBreak;
import com.codetaylor.mc.artisanworktables.modules.worktables.tile.spi.ITileEntityDesigner;
import com.codetaylor.mc.artisanworktables.modules.worktables.tile.spi.TileEntityBase;
import com.codetaylor.mc.artisanworktables.modules.worktables.tile.spi.TileEntitySecondaryInputBase;
import com.codetaylor.mc.artisanworktables.modules.worktables.tile.workshop.TileEntityWorkshop;
import com.codetaylor.mc.artisanworktables.modules.worktables.tile.workstation.TileEntityWorkstation;
import com.codetaylor.mc.athenaeum.gui.ContainerBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class Container
extends ContainerBase {
    private final CraftingResultSlot craftingResultSlot;
    private World world;
    private TileEntityBase tile;
    private TileEntityToolbox toolbox;
    private ITileEntityDesigner designersTable;
    private final ItemStackHandler resultHandler;
    private final ItemStackHandler patternResultHandler;
    private FluidStack lastFluidStack;
    private final EntityPlayer player;
    private final List<ToolboxSideSlot> toolboxSideSlotList;
    private final int slotIndexResult;
    private final int slotIndexCraftingMatrixStart;
    private final int slotIndexCraftingMatrixEnd;
    private final int slotIndexInventoryStart;
    private final int slotIndexInventoryEnd;
    private final int slotIndexHotbarStart;
    private final int slotIndexHotbarEnd;
    private final int slotIndexToolsStart;
    private final int slotIndexToolsEnd;
    private final int slotIndexSecondaryOutputStart;
    private final int slotIndexSecondaryOutputEnd;
    private final int slotIndexToolboxStart;
    private final int slotIndexToolboxEnd;
    private final int slotIndexSecondaryInputStart;
    private final int slotIndexSecondaryInputEnd;
    private final int slotIndexPattern;
    private final int slotIndexPatternResult;
    private final ItemStackHandler patternHandler;

    public Container(InventoryPlayer playerInventory, World world, TileEntityBase tile) {
        super(playerInventory);
        int i;
        this.world = world;
        this.tile = tile;
        this.toolbox = this.getToolbox(this.tile);
        this.designersTable = this.getAdjacentDesignersTable(this.tile);
        this.tile.addContainer(this);
        this.player = playerInventory.field_70458_d;
        Runnable slotChangeListener = this::updateRecipeOutput;
        this.slotIndexResult = this.nextSlotIndex;
        this.resultHandler = new ItemStackHandler(1);
        this.craftingResultSlot = new CraftingResultSlot(slotChangeListener, this.tile, (IItemHandler)this.resultHandler, 0, this.containerResultPositionGetX(), this.containerResultPositionGetY());
        this.containerSlotAdd((Slot)this.craftingResultSlot);
        ICraftingMatrixStackHandler craftingMatrixHandler = this.tile.getCraftingMatrixHandler();
        this.slotIndexCraftingMatrixStart = this.nextSlotIndex;
        for (int y = 0; y < craftingMatrixHandler.getHeight(); ++y) {
            for (int x = 0; x < craftingMatrixHandler.getWidth(); ++x) {
                this.containerSlotAdd((Slot)new CraftingIngredientSlot(slotChangeListener, craftingMatrixHandler, x + y * craftingMatrixHandler.getWidth(), 20 + x * 18, 17 + y * 18));
            }
        }
        this.slotIndexCraftingMatrixEnd = this.nextSlotIndex - 1;
        this.slotIndexInventoryStart = this.nextSlotIndex;
        this.containerPlayerInventoryAdd();
        this.slotIndexInventoryEnd = this.nextSlotIndex - 1;
        this.slotIndexHotbarStart = this.nextSlotIndex;
        this.containerPlayerHotbarAdd();
        this.slotIndexHotbarEnd = this.nextSlotIndex - 1;
        this.slotIndexToolsStart = this.nextSlotIndex;
        ItemStackHandler toolHandler = this.tile.getToolHandler();
        for (int i2 = 0; i2 < toolHandler.getSlots(); ++i2) {
            int slotIndex = i2;
            this.containerSlotAdd((Slot)new CraftingToolSlot(slotChangeListener, itemStack -> this.tile.getWorktableRecipeRegistry().containsRecipeWithToolInSlot((ItemStack)itemStack, slotIndex), (IItemHandler)toolHandler, i2, 78 + this.containerToolOffsetGetX(), 35 + 22 * i2 + this.containerToolOffsetGetY()));
        }
        this.slotIndexToolsEnd = this.nextSlotIndex - 1;
        this.slotIndexSecondaryOutputStart = this.nextSlotIndex;
        if (this.tile instanceof TileEntityWorkshop) {
            for (i = 0; i < 3; ++i) {
                this.containerSlotAdd((Slot)new ResultSlot((IItemHandler)this.tile.getSecondaryOutputHandler(), i, 116 + i * 18, 17));
            }
        } else {
            for (i = 0; i < 3; ++i) {
                this.containerSlotAdd((Slot)new ResultSlot((IItemHandler)this.tile.getSecondaryOutputHandler(), i, 152, 17 + i * 18));
            }
        }
        this.slotIndexSecondaryOutputEnd = this.nextSlotIndex - 1;
        if (this.tile instanceof TileEntitySecondaryInputBase) {
            this.slotIndexSecondaryInputStart = this.nextSlotIndex;
            IItemHandlerModifiable handler = ((TileEntitySecondaryInputBase)this.tile).getSecondaryIngredientHandler();
            int slotCount = handler.getSlots();
            for (int i3 = 0; i3 < slotCount; ++i3) {
                this.containerSlotAdd((Slot)new CraftingSecondarySlot(slotChangeListener, (IItemHandler)handler, i3, 8 + i3 * 18, 75 + this.containerSecondaryInputOffsetGetY()));
            }
            this.slotIndexSecondaryInputEnd = this.nextSlotIndex - 1;
        } else {
            this.slotIndexSecondaryInputStart = -1;
            this.slotIndexSecondaryInputEnd = -1;
        }
        if (this.canPlayerUsePatternSlots()) {
            this.slotIndexPattern = this.nextSlotIndex;
            this.patternHandler = this.designersTable.getPatternStackHandler();
            this.containerSlotAdd((Slot)new PatternSlot(this::canPlayerUsePatternSlots, this::updateRecipeOutput, (IItemHandler)this.patternHandler, 0, -36 + this.containerToolboxOffsetGetX(), 8));
            this.slotIndexPatternResult = this.nextSlotIndex;
            this.patternResultHandler = new ItemStackHandler(1);
            this.containerSlotAdd((Slot)new PatternResultSlot(this::canPlayerUsePatternSlots, () -> {
                ItemStack stackInSlot = this.patternHandler.getStackInSlot(0);
                this.patternHandler.setStackInSlot(0, Util.decrease(stackInSlot, 1, false));
                this.updateRecipeOutput();
            }, (IItemHandler)this.patternResultHandler, 0, this.containerToolboxOffsetGetX(), 8));
        } else {
            this.patternHandler = null;
            this.patternResultHandler = null;
            this.slotIndexPattern = -1;
            this.slotIndexPatternResult = -1;
        }
        this.slotIndexToolboxStart = this.nextSlotIndex;
        if (this.canPlayerUseToolbox()) {
            this.toolboxSideSlotList = new ArrayList<ToolboxSideSlot>(27);
            ItemStackHandler itemHandler = this.toolbox.getItemHandler();
            int offsetY = this.designersTable != null ? 33 : 0;
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < 9; ++y) {
                    ToolboxSideSlot toolboxSideSlot = new ToolboxSideSlot(this::canPlayerUseToolbox, (IItemHandler)itemHandler, y + x * 9, x * -18 + this.containerToolboxOffsetGetX(), y * 18 + 8);
                    this.toolboxSideSlotList.add(toolboxSideSlot);
                    this.containerSlotAdd((Slot)toolboxSideSlot);
                    toolboxSideSlot.move(toolboxSideSlot.field_75223_e, toolboxSideSlot.field_75221_f + offsetY);
                }
            }
        } else {
            this.toolboxSideSlotList = Collections.emptyList();
        }
        this.slotIndexToolboxEnd = this.nextSlotIndex - 1;
        this.updateRecipeOutput();
    }

    private int containerToolboxOffsetGetX() {
        return -26;
    }

    private int containerSecondaryInputOffsetGetY() {
        if (this.tile instanceof TileEntityWorkshop) {
            return 36;
        }
        return 0;
    }

    private int containerToolOffsetGetX() {
        if (this.tile instanceof TileEntityWorkshop) {
            return 36;
        }
        return 0;
    }

    private int containerToolOffsetGetY() {
        if (this.tile instanceof TileEntityWorkstation) {
            return -11;
        }
        if (this.tile instanceof TileEntityWorkshop) {
            return 5;
        }
        return 0;
    }

    private int containerResultPositionGetY() {
        if (this.tile instanceof TileEntityWorkshop) {
            return 62;
        }
        return 35;
    }

    private int containerResultPositionGetX() {
        if (this.tile instanceof TileEntityWorkshop) {
            return 143;
        }
        return 115;
    }

    protected int containerInventoryPositionGetY() {
        if (this.tile instanceof TileEntityWorkstation) {
            return 107;
        }
        if (this.tile instanceof TileEntityWorkshop) {
            return 143;
        }
        return super.containerInventoryPositionGetY();
    }

    protected int containerInventoryPositionGetX() {
        return super.containerInventoryPositionGetX();
    }

    protected int containerHotbarPositionGetY() {
        if (this.tile instanceof TileEntityWorkstation) {
            return 165;
        }
        if (this.tile instanceof TileEntityWorkshop) {
            return 201;
        }
        return super.containerHotbarPositionGetY();
    }

    protected int containerHotbarPositionGetX() {
        return super.containerHotbarPositionGetX();
    }

    private TileEntityToolbox getToolbox(TileEntityBase tile) {
        return tile.getAdjacentToolbox();
    }

    private ITileEntityDesigner getAdjacentDesignersTable(TileEntityBase tile) {
        return tile.getAdjacentDesignersTable();
    }

    public void onJoinedBlockBreak(World world, BlockPos pos) {
        TileEntity tileEntity;
        if (!world.field_72995_K) {
            ModuleWorktables.PACKET_SERVICE.sendTo((IMessage)new CPacketWorktableContainerJoinedBlockBreak(pos), (EntityPlayerMP)this.player);
        }
        if ((tileEntity = world.func_175625_s(pos)) != null && tileEntity == this.designersTable) {
            for (ToolboxSideSlot slot : this.toolboxSideSlotList) {
                slot.moveToOrigin();
            }
        }
    }

    @Nullable
    public TileEntityToolbox getToolbox() {
        if (this.hasValidToolbox()) {
            return this.toolbox;
        }
        return null;
    }

    public boolean hasValidToolbox() {
        return this.toolbox != null && !this.toolbox.func_145837_r();
    }

    public boolean canPlayerUseToolbox() {
        return this.hasValidToolbox() && this.toolbox.canPlayerUse(this.player);
    }

    @Nullable
    public ITileEntityDesigner getDesignersTable() {
        if (this.hasValidPatternSlots()) {
            return this.designersTable;
        }
        return null;
    }

    public boolean hasValidPatternSlots() {
        return this.designersTable != null && !this.designersTable.getTileEntity().func_145837_r();
    }

    public boolean canPlayerUsePatternSlots() {
        return this.hasValidPatternSlots() && this.designersTable.canPlayerUse(this.player) && ModuleWorktablesConfig.patternSlotsEnabledForTier(this.tile.getTier());
    }

    public void updateRecipeOutput() {
        if (this.tile == null) {
            return;
        }
        IArtisanRecipe recipe = this.tile.getRecipe(this.player);
        if (recipe != null) {
            ICraftingContext context = this.tile.getCraftingContext(this.player);
            this.resultHandler.setStackInSlot(0, recipe.getBaseOutput(context).toItemStack());
            if (this.canPlayerUsePatternSlots()) {
                if (this.patternHandler.getStackInSlot(0).func_190926_b()) {
                    this.patternResultHandler.setStackInSlot(0, ItemStack.field_190927_a);
                } else {
                    ItemStack stack = new ItemStack((Item)ModuleWorktables.Items.DESIGN_PATTERN);
                    NBTTagCompound tag = new NBTTagCompound();
                    tag.func_74778_a("recipe", recipe.getName());
                    stack.func_77982_d(tag);
                    this.patternResultHandler.setStackInSlot(0, stack);
                }
            }
        } else {
            this.resultHandler.setStackInSlot(0, ItemStack.field_190927_a);
            if (this.canPlayerUsePatternSlots()) {
                this.patternResultHandler.setStackInSlot(0, ItemStack.field_190927_a);
            }
        }
    }

    public void func_75130_a(IInventory inventoryIn) {
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return this.tile.canPlayerUse(playerIn);
    }

    private boolean swapItemStack(int originSlotIndex, int targetSlotIndex, boolean swapOnlyEmtpyTarget) {
        Slot originSlot = (Slot)this.field_75151_b.get(originSlotIndex);
        Slot targetSlot = (Slot)this.field_75151_b.get(targetSlotIndex);
        ItemStack originStack = originSlot.func_75211_c();
        ItemStack targetStack = targetSlot.func_75211_c();
        if (swapOnlyEmtpyTarget && !targetStack.func_190926_b()) {
            return false;
        }
        if (originStack.func_77969_a(targetStack)) {
            return true;
        }
        if (!originStack.func_190926_b() && targetSlot.func_75214_a(originStack)) {
            if (targetStack.func_190926_b()) {
                targetSlot.func_75215_d(originStack);
                originSlot.func_75215_d(ItemStack.field_190927_a);
            } else {
                targetSlot.func_75215_d(originStack);
                originSlot.func_75215_d(targetStack);
            }
            return true;
        }
        return false;
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return slotIn != this.craftingResultSlot && super.func_94530_a(stack, slotIn);
    }

    private boolean isSlotSecondaryInput(int slotIndex) {
        return slotIndex >= this.slotIndexSecondaryInputStart && slotIndex <= this.slotIndexSecondaryInputEnd;
    }

    private boolean isSlotIndexResult(int slotIndex) {
        return slotIndex == this.slotIndexResult;
    }

    private boolean isSlotIndexInventory(int slotIndex) {
        return slotIndex >= this.slotIndexInventoryStart && slotIndex <= this.slotIndexInventoryEnd;
    }

    private boolean isSlotIndexHotbar(int slotIndex) {
        return slotIndex >= this.slotIndexHotbarStart && slotIndex <= this.slotIndexHotbarEnd;
    }

    private boolean isSlotIndexToolbox(int slotIndex) {
        return slotIndex >= this.slotIndexToolboxStart && slotIndex <= this.slotIndexToolboxEnd;
    }

    private boolean isSlotIndexTool(int slotIndex) {
        return slotIndex >= this.slotIndexToolsStart && slotIndex <= this.slotIndexToolsEnd;
    }

    private boolean mergeInventory(ItemStack itemStack, boolean reverse) {
        return this.func_75135_a(itemStack, this.slotIndexInventoryStart, this.slotIndexInventoryEnd + 1, reverse);
    }

    private boolean mergeHotbar(ItemStack itemStack, boolean reverse) {
        return this.func_75135_a(itemStack, this.slotIndexHotbarStart, this.slotIndexHotbarEnd + 1, reverse);
    }

    private boolean mergeCraftingMatrix(ItemStack itemStack, boolean reverse) {
        return this.func_75135_a(itemStack, this.slotIndexCraftingMatrixStart, this.slotIndexCraftingMatrixEnd + 1, reverse);
    }

    private boolean mergeBlankPattern(ItemStack itemStack, boolean reverse) {
        if (this.slotIndexPattern == -1) {
            return false;
        }
        return this.func_75135_a(itemStack, this.slotIndexPattern, this.slotIndexPattern + 1, reverse);
    }

    private boolean mergeToolbox(ItemStack itemStack, boolean reverse) {
        return this.func_75135_a(itemStack, this.slotIndexToolboxStart, this.slotIndexToolboxEnd + 1, reverse);
    }

    private boolean mergeSecondaryInput(ItemStack itemStack, boolean reverse) {
        if (this.slotIndexSecondaryInputStart == -1) {
            return false;
        }
        return this.func_75135_a(itemStack, this.slotIndexSecondaryInputStart, this.slotIndexSecondaryInputEnd + 1, reverse);
    }

    private boolean swapTools(int slotIndex) {
        int i;
        for (i = this.slotIndexToolsStart; i <= this.slotIndexToolsEnd; ++i) {
            if (!this.swapItemStack(slotIndex, i, true)) continue;
            return true;
        }
        for (i = this.slotIndexToolsStart; i <= this.slotIndexToolsEnd; ++i) {
            if (!this.swapItemStack(slotIndex, i, false)) continue;
            return true;
        }
        return false;
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int slotIndex) {
        ItemStack itemStackCopy = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemStack = slot.func_75211_c();
            itemStackCopy = itemStack.func_77946_l();
            if (this.isSlotIndexResult(slotIndex)) {
                IArtisanRecipe recipe = this.tile.getRecipe(playerIn);
                if (recipe == null) {
                    return ItemStack.field_190927_a;
                }
                if (recipe.hasMultipleWeightedOutputs()) {
                    return ItemStack.field_190927_a;
                }
                if (!this.mergeInventory(itemStack, false) && !this.mergeHotbar(itemStack, false)) {
                    return ItemStack.field_190927_a;
                }
                itemStack.func_77973_b().func_77622_d(itemStack, this.world, playerIn);
                slot.func_75220_a(itemStack, itemStackCopy);
            } else if (this.isSlotIndexInventory(slotIndex)) {
                if (this.swapTools(slotIndex)) {
                    return ItemStack.field_190927_a;
                }
                if (!(this.mergeBlankPattern(itemStack, false) || this.mergeCraftingMatrix(itemStack, false) || this.mergeSecondaryInput(itemStack, false) || this.mergeHotbar(itemStack, false))) {
                    return ItemStack.field_190927_a;
                }
            } else if (this.isSlotIndexHotbar(slotIndex)) {
                if (this.swapTools(slotIndex)) {
                    return ItemStack.field_190927_a;
                }
                if (!(this.mergeBlankPattern(itemStack, false) || this.mergeCraftingMatrix(itemStack, false) || this.mergeSecondaryInput(itemStack, false) || this.mergeInventory(itemStack, false))) {
                    return ItemStack.field_190927_a;
                }
            } else if (this.isSlotIndexToolbox(slotIndex)) {
                if (this.swapTools(slotIndex)) {
                    return ItemStack.field_190927_a;
                }
                if (!(this.mergeCraftingMatrix(itemStack, false) || this.mergeSecondaryInput(itemStack, false) || this.mergeInventory(itemStack, false) || this.mergeHotbar(itemStack, false))) {
                    return ItemStack.field_190927_a;
                }
            } else if (this.isSlotIndexTool(slotIndex) ? (this.canPlayerUseToolbox() ? !this.mergeToolbox(itemStack, false) && !this.mergeInventory(itemStack, false) && !this.mergeHotbar(itemStack, false) : !this.mergeInventory(itemStack, false) && !this.mergeHotbar(itemStack, false)) : !this.mergeInventory(itemStack, false) && !this.mergeHotbar(itemStack, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemStack.func_190916_E() == itemStackCopy.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            ItemStack itemStack2 = slot.func_190901_a(playerIn, itemStack);
            if (slotIndex == 0) {
                playerIn.func_71019_a(itemStack2, false);
            }
        }
        return itemStackCopy;
    }

    public List<Slot> getRecipeSlotsJEI(List<Slot> result) {
        int i;
        for (i = this.slotIndexCraftingMatrixStart; i <= this.slotIndexCraftingMatrixEnd; ++i) {
            result.add((Slot)this.field_75151_b.get(i));
        }
        for (i = this.slotIndexToolsStart; i <= this.slotIndexToolsEnd; ++i) {
            result.add((Slot)this.field_75151_b.get(i));
        }
        return result;
    }

    public List<Slot> getInventorySlotsJEI(List<Slot> result) {
        int i;
        for (i = this.slotIndexInventoryStart; i <= this.slotIndexInventoryEnd; ++i) {
            result.add((Slot)this.field_75151_b.get(i));
        }
        for (i = this.slotIndexHotbarStart; i <= this.slotIndexHotbarEnd; ++i) {
            result.add((Slot)this.field_75151_b.get(i));
        }
        if (this.canPlayerUseToolbox()) {
            for (i = this.slotIndexToolboxStart; i <= this.slotIndexToolboxEnd; ++i) {
                result.add((Slot)this.field_75151_b.get(i));
            }
        }
        for (i = this.slotIndexSecondaryInputStart; i < this.slotIndexSecondaryInputEnd; ++i) {
            result.add((Slot)this.field_75151_b.get(i));
        }
        return result;
    }

    public TileEntityBase getTile() {
        return this.tile;
    }

    public boolean canHandleRecipeTransferJEI(String name, EnumTier tier) {
        return this.tile.canHandleRecipeTransferJEI(name, tier);
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.tile == null || this.tile.func_145831_w().field_72995_K) {
            return;
        }
        FluidTank tank = this.tile.getTank();
        FluidStack fluidStack = tank.getFluid();
        if (this.lastFluidStack != null && fluidStack == null) {
            this.lastFluidStack = null;
            this.updateRecipeOutput();
        } else if (this.lastFluidStack == null && fluidStack != null) {
            this.lastFluidStack = fluidStack.copy();
            this.updateRecipeOutput();
        } else if (this.lastFluidStack != null && !this.lastFluidStack.isFluidStackIdentical(fluidStack)) {
            this.lastFluidStack = fluidStack.copy();
            this.updateRecipeOutput();
        }
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        this.tile.removeContainer(this);
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        IArtisanRecipe recipe;
        if (slotId == this.slotIndexResult && !player.field_71071_by.func_70445_o().func_190926_b() && (recipe = this.tile.getRecipe(player)) != null && recipe.hasMultipleWeightedOutputs()) {
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }
}

