/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.toolbox.tile;

import com.codetaylor.mc.artisanworktables.ReferenceTexture;
import com.codetaylor.mc.artisanworktables.api.ArtisanAPI;
import com.codetaylor.mc.artisanworktables.modules.toolbox.ModuleToolboxConfig;
import com.codetaylor.mc.artisanworktables.modules.toolbox.gui.ContainerToolbox;
import com.codetaylor.mc.artisanworktables.modules.toolbox.gui.GuiContainerToolbox;
import com.codetaylor.mc.artisanworktables.modules.toolbox.tile.ToolboxItemStackHandler;
import com.codetaylor.mc.athenaeum.gui.Texture;
import com.codetaylor.mc.athenaeum.tile.IContainer;
import com.codetaylor.mc.athenaeum.tile.IContainerProvider;
import com.codetaylor.mc.athenaeum.util.BlockHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityToolbox
extends TileEntity
implements IContainer,
IContainerProvider<ContainerToolbox, GuiContainerToolbox> {
    private ToolboxItemStackHandler itemHandler;

    public TileEntityToolbox() {
        Predicate<ItemStack> predicate = itemStack -> itemStack.func_190926_b() || !this.restrictToToolsOnly() || ArtisanAPI.containsRecipeWithTool(itemStack);
        this.itemHandler = new ToolboxItemStackHandler(predicate, 27){

            protected void validateSlotIndex(int slot) {
                super.validateSlotIndex(slot);
            }
        };
        this.itemHandler.addObserver((stackHandler, slotIndex) -> {
            this.func_70296_d();
            this.notifyBlockUpdate();
        });
    }

    protected boolean restrictToToolsOnly() {
        return ModuleToolboxConfig.TOOLBOX.RESTRICT_TO_TOOLS_ONLY;
    }

    public boolean canPlayerUse(EntityPlayer player) {
        return this.func_145831_w().func_175625_s(this.func_174877_v()) == this && player.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.itemHandler);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("itemHandler", (NBTBase)this.itemHandler.serializeNBT());
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.itemHandler.deserializeNBT(compound.func_74775_l("itemHandler"));
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager manager, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public final NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.func_145831_w().func_175625_s(this.func_174877_v()) == this && player.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public List<ItemStack> getBlockBreakDrops() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        int slotCount = this.itemHandler.getSlots();
        for (int i = 0; i < slotCount; ++i) {
            ItemStack itemStack = this.itemHandler.getStackInSlot(i);
            if (itemStack.func_190926_b()) continue;
            result.add(itemStack);
        }
        return result;
    }

    public void notifyBlockUpdate() {
        BlockHelper.notifyBlockUpdate((World)this.func_145831_w(), (BlockPos)this.func_174877_v());
    }

    protected String getGuiContainerTitleKey() {
        return "tile.artisanworktables.toolbox.name";
    }

    public ContainerToolbox getContainer(InventoryPlayer inventoryPlayer, World world, IBlockState state, BlockPos pos) {
        return new ContainerToolbox(inventoryPlayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainerToolbox getGuiContainer(InventoryPlayer inventoryPlayer, World world, IBlockState state, BlockPos pos) {
        return new GuiContainerToolbox(this.getContainer(inventoryPlayer, world, state, pos), this.getGuiContainerTitleKey(), this.getTexture());
    }

    public Texture getTexture() {
        return ReferenceTexture.TEXTURE_TOOLBOX;
    }

    public Texture getTextureSide() {
        return ReferenceTexture.TEXTURE_TOOLBOX_SIDE;
    }
}

