/*
 * Decompiled with CFR 0.152.
 */
package com.github.voxelfriend.rusticthaumaturgy.common.blocks.fluids;

import com.github.voxelfriend.rusticthaumaturgy.common.blocks.fluids.BlockFluidRT;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import rustic.common.blocks.fluids.FluidBooze;
import rustic.common.blocks.fluids.FluidDrinkable;
import thaumcraft.api.potions.PotionVisExhaust;
import thaumcraft.common.lib.potions.PotionBlurredVision;
import thaumcraft.common.lib.potions.PotionSunScorned;
import thaumcraft.common.lib.potions.PotionThaumarhia;
import thaumcraft.common.lib.potions.PotionWarpWard;

public class ModFluidsRT {
    public static Fluid CINDERFIRE_WORT;
    public static Fluid SHIMMERDEW_WORT;
    public static Fluid VISCOUS_WORT;
    public static Fluid CINDERFIRE_WHISKEY;
    public static Fluid SHIMMERDEW_SPIRITS;
    public static Fluid VISCOUS_BREW;
    private static List<Fluid> FLUIDS;
    public static BlockFluidRT BLOCK_CINDERFIRE_WORT;
    public static BlockFluidRT BLOCK_SHIMMERDEW_WORT;
    public static BlockFluidRT BLOCK_VISCOUS_WORT;
    public static BlockFluidRT BLOCK_CINDERFIRE_WHISKEY;
    public static BlockFluidRT BLOCK_SHIMMERDEW_SPIRITS;
    public static BlockFluidRT BLOCK_VISCOUS_BREW;

    public static void init() {
        CINDERFIRE_WORT = new FluidDrinkable("cinderfire_wort", new ResourceLocation("rusticthaumaturgy:blocks/fluids/cinderfire_wort_still"), new ResourceLocation("rusticthaumaturgy:blocks/fluids/cinderfire_wort_flow")){

            public void onDrank(World world, EntityPlayer player, ItemStack stack, FluidStack fluid) {
                player.func_71024_bL().func_75122_a(1, 2.0f);
                player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 400, 1));
            }
        }.setDensity(1004).setViscosity(2000);
        ModFluidsRT.register(CINDERFIRE_WORT);
        SHIMMERDEW_WORT = new FluidDrinkable("shimmerdew_wort", new ResourceLocation("rusticthaumaturgy:blocks/fluids/shimmerdew_wort_still"), new ResourceLocation("rusticthaumaturgy:blocks/fluids/shimmerdew_wort_flow")){

            public void onDrank(World world, EntityPlayer player, ItemStack stack, FluidStack fluid) {
                player.func_71024_bL().func_75122_a(1, 2.0f);
                player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 400, 1));
            }
        }.setDensity(1004).setViscosity(2000);
        ModFluidsRT.register(SHIMMERDEW_WORT);
        VISCOUS_WORT = new FluidDrinkable("viscous_wort", new ResourceLocation("rusticthaumaturgy:blocks/fluids/viscous_wort_still"), new ResourceLocation("rusticthaumaturgy:blocks/fluids/viscous_wort_flow")){

            public void onDrank(World world, EntityPlayer player, ItemStack stack, FluidStack fluid) {
                player.func_71024_bL().func_75122_a(1, 2.0f);
                player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 400, 1));
            }
        }.setDensity(1004).setViscosity(2000);
        ModFluidsRT.register(VISCOUS_WORT);
        CINDERFIRE_WHISKEY = new FluidBooze("cinderfire_whiskey", new ResourceLocation("rusticthaumaturgy:blocks/fluids/booze/cinderfire_whiskey_still"), new ResourceLocation("rusticthaumaturgy:blocks/fluids/booze/cinderfire_whiskey_flow")){

            protected void affectPlayer(World world, EntityPlayer player, float quality) {
                if (quality >= 0.5f) {
                    float saturation = 4.0f * quality;
                    player.func_71024_bL().func_75122_a(2, saturation);
                    int duration = (int)(12000.0f * Math.max(Math.abs((quality - 0.5f) * 2.0f), 0.0f));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, duration));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, duration));
                } else {
                    int duration = (int)(6000.0f * Math.max(1.0f - quality, 0.0f));
                    player.func_70690_d(new PotionEffect(PotionSunScorned.instance, duration));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76438_s, duration));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, duration));
                }
            }
        }.setInebriationChance(0.5f).setDensity(1004).setViscosity(1016);
        ModFluidsRT.register(CINDERFIRE_WHISKEY);
        SHIMMERDEW_SPIRITS = new FluidBooze("shimmerdew_spirits", new ResourceLocation("rusticthaumaturgy:blocks/fluids/booze/shimmerdew_spirits_still"), new ResourceLocation("rusticthaumaturgy:blocks/fluids/booze/shimmerdew_spirits_flow")){

            protected void affectPlayer(World world, EntityPlayer player, float quality) {
                if (quality >= 0.5f) {
                    float saturation = 4.0f * quality;
                    player.func_71024_bL().func_75122_a(2, saturation);
                    int duration = (int)(12000.0f * Math.max(Math.abs((quality - 0.5f) * 2.0f), 0.0f));
                    player.func_70690_d(new PotionEffect(PotionWarpWard.instance, duration));
                    player.func_70690_d(new PotionEffect(MobEffects.field_188425_z, duration));
                } else {
                    int duration = (int)(6000.0f * Math.max(1.0f - quality, 0.0f));
                    player.func_70690_d(new PotionEffect(PotionThaumarhia.instance, duration));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76438_s, duration));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, duration));
                }
            }
        }.setInebriationChance(0.5f).setDensity(1004).setViscosity(1016);
        ModFluidsRT.register(SHIMMERDEW_SPIRITS);
        VISCOUS_BREW = new FluidBooze("viscous_brew", new ResourceLocation("rusticthaumaturgy:blocks/fluids/booze/viscous_brew_still"), new ResourceLocation("rusticthaumaturgy:blocks/fluids/booze/viscous_brew_flow")){

            protected void affectPlayer(World world, EntityPlayer player, float quality) {
                if (quality >= 0.5f) {
                    float saturation = 4.0f * quality;
                    player.func_71024_bL().func_75122_a(2, saturation);
                    int duration = (int)(12000.0f * Math.max(Math.abs((quality - 0.5f) * 2.0f), 0.0f));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, duration));
                    player.func_70690_d(new PotionEffect(PotionBlurredVision.instance, duration));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76422_e, duration));
                } else {
                    int duration = (int)(6000.0f * Math.max(1.0f - quality, 0.0f));
                    player.func_70690_d(new PotionEffect(PotionVisExhaust.instance, duration));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76438_s, duration));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, duration));
                }
            }
        }.setInebriationChance(0.5f).setDensity(1004).setViscosity(1016);
        ModFluidsRT.register(VISCOUS_BREW);
        BLOCK_CINDERFIRE_WORT = new BlockFluidRT("cinderfire_wort", CINDERFIRE_WORT, Material.field_151586_h);
        BLOCK_CINDERFIRE_WORT.setQuantaPerBlock(4);
        BLOCK_SHIMMERDEW_WORT = new BlockFluidRT("shimmerdew_wort", SHIMMERDEW_WORT, Material.field_151586_h);
        BLOCK_SHIMMERDEW_WORT.setQuantaPerBlock(4);
        BLOCK_VISCOUS_WORT = new BlockFluidRT("viscous_wort", VISCOUS_WORT, Material.field_151586_h);
        BLOCK_VISCOUS_WORT.setQuantaPerBlock(4);
        BLOCK_CINDERFIRE_WHISKEY = new BlockFluidRT("cinderfire_whiskey", CINDERFIRE_WHISKEY, Material.field_151586_h);
        BLOCK_CINDERFIRE_WHISKEY.setQuantaPerBlock(4);
        BLOCK_SHIMMERDEW_SPIRITS = new BlockFluidRT("shimmerdew_spirits", SHIMMERDEW_SPIRITS, Material.field_151586_h);
        BLOCK_SHIMMERDEW_SPIRITS.setQuantaPerBlock(4);
        BLOCK_VISCOUS_BREW = new BlockFluidRT("viscous_brew", VISCOUS_BREW, Material.field_151586_h);
        BLOCK_VISCOUS_BREW.setQuantaPerBlock(4);
    }

    public static void initModels() {
        BLOCK_CINDERFIRE_WORT.initModel();
        BLOCK_SHIMMERDEW_WORT.initModel();
        BLOCK_VISCOUS_WORT.initModel();
        BLOCK_CINDERFIRE_WHISKEY.initModel();
        BLOCK_SHIMMERDEW_SPIRITS.initModel();
        BLOCK_VISCOUS_BREW.initModel();
    }

    private static void register(Fluid fluid) {
        if (!FluidRegistry.registerFluid((Fluid)fluid)) {
            fluid = FluidRegistry.getFluid((String)fluid.getName());
        }
        FluidRegistry.addBucketForFluid((Fluid)fluid);
        FLUIDS.add(fluid);
    }

    public static ArrayList<Fluid> getFluids() {
        return new ArrayList<Fluid>(FLUIDS);
    }

    static {
        FLUIDS = new ArrayList<Fluid>();
    }
}

