/*
 * Decompiled with CFR 0.152.
 */
package shadows.plants2.compat;

import de.ellpeck.actuallyadditions.api.farmer.FarmerResult;
import de.ellpeck.actuallyadditions.api.farmer.IFarmerBehavior;
import de.ellpeck.actuallyadditions.api.internal.IFarmer;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import shadows.placebo.interfaces.ISpecialPlacement;
import shadows.placebo.util.StackPrimer;
import shadows.plants2.block.BlockEnumDoubleHarvestBush;
import shadows.plants2.block.BlockEnumHarvestBush;

public class HarvestBushFarmerBehavior
implements IFarmerBehavior {
    boolean plant(World world, BlockPos pos, IBlockState state, IFarmer farmer) {
        if (this.tryPlant(state, world, pos)) {
            farmer.extractEnergy(700);
            return true;
        }
        return false;
    }

    boolean tryPlant(IBlockState state, World world, BlockPos pos) {
        if (state.func_177230_c().func_176196_c(world, pos)) {
            return ((ISpecialPlacement)state.func_177230_c()).placeStateAt(state, world, pos);
        }
        return false;
    }

    public FarmerResult tryPlantSeed(ItemStack seed, World world, BlockPos pos, IFarmer farmer) {
        Block b;
        if (farmer.getEnergy() >= 700 && (b = Block.func_149634_a((Item)seed.func_77973_b())) instanceof BlockEnumHarvestBush && this.plant(world, pos, b.getStateForPlacement(world, pos, null, 0.0f, 0.0f, 0.0f, seed.func_77960_j(), null, null), farmer)) {
            return FarmerResult.SUCCESS;
        }
        return FarmerResult.FAIL;
    }

    public FarmerResult tryHarvestPlant(World world, BlockPos pos, IFarmer farmer) {
        IBlockState state;
        Block block;
        int use = 250;
        if (farmer.getEnergy() >= use && (block = (state = world.func_180495_p(pos)).func_177230_c()) instanceof BlockEnumHarvestBush && ((Boolean)state.func_177229_b((IProperty)BlockEnumHarvestBush.FRUIT)).booleanValue()) {
            return this.harvest(world, pos, farmer, (BlockEnumHarvestBush)block, state);
        }
        return FarmerResult.FAIL;
    }

    private FarmerResult harvest(World world, BlockPos pos, IFarmer farmer, BlockEnumHarvestBush<?> bush, IBlockState state) {
        StackPrimer[] primes;
        NonNullList drops = NonNullList.func_191196_a();
        for (StackPrimer p : primes = bush.getFruit(state)) {
            drops.add((Object)p.genStack());
        }
        if (farmer.canAddToOutput((List)drops)) {
            farmer.addToOutput((List)drops);
            world.func_175656_a(pos, state.func_177226_a((IProperty)BlockEnumHarvestBush.FRUIT, (Comparable)Boolean.valueOf(false)));
            if (this.isDouble((Block)bush)) {
                world.func_175656_a(pos.func_177984_a(), world.func_180495_p(pos.func_177984_a()).func_177226_a((IProperty)BlockEnumHarvestBush.FRUIT, (Comparable)Boolean.valueOf(false)));
            }
            farmer.extractEnergy(250);
            return FarmerResult.SUCCESS;
        }
        return FarmerResult.FAIL;
    }

    public int getPriority() {
        return 3;
    }

    boolean isDouble(Block b) {
        return b instanceof BlockEnumDoubleHarvestBush;
    }
}

