/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.world;

import java.util.ArrayList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import yuudaari.soulus.common.block.summoner.Summoner;
import yuudaari.soulus.common.block.summoner.SummonerTileEntity;
import yuudaari.soulus.common.config.ConfigInjected;
import yuudaari.soulus.common.config.world.summoner_replacement.ConfigReplacement;
import yuudaari.soulus.common.config.world.summoner_replacement.ConfigStructure;
import yuudaari.soulus.common.config.world.summoner_replacement.ConfigSummonerReplacement;
import yuudaari.soulus.common.registration.BlockRegistry;
import yuudaari.soulus.common.util.GeneratorName;
import yuudaari.soulus.common.util.Logger;

@Mod.EventBusSubscriber
@ConfigInjected(value="soulus")
public class SummonerReplacer {
    @ConfigInjected.Inject
    public static ConfigSummonerReplacement CONFIG;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void populateChunkPost(PopulateChunkEvent.Post event) {
        World world = event.getWorld();
        Chunk chunk = world.func_72964_e(event.getChunkX(), event.getChunkZ());
        IChunkGenerator cg = event.getGenerator();
        Map teMap = chunk.func_177434_r();
        ConfigStructure defaultStructureConfig = SummonerReplacer.CONFIG.structures.get("*");
        if (defaultStructureConfig == null) {
            return;
        }
        for (TileEntity te : new ArrayList(teMap.values())) {
            Block block = te.func_145838_q();
            if (block != Blocks.field_150474_ac) continue;
            BlockPos pos = te.func_174877_v();
            ConfigStructure structureConfig = defaultStructureConfig;
            for (Map.Entry<String, ConfigStructure> structureConfigEntry : SummonerReplacer.CONFIG.structures.entrySet()) {
                if (!cg.func_193414_a(world, GeneratorName.get(structureConfigEntry.getKey()), pos)) continue;
                structureConfig = structureConfigEntry.getValue();
            }
            String entityType = SummonerReplacer.getTheIdFromAStupidMobSpawnerTileEntity(te);
            ConfigReplacement replacement = structureConfig.replacementsByCreature.get(entityType);
            if (replacement == null && (replacement = structureConfig.replacementsByCreature.get(new ResourceLocation(entityType).func_110624_b() + ":*")) == null && (replacement = structureConfig.replacementsByCreature.get("*")) == null) {
                return;
            }
            world.func_180501_a(pos, BlockRegistry.SUMMONER.func_176223_P().func_177226_a(Summoner.VARIANT, (Comparable)((Object)replacement.type)).func_177226_a((IProperty)Summoner.HAS_SOULBOOK, (Comparable)Boolean.valueOf(replacement.midnightJewel)), 7);
            if (!replacement.midnightJewel) {
                return;
            }
            TileEntity nte = world.func_175625_s(pos);
            if (nte == null || !(nte instanceof SummonerTileEntity)) {
                Logger.warn("Unable to insert midnight jewel into replaced summoner");
                return;
            }
            SummonerTileEntity ste = (SummonerTileEntity)nte;
            ste.setEssenceType(entityType);
            ste.upgrades.put(Summoner.Upgrade.CRYSTAL_DARK, 1);
        }
    }

    public static String getTheIdFromAStupidMobSpawnerTileEntity(TileEntity te) {
        if (!(te instanceof TileEntityMobSpawner)) {
            return null;
        }
        TileEntityMobSpawner mste = (TileEntityMobSpawner)te;
        NBTTagCompound nbt = new NBTTagCompound();
        mste.func_189515_b(nbt);
        NBTTagList taglist = nbt.func_150295_c("SpawnPotentials", 10);
        NBTBase firstSpawnPotential = taglist.func_179238_g(0);
        if (!(firstSpawnPotential instanceof NBTTagCompound)) {
            return null;
        }
        NBTTagCompound firstSpawnPotentialTheRealOne = (NBTTagCompound)firstSpawnPotential;
        NBTTagCompound theActualEntityOhMyGod = firstSpawnPotentialTheRealOne.func_74775_l("Entity");
        return theActualEntityOhMyGod.func_74779_i("id");
    }
}

