/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.misc;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import scala.Tuple2;
import yuudaari.soulus.common.config.ConfigInjected;
import yuudaari.soulus.common.config.bones.ConfigBoneType;
import yuudaari.soulus.common.config.bones.ConfigBoneTypes;
import yuudaari.soulus.common.config.essence.ConfigEssence;
import yuudaari.soulus.common.config.essence.ConfigEssences;
import yuudaari.soulus.common.config.item.ConfigBoneChunks;
import yuudaari.soulus.common.config.misc.ConfigFossils;
import yuudaari.soulus.common.item.Essence;
import yuudaari.soulus.common.util.Range;

@Mod.EventBusSubscriber
@ConfigInjected(value="soulus")
public class BoneChunks {
    @ConfigInjected.Inject
    public static ConfigBoneTypes CONFIG_BONE_TYPES;
    @ConfigInjected.Inject
    public static ConfigBoneChunks CONFIG;
    @ConfigInjected.Inject
    public static ConfigFossils CONFIG_FOSSILS;
    @ConfigInjected.Inject
    public static ConfigEssences CONFIG_ESSENCES;
    private static Map<String, Tuple2<Double, Map<String, Double>>> drops;

    public static double getChanceTotal(String boneType) {
        Tuple2<Double, Map<String, Double>> dropTuple = drops.get(boneType.toLowerCase());
        return dropTuple == null ? 0.0 : (Double)dropTuple._1;
    }

    public static void registerEssenceDrops(FMLStateEvent e) {
        for (ConfigBoneType boneType : BoneChunks.CONFIG_BONE_TYPES.boneTypes) {
            double chanceTotal = 0.0;
            HashMap<String, Double> drops = new HashMap<String, Double>();
            for (ConfigEssence essenceConfig : BoneChunks.CONFIG_ESSENCES.essences) {
                if (essenceConfig.bones == null || !essenceConfig.bones.type.equalsIgnoreCase(boneType.name)) continue;
                if (essenceConfig.essence.equals("NONE")) {
                    drops.put(null, essenceConfig.bones.dropWeight);
                    continue;
                }
                if (ForgeRegistries.ENTITIES.containsKey(new ResourceLocation(essenceConfig.essence))) {
                    drops.put(essenceConfig.essence, essenceConfig.bones.dropWeight);
                    continue;
                }
                System.out.println(String.format("Colour entry missing for %s:%s", boneType, essenceConfig.essence));
            }
            Iterator<ConfigEssence> iterator = drops.values().iterator();
            while (iterator.hasNext()) {
                double dropChance = (Double)((Object)iterator.next());
                chanceTotal += dropChance;
            }
            BoneChunks.drops.put(boneType.name.toLowerCase(), (Tuple2<Double, Map<String, Double>>)new Tuple2((Object)chanceTotal, drops));
        }
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickItem event) {
        ItemStack heldItem = event.getItemStack();
        String itemName = heldItem.func_77973_b().getRegistryName().toString();
        for (ConfigBoneType boneType : BoneChunks.CONFIG_BONE_TYPES.boneTypes) {
            int count;
            if (!boneType.item_chunk.equalsIgnoreCase(itemName)) continue;
            World world = event.getWorld();
            EntityPlayer player = event.getEntityPlayer();
            BoneChunks.particles(world, player, heldItem.func_77973_b());
            int n = count = player.func_70093_af() && BoneChunks.CONFIG.sneakToMarrowFullStack ? heldItem.func_190916_E() : 1;
            if (!world.field_72995_K) {
                Collection<ItemStack> drops = BoneChunks.getDrops(world.field_73012_v, boneType.name, count);
                for (ItemStack drop : drops) {
                    EntityItem dropEntity = new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, drop);
                    dropEntity.func_174868_q();
                    world.func_72838_d((Entity)dropEntity);
                }
            }
            heldItem.func_190918_g(count);
        }
    }

    @SubscribeEvent
    public static void onHarvest(BlockEvent.HarvestDropsEvent event) {
        String blockId;
        ConfigFossils.ConfigFossil fossilConfig;
        if (event.getHarvester() != null && (fossilConfig = CONFIG_FOSSILS.get(blockId = event.getState().func_177230_c().getRegistryName().toString())) != null) {
            List drops = event.getDrops();
            drops.clear();
            int count = new Range(fossilConfig.min * (1 + event.getFortuneLevel() / 3), fossilConfig.max * (1 + event.getFortuneLevel() / 3)).getInt(event.getWorld().field_73012_v);
            drops.add(CONFIG_BONE_TYPES.get(fossilConfig.type).getChunkStack(count));
        }
    }

    private static Collection<ItemStack> getDrops(Random rand, String boneType, int count) {
        HashMap result = new HashMap();
        Tuple2<Double, Map<String, Double>> dropMap = drops.get(boneType.toLowerCase());
        double chanceTotal = (Double)dropMap._1;
        Map drops = (Map)dropMap._2;
        for (int i = 0; i < count; ++i) {
            for (Map.Entry dropInfo : drops.entrySet()) {
                if (dropInfo.getKey() == null || (double)rand.nextFloat() >= (Double)dropInfo.getValue() / chanceTotal) continue;
                ItemStack stack = (ItemStack)result.get(dropInfo.getKey());
                if (stack == null) {
                    stack = Essence.getStack((String)dropInfo.getKey());
                    result.put(dropInfo.getKey(), stack);
                    continue;
                }
                stack.func_190917_f(1);
            }
        }
        return result.values();
    }

    private static void particles(World world, EntityPlayer player, Item item) {
        for (int i = 0; i < BoneChunks.CONFIG.particleCount; ++i) {
            Vec3d v = new Vec3d(((double)world.field_73012_v.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            v = v.func_178789_a(-player.field_70125_A * ((float)Math.PI / 180));
            v = v.func_178785_b(-player.field_70177_z * ((float)Math.PI / 180));
            double d0 = (double)(-world.field_73012_v.nextFloat()) * 0.6 - 0.3;
            Vec3d v2 = new Vec3d(((double)world.field_73012_v.nextFloat() - 0.5) * 0.3, d0, 0.6);
            v2 = v2.func_178789_a(-player.field_70125_A * ((float)Math.PI / 180));
            v2 = v2.func_178785_b(-player.field_70177_z * ((float)Math.PI / 180));
            v2 = v2.func_72441_c(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
            world.func_175688_a(EnumParticleTypes.ITEM_CRACK, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, v.field_72450_a, v.field_72448_b + 0.05, v.field_72449_c, new int[]{Item.func_150891_b((Item)item)});
        }
        player.func_184185_a(SoundEvents.field_187585_bY, 0.5f + 0.5f * (float)world.field_73012_v.nextInt(2), (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f + 1.0f);
    }

    static {
        drops = new HashMap<String, Tuple2<Double, Map<String, Double>>>();
    }
}

