/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import yuudaari.soulus.common.block.composer.ComposerCell;
import yuudaari.soulus.common.block.composer.IFillableWithEssence;
import yuudaari.soulus.common.config.ConfigInjected;
import yuudaari.soulus.common.config.item.ConfigSoulCatalyst;
import yuudaari.soulus.common.item.OrbMurky;
import yuudaari.soulus.common.recipe.ingredient.IngredientPotentialEssence;
import yuudaari.soulus.common.registration.ItemRegistry;
import yuudaari.soulus.common.registration.Registration;
import yuudaari.soulus.common.util.Colour;
import yuudaari.soulus.common.util.Translation;

@ConfigInjected(value="soulus")
public class SoulCatalyst
extends Registration.Item
implements ComposerCell.IHasComposerCellInfo,
IFillableWithEssence {
    @ConfigInjected.Inject
    public static ConfigSoulCatalyst CONFIG;
    private static final int colourEmpty = 0x222222;
    private static final int colourFilled = 0xFFFFFF;

    public SoulCatalyst() {
        super("soul_catalyst");
        this.setHasDescription();
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.registerColorHandler((stack, tintIndex) -> {
                float percentage = (float)SoulCatalyst.getContainedEssence(stack) / (float)SoulCatalyst.CONFIG.requiredEssence;
                return Colour.mix(0x222222, 0xFFFFFF, (double)percentage).get();
            });
        }
    }

    @Override
    public void onRegisterRecipes(IForgeRegistry<IRecipe> registry) {
        registry.registerAll((IForgeRegistryEntry[])new IRecipe[]{new SoulCatalystFillRecipe(this.getRegistryName(), 2), new SoulCatalystFillRecipe(this.getRegistryName(), 3)});
    }

    public int getItemStackLimit(ItemStack stack) {
        return SoulCatalyst.getContainedEssence(stack) == SoulCatalyst.CONFIG.requiredEssence ? SoulCatalyst.CONFIG.stackSize : 1;
    }

    public ItemStack getFilledStack() {
        return this.getStack(SoulCatalyst.CONFIG.requiredEssence);
    }

    public ItemStack getStack(int essence) {
        ItemStack stack = new ItemStack((Item)this);
        SoulCatalyst.setContainedEssence(stack, essence);
        return stack;
    }

    @Override
    public ItemStack getItemStack() {
        return this.getStack(0);
    }

    @Override
    public int fill(ItemStack currentStack, ItemStack fillWith, int quantity) {
        int currentEssence = SoulCatalyst.getContainedEssence(currentStack);
        int insertQuantity = Math.max(0, Math.min(quantity, SoulCatalyst.CONFIG.requiredEssence - currentEssence));
        if (insertQuantity > 0) {
            SoulCatalyst.setContainedEssence(currentStack, currentEssence + insertQuantity);
        }
        return insertQuantity;
    }

    @Override
    public float getFillPercentage(ItemStack stack) {
        return (float)SoulCatalyst.getContainedEssence(stack) / (float)SoulCatalyst.CONFIG.requiredEssence;
    }

    @Override
    public boolean func_77636_d(ItemStack stack) {
        return SoulCatalyst.getContainedEssence(stack) == SoulCatalyst.CONFIG.requiredEssence;
    }

    @Nonnull
    public String func_77657_g(@Nonnull ItemStack stack) {
        String result = super.func_77657_g(stack);
        int containedEssence = SoulCatalyst.getContainedEssence(stack);
        return containedEssence == SoulCatalyst.CONFIG.requiredEssence ? result + ".filled" : result;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        int containedEssence = SoulCatalyst.getContainedEssence(stack);
        return containedEssence < SoulCatalyst.CONFIG.requiredEssence;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        int containedEssence = SoulCatalyst.getContainedEssence(stack);
        return 1.0 - (double)containedEssence / (double)SoulCatalyst.CONFIG.requiredEssence;
    }

    public static int getContainedEssence(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_150297_b("essence_quantity", 3)) {
            return tag.func_74762_e("essence_quantity");
        }
        return 0;
    }

    public static boolean isFilled(ItemStack stack) {
        return SoulCatalyst.getContainedEssence(stack) >= SoulCatalyst.CONFIG.requiredEssence;
    }

    public static ItemStack setContainedEssence(ItemStack stack, int count) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        tag.func_74768_a("essence_quantity", count);
        return stack;
    }

    public static ItemStack setFilled(ItemStack stack) {
        return SoulCatalyst.setContainedEssence(stack, SoulCatalyst.CONFIG.requiredEssence);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)this.getItemStack());
            items.add((Object)this.getFilledStack());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        this.addImportantInformation(tooltip, stack);
    }

    public void addImportantInformation(List<String> tooltip, ItemStack stack) {
        int containedEssence = OrbMurky.getContainedEssence(stack);
        if (containedEssence < SoulCatalyst.CONFIG.requiredEssence) {
            tooltip.add(new Translation("tooltip.soulus:soul_catalyst.contained_essence", new Object[0]).addArgs(containedEssence, SoulCatalyst.CONFIG.requiredEssence).get(new Object[0]));
        }
    }

    @Override
    public void addComposerCellInfo(List<String> tooltip, ItemStack stack, int stackSize) {
        if (stackSize == 1) {
            this.addImportantInformation(tooltip, stack);
        }
    }

    public static class SoulCatalystFillRecipe
    extends ShapelessOreRecipe {
        public static NonNullList<Ingredient> getIngredients(int size) {
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
            ingredients.addAll(Collections.nCopies(size * size - 1, IngredientPotentialEssence.getInstance()));
            ingredients.add(Ingredient.func_193367_a((Item)ItemRegistry.SOUL_CATALYST));
            return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])ingredients.toArray(new Ingredient[0]));
        }

        public SoulCatalystFillRecipe(ResourceLocation name, int size) {
            super(new ResourceLocation(""), SoulCatalystFillRecipe.getIngredients(size), ItemRegistry.SOUL_CATALYST.getFilledStack());
            this.setRegistryName(name + "" + size);
        }

        @ParametersAreNonnullByDefault
        public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
            return !this.func_77572_b(inv).func_190926_b();
        }

        @ParametersAreNonnullByDefault
        public ItemStack func_77572_b(InventoryCrafting inv) {
            int essenceCount = 0;
            ItemStack catalyst = null;
            int containedEssence = 0;
            int inventorySize = inv.func_70302_i_();
            for (int i = 0; i < inventorySize; ++i) {
                ItemStack stack = inv.func_70301_a(i);
                Item stackItem = stack.func_77973_b();
                if (stack == null || stack.func_190926_b()) continue;
                if (stackItem == ItemRegistry.SOUL_CATALYST) {
                    if (catalyst != null) {
                        return ItemStack.field_190927_a;
                    }
                    containedEssence = SoulCatalyst.getContainedEssence(stack);
                    catalyst = stack;
                    continue;
                }
                if (stackItem == ItemRegistry.ESSENCE || stackItem == ItemRegistry.ASH) {
                    ++essenceCount;
                    continue;
                }
                return ItemStack.field_190927_a;
            }
            if (catalyst != null && essenceCount > 0 && containedEssence + essenceCount <= SoulCatalyst.CONFIG.requiredEssence) {
                ItemStack newStack = catalyst.func_77946_l();
                SoulCatalyst.setContainedEssence(newStack, containedEssence + essenceCount);
                return newStack;
            }
            return ItemStack.field_190927_a;
        }
    }
}

