/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.config.essence;

import java.util.ArrayList;
import java.util.List;
import yuudaari.soulus.common.config.ConfigFile;
import yuudaari.soulus.common.config.essence.ConfigCreatureBone;
import yuudaari.soulus.common.config.essence.ConfigEssence;
import yuudaari.soulus.common.util.serializer.CollectionSerializer;
import yuudaari.soulus.common.util.serializer.Serializable;
import yuudaari.soulus.common.util.serializer.Serialized;

@ConfigFile(file="essences/essences", id="soulus")
@Serializable
public class ConfigEssences {
    @Serialized(value=EssencesSerializer.class)
    public List<ConfigEssence> essences = new ArrayList<ConfigEssence>();

    public ConfigEssences() {
        this.essences.add(new ConfigEssence("minecraft:bat", new ConfigCreatureBone("NORMAL", 1.0)).addLoot(1, 1, 0.1));
        this.essences.add(new ConfigEssence("minecraft:chicken", new ConfigCreatureBone("NORMAL", 8.0)).addLoot(1, 1, 0.2));
        this.essences.add(new ConfigEssence("minecraft:cow", new ConfigCreatureBone("NORMAL", 8.0)).addLoot(1, 2, 0.4));
        this.essences.add(new ConfigEssence("minecraft:pig", new ConfigCreatureBone("NORMAL", 6.0)).addLoot(1, 2, 0.3));
        this.essences.add(new ConfigEssence("minecraft:rabbit", new ConfigCreatureBone("NORMAL", 4.0)).addLoot(1, 1, 0.1));
        this.essences.add(new ConfigEssence("minecraft:sheep", new ConfigCreatureBone("NORMAL", 6.0)).addLoot(1, 2, 0.4));
        this.essences.add(new ConfigEssence("minecraft:skeleton", new ConfigCreatureBone("NORMAL", 3.0)).addLoot(1, 2, 0.7));
        this.essences.add(new ConfigEssence("minecraft:spider", new ConfigCreatureBone("NORMAL", 5.0)));
        this.essences.add(new ConfigEssence("minecraft:villager", new ConfigCreatureBone("NORMAL", 1.0)).addLoot(1, 2, 0.6));
        this.essences.add(new ConfigEssence("NONE", new ConfigCreatureBone("NORMAL", 5.0)));
        this.essences.add(new ConfigEssence("minecraft:cave_spider", new ConfigCreatureBone("DRY", 1.0)));
        this.essences.add(new ConfigEssence("minecraft:horse", new ConfigCreatureBone("DRY", 1.0)).addLoot(1, 3, 0.6));
        this.essences.add(new ConfigEssence("minecraft:husk", new ConfigCreatureBone("DRY", 5.0)).addLoot(1, 2, 0.3));
        this.essences.add(new ConfigEssence("minecraft:llama", new ConfigCreatureBone("DRY", 10.0)).addLoot(1, 3, 0.5));
        this.essences.add(new ConfigEssence("NONE", new ConfigCreatureBone("DRY", 30.0)));
        this.essences.add(new ConfigEssence("minecraft:mooshroom", new ConfigCreatureBone("FUNGAL", 1.0)).addLoot(1, 3, 0.6));
        this.essences.add(new ConfigEssence("minecraft:ocelot", new ConfigCreatureBone("FUNGAL", 10.0)).addLoot(1, 1, 0.3));
        this.essences.add(new ConfigEssence("minecraft:parrot", new ConfigCreatureBone("FUNGAL", 10.0)).addLoot(1, 1, 0.2));
        this.essences.add(new ConfigEssence("minecraft:vindication_illager", new ConfigCreatureBone("FUNGAL", 5.0)).addSpawnChance("minecraft:vindication_illager", 10.0).addSpawnChance("minecraft:evocation_illager", 1.0).addLoot("minecraft:vindication_illager", 1, 2, 0.6).addLoot("minecraft:evocation_illager", 1, 2, 0.6));
        this.essences.add(new ConfigEssence("minecraft:witch", new ConfigCreatureBone("FUNGAL", 5.0)).addLoot(1, 2, 0.6));
        this.essences.add(new ConfigEssence("minecraft:zombie", new ConfigCreatureBone("FUNGAL", 20.0)).addSpawnChance("minecraft:zombie", 100.0).addSpawnChance("minecraft:zombie_villager", 10.0).addSpawnChance("minecraft:zombie_horse", 1.0).addLoot("minecraft:zombie", 1, 2, 0.3).addLoot("minecraft:zombie_villager", 1, 2, 0.5).addLoot("minecraft:zombie_horse", 1, 3, 0.6));
        this.essences.add(new ConfigEssence("NONE", new ConfigCreatureBone("FUNGAL", 20.0)));
        this.essences.add(new ConfigEssence("minecraft:snowman", new ConfigCreatureBone("FROZEN", 1.0)).setColor(0xFFFFFF, 14913565));
        this.essences.add(new ConfigEssence("minecraft:stray", new ConfigCreatureBone("FROZEN", 1.0)).addLoot(1, 2, 0.5));
        this.essences.add(new ConfigEssence("minecraft:wolf", new ConfigCreatureBone("FROZEN", 5.0)).addLoot(1, 1, 0.2));
        this.essences.add(new ConfigEssence("minecraft:polar_bear", new ConfigCreatureBone("FROZEN", 10.0)).addLoot(1, 3, 0.6));
        this.essences.add(new ConfigEssence("NONE", new ConfigCreatureBone("FROZEN", 10.0)));
        this.essences.add(new ConfigEssence("minecraft:silverfish", new ConfigCreatureBone("SCALE", 1.0)).addLoot(1, 1, 0.2));
        this.essences.add(new ConfigEssence("minecraft:squid", new ConfigCreatureBone("SCALE", 20.0)).addLoot(1, 1, 0.2));
        this.essences.add(new ConfigEssence("minecraft:guardian", new ConfigCreatureBone("SCALE", 1.0)).addLoot(1, 3, 0.8));
        this.essences.add(new ConfigEssence("NONE", new ConfigCreatureBone("SCALE", 10.0)));
        this.essences.add(new ConfigEssence("minecraft:zombie_pigman", new ConfigCreatureBone("NETHER", 20.0)).addLoot(1, 2, 0.5));
        this.essences.add(new ConfigEssence("minecraft:blaze", new ConfigCreatureBone("NETHER", 3.0)).addLoot(1, 2, 0.6));
        this.essences.add(new ConfigEssence("minecraft:wither_skeleton", new ConfigCreatureBone("NETHER", 1.0)).addLoot(1, 2, 0.7));
        this.essences.add(new ConfigEssence("minecraft:ghast", new ConfigCreatureBone("NETHER", 1.0)).addLoot(3, 6, 1.0));
        this.essences.add(new ConfigEssence("NONE", new ConfigCreatureBone("NETHER", 10.0)));
        this.essences.add(new ConfigEssence("minecraft:shulker", new ConfigCreatureBone("ENDER", 1.0)));
        this.essences.add(new ConfigEssence("minecraft:endermite", new ConfigCreatureBone("ENDER", 15.0)).addLoot(1, 1, 0.1));
        this.essences.add(new ConfigEssence("minecraft:creeper", new ConfigCreatureBone("ENDER", 10.0)).addLoot(1, 2, 0.4));
        this.essences.add(new ConfigEssence("minecraft:enderman", new ConfigCreatureBone("ENDER", 2.0)).addLoot(1, 4, 0.8));
        this.essences.add(new ConfigEssence("NONE", new ConfigCreatureBone("ENDER", 20.0)));
        this.essences.add(new ConfigEssence("minecraft:slime", null));
        this.essences.add(new ConfigEssence("minecraft:villager_golem", null).setColor(13749192, 6984011));
        this.essences.add(new ConfigEssence("minecraft:magma_cube", null));
    }

    public ConfigEssence get(String type) {
        return this.essences.stream().filter(config -> config.essence.equalsIgnoreCase(type)).findFirst().orElse(null);
    }

    public int getSoulbookQuantity(String essenceType) {
        ConfigEssence config = this.get(essenceType);
        return config != null ? config.soulbookQuantity : (essenceType == "unfocused" ? 1 : -1);
    }

    public static class EssencesSerializer
    extends CollectionSerializer<ConfigEssence> {
        @Override
        public Class<ConfigEssence> getValueClass() {
            return ConfigEssence.class;
        }
    }
}

