/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.config.bones;

import java.util.ArrayList;
import java.util.List;
import yuudaari.soulus.common.config.ConfigFile;
import yuudaari.soulus.common.config.bones.ConfigBoneType;
import yuudaari.soulus.common.util.serializer.CollectionSerializer;
import yuudaari.soulus.common.util.serializer.Serializable;
import yuudaari.soulus.common.util.serializer.Serialized;

@ConfigFile(file="bones/bone_types", id="soulus")
@Serializable
public class ConfigBoneTypes {
    @Serialized(value=BoneTypesSerializer.class)
    public List<ConfigBoneType> boneTypes = new ArrayList<ConfigBoneType>();

    public ConfigBoneTypes() {
        this.boneTypes.add(new ConfigBoneType("normal", "soulus:bone_normal", "soulus:bone_chunk_normal"));
        this.boneTypes.add(new ConfigBoneType("dry", "soulus:bone_dry", "soulus:bone_chunk_dry"));
        this.boneTypes.add(new ConfigBoneType("fungal", "soulus:bone_fungal", "soulus:bone_chunk_fungal"));
        this.boneTypes.add(new ConfigBoneType("frozen", "soulus:bone_frozen", "soulus:bone_chunk_frozen"));
        this.boneTypes.add(new ConfigBoneType("scale", "soulus:bone_scale", "soulus:bone_chunk_scale"));
        this.boneTypes.add(new ConfigBoneType("nether", "soulus:bone_nether", "soulus:bone_chunk_nether"));
        this.boneTypes.add(new ConfigBoneType("ender", "soulus:bone_ender", "soulus:bone_chunk_ender"));
    }

    public ConfigBoneType get(String type) {
        return this.boneTypes.stream().filter(config -> config.name.equalsIgnoreCase(type)).findFirst().orElse(null);
    }

    public static class BoneTypesSerializer
    extends CollectionSerializer<ConfigBoneType> {
        @Override
        public Class<ConfigBoneType> getValueClass() {
            return ConfigBoneType.class;
        }
    }
}

