/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.config;

import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.stream.Collectors;
import yuudaari.soulus.Soulus;
import yuudaari.soulus.common.compat.GameStages;
import yuudaari.soulus.common.util.JSON;
import yuudaari.soulus.common.util.Logger;

public class ConfigTweaker {
    public static JsonObject applyTweaks(String workingDirectory, JsonObject base, JsonArray tweaks) {
        for (JsonElement tweak : tweaks) {
            if (!tweak.isJsonObject()) {
                Logger.warn("Tweaks must be a valid Json Object");
                continue;
            }
            JsonElement conditions = tweak.getAsJsonObject().get("conditions");
            if (conditions == null || !conditions.isJsonArray() && !conditions.isJsonObject()) {
                Logger.warn("Tweaks must have a 'conditions' property.");
                continue;
            }
            if (!ConfigTweaker.conditionsMatch(conditions, null)) continue;
            ConfigTweaker.apply(workingDirectory, base, tweak.getAsJsonObject());
        }
        return base;
    }

    private static boolean conditionsMatch(JsonElement conditions, String strategy) {
        if (conditions.isJsonArray()) {
            return ConfigTweaker.conditionListMatches(conditions.getAsJsonArray(), strategy == null ? "and" : strategy);
        }
        return ConfigTweaker.conditionMatches(conditions.getAsJsonObject());
    }

    private static boolean conditionListMatches(JsonArray conditions, String strategy) {
        for (JsonElement condition : conditions) {
            boolean matches = false;
            if (!condition.isJsonObject()) {
                Logger.warn("Tweak conditions must be Json Objects.");
            } else {
                matches = ConfigTweaker.conditionMatches(condition.getAsJsonObject());
            }
            if (strategy.equalsIgnoreCase("and") && !matches) {
                return false;
            }
            if (!strategy.equalsIgnoreCase("or") || !matches) continue;
            return true;
        }
        return strategy.equalsIgnoreCase("and");
    }

    private static boolean conditionMatches(JsonObject condition) {
        JsonElement conditionTypeJson = condition.get("type");
        if (conditionTypeJson == null || !conditionTypeJson.isJsonPrimitive() || !conditionTypeJson.getAsJsonPrimitive().isString()) {
            return ConfigTweaker.conditionParentMatches(condition);
        }
        String conditionType = conditionTypeJson.getAsString();
        if (conditionType.equalsIgnoreCase("gamestage")) {
            return GameStages.tweakConditionMatches(condition);
        }
        Logger.warn("Tweak condition type '" + conditionType + "' is unknown.");
        return false;
    }

    private static boolean conditionParentMatches(JsonObject conditionParent) {
        JsonElement and = conditionParent.get("and");
        if (and != null && (and.isJsonArray() || and.isJsonObject())) {
            return ConfigTweaker.conditionsMatch(and, "and");
        }
        JsonElement or = conditionParent.get("or");
        if (or != null && (or.isJsonArray() || or.isJsonObject())) {
            return ConfigTweaker.conditionsMatch(or, "or");
        }
        JsonElement not = conditionParent.get("not");
        if (not != null && (not.isJsonArray() || not.isJsonObject())) {
            return !ConfigTweaker.conditionsMatch(not, null);
        }
        Logger.warn("Tweak conditions must have a 'type' property.");
        return false;
    }

    private static void apply(String workingDirectory, JsonObject base, JsonObject tweak) {
        JsonElement tweakData;
        JsonElement changes = tweak.get("changes");
        if (changes != null && changes.isJsonArray()) {
            for (JsonElement change : changes.getAsJsonArray()) {
                if (!change.isJsonObject()) {
                    Logger.warn("Changes must be Json Objects.");
                    continue;
                }
                ConfigTweaker.apply(workingDirectory, base, change.getAsJsonObject());
            }
            return;
        }
        JsonElement insertStrategyJson = tweak.get("insert_strategy");
        if (insertStrategyJson == null || !insertStrategyJson.isJsonPrimitive() || !insertStrategyJson.getAsJsonPrimitive().isString()) {
            Logger.warn("Tweaks must have an 'insert_strategy' property of 'replace' or 'merge'.");
            return;
        }
        JsonElement insertPathJson = tweak.get("insert_path");
        if (insertPathJson == null) {
            insertPathJson = new JsonArray();
        }
        if (!insertPathJson.isJsonArray()) {
            Logger.warn("Tweak 'insert_path' must be an array containing only string or integer values.");
            return;
        }
        JsonArray insertPath = insertPathJson.getAsJsonArray();
        for (JsonElement insertPathSegment : insertPath) {
            if (insertPathSegment.isJsonPrimitive() && (insertPathSegment.getAsJsonPrimitive().isString() || insertPathSegment.getAsJsonPrimitive().isNumber())) continue;
            Logger.warn("Tweak 'insert_path' must be an array containing only string or integer values.");
            return;
        }
        if (!tweak.has("from") && !tweak.has("data")) {
            Logger.warn("Tweaks must have a 'from' or 'data' property. Path: " + ConfigTweaker.getPathString(insertPath));
            return;
        }
        try {
            tweakData = ConfigTweaker.getTweakData(workingDirectory, tweak);
        }
        catch (Exception e) {
            Logger.error(e);
            Logger.warn("Unable to load tweak data. Path: " + ConfigTweaker.getPathString(insertPath));
            return;
        }
        String insertStrategy = insertStrategyJson.getAsString();
        try {
            if (insertStrategy.equalsIgnoreCase("replace")) {
                ConfigTweaker.applyTweakReplace(base, tweakData, insertPath);
            } else if (insertStrategy.equalsIgnoreCase("merge")) {
                ConfigTweaker.applyTweakMerge(base, tweakData, insertPath);
            }
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    private static JsonElement getTweakData(String workingDirectory, JsonObject tweak) {
        JsonElement fromJson = tweak.get("from");
        if (fromJson != null && fromJson.isJsonPrimitive() && fromJson.getAsJsonPrimitive().isString()) {
            String path = fromJson.getAsString();
            if (!path.endsWith(".json")) {
                path = path + ".json";
            }
            return Soulus.config.getConfigFileJson(workingDirectory + "/" + path, false, false);
        }
        return tweak.get("data");
    }

    private static void applyTweakReplace(JsonObject base, JsonElement tweakData, JsonArray insertPath) {
        JsonPrimitive lastKey = insertPath.remove(insertPath.size() - 1).getAsJsonPrimitive();
        JsonElement element = ConfigTweaker.followJsonPath((JsonElement)base, insertPath);
        if (element.isJsonObject() && lastKey.isString()) {
            element.getAsJsonObject().add(lastKey.getAsString(), tweakData);
        } else if (element.isJsonArray() && lastKey.isNumber()) {
            element.getAsJsonArray().set(lastKey.getAsInt(), tweakData);
        } else {
            Logger.warn("Unable apply tweak as path does not exist. Path: " + ConfigTweaker.getPathString(insertPath));
            return;
        }
    }

    private static void applyTweakMerge(JsonObject base, JsonElement tweakData, JsonArray insertPath) {
        JsonElement element = ConfigTweaker.followJsonPath((JsonElement)base, insertPath);
        if (element.isJsonObject() && !tweakData.isJsonObject() || element.isJsonArray() && !tweakData.isJsonArray()) {
            Logger.warn("Unable apply merge tweak as the merging data is not the same type as the type to be merged into. Path: " + ConfigTweaker.getPathString(insertPath));
            return;
        }
        JSON.mergeInto(element, tweakData);
    }

    private static JsonElement followJsonPath(JsonElement element, JsonArray path) {
        for (JsonElement pathSegmentJson : path) {
            JsonPrimitive pathSegmentPrimitive = pathSegmentJson.getAsJsonPrimitive();
            if (element.isJsonObject() && pathSegmentPrimitive.isString()) {
                element = element.getAsJsonObject().get(pathSegmentPrimitive.getAsString());
                continue;
            }
            if (element.isJsonArray() && pathSegmentPrimitive.isNumber()) {
                element = element.getAsJsonArray().get(pathSegmentPrimitive.getAsInt());
                continue;
            }
            throw new IllegalArgumentException("Unable apply tweak as path does not exist. Path: " + ConfigTweaker.getPathString(path));
        }
        return element;
    }

    private static String getPathString(JsonArray path) {
        return Streams.stream((Iterable)path).map(segment -> segment.getAsString()).collect(Collectors.joining("."));
    }
}

