/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.relauncher.Side;
import yuudaari.soulus.common.config.ClientField;
import yuudaari.soulus.common.config.ConfigFile;
import yuudaari.soulus.common.config.ConfigFileUtil;
import yuudaari.soulus.common.config.ConfigInjected;
import yuudaari.soulus.common.config.ConfigTweaker;
import yuudaari.soulus.common.util.CompareJson;
import yuudaari.soulus.common.util.JSON;
import yuudaari.soulus.common.util.Logger;
import yuudaari.soulus.common.util.serializer.DefaultFieldSerializer;
import yuudaari.soulus.common.util.serializer.SerializationHandlers;
import yuudaari.soulus.common.util.serializer.Serialized;

public class Config {
    public static final Map<String, Config> INSTANCES = new HashMap<String, Config>();
    public static boolean CONFIGS_HAVE_GAME_STAGES_TWEAKS = false;
    private final Map<String, List<Class<?>>> CONFIG_CLASSES;
    private final Map<Field, Class<?>> INJECTIONS;
    private final Map<Class<?>, Object> CONFIGS = new HashMap();
    private final String DIRECTORY;
    private final ASMDataTable ASM_DATA_TABLE;
    private final String ID;
    public final Map<String, String> SERVER_CONFIGS = new HashMap<String, String>();

    public Config(ASMDataTable asmDataTable, String directory, String id) {
        this.ASM_DATA_TABLE = asmDataTable;
        this.DIRECTORY = directory;
        this.ID = id;
        this.CONFIG_CLASSES = Config.getConfigFileClasses(asmDataTable, id);
        this.INJECTIONS = Config.getConfigInjections(this.ASM_DATA_TABLE, this.ID);
        INSTANCES.put(id, this);
    }

    @Nullable
    public static <T> T get(String id, Class<T> cls) {
        return (T)Config.INSTANCES.get((Object)id).CONFIGS.get(cls);
    }

    @Nullable
    public <T> T get(Class<T> cls) {
        Object result = this.CONFIGS.get(cls);
        if (result == null || !cls.isInstance(result)) {
            return null;
        }
        return (T)result;
    }

    public void serialize() {
        for (Map.Entry<String, List<Class<?>>> entry : this.CONFIG_CLASSES.entrySet()) {
            Logger.scopes.push("Config Serialization");
            this.trySerializeConfigFile(entry.getKey(), this.filterConfigMap(entry.getValue()));
            Logger.scopes.pop();
        }
    }

    public void deserialize(boolean includeOverrides) {
        this.CONFIGS.clear();
        CONFIGS_HAVE_GAME_STAGES_TWEAKS = false;
        for (Map.Entry<String, List<Class<?>>> entry : this.CONFIG_CLASSES.entrySet()) {
            Map<Class<?>, Object> configs = this.createConfigClassMap(entry.getValue());
            Logger.scopes.push("Config Deserialization");
            this.tryDeserializeConfigFile(entry.getKey(), configs, includeOverrides);
            Logger.scopes.pop();
            this.CONFIGS.putAll(configs);
        }
        this.inject();
    }

    private void inject() {
        for (Map.Entry<Field, Class<?>> configInjection : this.INJECTIONS.entrySet()) {
            Field field = configInjection.getKey();
            try {
                field.set(null, this.get(configInjection.getValue()));
            }
            catch (Exception e) {
                Logger.warn("Unable to inject config '" + configInjection.getValue().getSimpleName() + "' into field: " + field.getName());
            }
        }
    }

    private void trySerializeConfigFile(String filename, Map<Class<?>, Object> toSerialize) {
        String profile = this.getProfile(this.getConfigFileJson(filename, true), filename, toSerialize);
        String profileFilename = filename;
        if (profile != null) {
            profileFilename = this.getProfileFilename(filename, profile);
        }
        Logger.scopes.push(profileFilename);
        JsonObject json = new JsonObject();
        for (Map.Entry<Class<?>, Object> serializationEntry : toSerialize.entrySet()) {
            this.trySerializeClass(serializationEntry.getKey(), serializationEntry.getValue(), json);
        }
        File configFile = new File(this.DIRECTORY + profileFilename);
        Config.writeJsonConfigFile(configFile, json, this.getErrorFilename(configFile.getAbsolutePath()));
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            this.SERVER_CONFIGS.put(filename, JSON.getString((JsonElement)json, null));
        }
        Logger.scopes.pop();
    }

    @Nullable
    private String getConfigFileProfile(Map<Class<?>, Object> toSerialize) {
        Class cls = (Class)toSerialize.keySet().stream().findAny().get();
        ConfigFile configFileAnnotation = cls.getAnnotation(ConfigFile.class);
        if (configFileAnnotation.profile().equals("")) {
            return null;
        }
        return configFileAnnotation.profile();
    }

    private void tryDeserializeConfigFile(String filename, Map<Class<?>, Object> toDeserialize, boolean includeOverrides) {
        JsonObject json = this.getConfigFileJson(filename, true);
        JsonObject serverJson = this.getServerJson(filename);
        String profile = this.getProfile(json, filename, toDeserialize);
        if (profile != null) {
            boolean hasTweaks;
            filename = this.getProfileFilename(filename, profile);
            JsonObject baseProfile = this.getConfigFileJson(filename, true);
            JsonElement tweaks = json == null ? null : json.get("tweaks");
            boolean bl = hasTweaks = tweaks != null && tweaks.isJsonArray();
            if (includeOverrides && hasTweaks) {
                String workingDirectory = new File(filename).getParent();
                workingDirectory = workingDirectory == null ? "" : workingDirectory;
                json = ConfigTweaker.applyTweaks(workingDirectory, baseProfile, tweaks.getAsJsonArray());
            } else {
                json = baseProfile;
            }
            if (hasTweaks) {
                CONFIGS_HAVE_GAME_STAGES_TWEAKS = true;
            }
        }
        Logger.scopes.push(filename);
        if (json == null) {
            Logger.warn("Not a valid Json Object");
        }
        for (Map.Entry<Class<?>, Object> deserializationEntry : toDeserialize.entrySet()) {
            Class<?> configClass = deserializationEntry.getKey();
            Object deserialized = this.tryDeserializeClass(configClass, json, profile);
            if (serverJson != null && FMLCommonHandler.instance().getEffectiveSide() != Side.SERVER) {
                Object deserializedServer = this.tryDeserializeClass(configClass, serverJson, null);
                if (includeOverrides) {
                    this.injectServerFields(configClass, deserialized, deserializedServer);
                }
            }
            deserializationEntry.setValue(deserialized);
        }
        Logger.scopes.pop();
    }

    private void injectServerFields(Class<?> configClass, Object localConfig, Object serverConfig) {
        Logger.scopes.push("Sync");
        for (Field field : configClass.getFields()) {
            Serialized serializedAnnotation = field.getAnnotation(Serialized.class);
            if (serializedAnnotation == null || field.getAnnotation(ClientField.class) != null) continue;
            Logger.scopes.push(field.getName());
            try {
                Object val = field.get(serverConfig);
                field.set(localConfig, val);
            }
            catch (IllegalAccessException e) {
                Logger.warn("Unable to synchronise");
                Logger.error(e);
            }
            Logger.scopes.pop();
        }
        Logger.scopes.pop();
    }

    private String getProfile(JsonObject json, String filename, Map<Class<?>, Object> toSerialize) {
        JsonElement jsonProfile;
        if (json == null) {
            String profile = this.getConfigFileProfile(toSerialize);
            if (profile == null) {
                return null;
            }
            JsonObject jsonProfile2 = new JsonObject();
            jsonProfile2.add("profile", (JsonElement)new JsonPrimitive(profile));
            File file = new File(this.DIRECTORY + filename);
            Config.writeJsonConfigFile(file, jsonProfile2, this.getErrorFilename(file.getAbsolutePath()));
            return profile;
        }
        JsonElement jsonElement = jsonProfile = json == null ? null : json.get("profile");
        if (jsonProfile != null && jsonProfile.isJsonPrimitive() && jsonProfile.getAsJsonPrimitive().isString()) {
            return jsonProfile.getAsString();
        }
        return null;
    }

    private String getProfileFilename(String filename, String profile) {
        return new StringBuilder(filename).insert(filename.lastIndexOf(46), '#' + profile).toString();
    }

    private String getErrorFilename(String filename) {
        return new StringBuilder(filename).insert(filename.lastIndexOf(46), ".err").toString();
    }

    private JsonObject getConfigFileJson(String filename, boolean create) {
        return (JsonObject)this.getConfigFileJson(filename, create, true);
    }

    public JsonElement getConfigFileJson(String filename, boolean create, boolean mustBeJsonObject) {
        File configFile = new File(this.DIRECTORY + filename);
        if (!configFile.exists()) {
            if (!create) {
                return null;
            }
            this.createConfigFile(configFile);
        }
        try {
            return Config.parseJsonConfigFile(new FileReader(configFile), true, mustBeJsonObject);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    private JsonObject getServerJson(String filename) {
        String serverConfigFileText = this.SERVER_CONFIGS.get(filename);
        return serverConfigFileText == null ? null : Config.parseJsonConfigFile(new StringReader(serverConfigFileText));
    }

    private void trySerializeClass(Class<?> cls, Object toSerialize, JsonObject containingObject) {
        Logger.scopes.push(cls.getSimpleName());
        containingObject = this.getActualContainingObject(containingObject, cls, true);
        if (containingObject != null) {
            SerializationHandlers.IClassSerializationHandler<Object> deserializer = DefaultFieldSerializer.getClassSerializer(cls);
            if (deserializer != null) {
                try {
                    DefaultFieldSerializer.serializeClass(deserializer, toSerialize, containingObject);
                }
                catch (Exception e) {
                    boolean isNormalException = e.getClass() == Exception.class;
                    Logger.warn("Could not serialize class: " + (isNormalException ? e.getMessage() : ""));
                    if (!isNormalException) {
                        Logger.error(e);
                    }
                }
            } else {
                Logger.warn("Class is not @Serializable");
            }
        }
        Logger.scopes.pop();
    }

    private Object tryDeserializeClass(Class<?> cls, JsonObject containingObject, @Nullable String profile) {
        Logger.scopes.push(cls.getSimpleName());
        Object result = null;
        containingObject = this.getActualContainingObject(containingObject, cls);
        SerializationHandlers.IClassDeserializationHandler<Object> deserializer = DefaultFieldSerializer.getClassDeserializer(cls);
        if (deserializer != null) {
            try {
                result = DefaultFieldSerializer.deserializeClass(deserializer, cls, (JsonElement)containingObject, profile);
            }
            catch (Exception e) {
                Logger.warn("Could not deserialize class: " + (e.getClass() == Exception.class ? e.getMessage() : e));
            }
        } else {
            Logger.warn("Class is not @Serializable");
        }
        Logger.scopes.pop();
        return result;
    }

    @Nullable
    private JsonObject getActualContainingObject(JsonObject containingObject, Class<?> cls) {
        return this.getActualContainingObject(containingObject, cls, false);
    }

    @Nullable
    private JsonObject getActualContainingObject(JsonObject containingObject, Class<?> cls, boolean createMissing) {
        JsonObject result = containingObject;
        CharSequence[] propertyPath = ConfigFileUtil.getConfigPropertyPath(cls);
        if (result != null) {
            for (CharSequence property : propertyPath) {
                JsonElement propertyValue = result.get((String)property);
                if (propertyValue == null || !propertyValue.isJsonObject()) {
                    if (createMissing) {
                        propertyValue = new JsonObject();
                        result.add((String)property, propertyValue);
                    } else {
                        result = null;
                        break;
                    }
                }
                result = propertyValue.getAsJsonObject();
            }
        }
        if (result == null) {
            Logger.warn("Config file must include the path: '" + String.join((CharSequence)".", propertyPath) + "'");
        }
        return result;
    }

    @Nullable
    private static JsonObject parseJsonConfigFile(Reader reader) {
        return (JsonObject)Config.parseJsonConfigFile(reader, true, true);
    }

    @Nullable
    private static JsonElement parseJsonConfigFile(Reader reader, boolean warn, boolean mustBeJsonObject) {
        block3: {
            try {
                JsonElement json = new JsonParser().parse(reader);
                if (json != null && (!mustBeJsonObject || json.isJsonObject())) {
                    return json;
                }
            }
            catch (JsonParseException e) {
                if (!warn) break block3;
                Logger.warn("Could not parse the config file: " + e.getMessage());
            }
        }
        return null;
    }

    private static void writeJsonConfigFile(File configFile, JsonObject json, @Nullable String saveOld) {
        try {
            String oldFileText;
            JsonElement oldConfig = Config.parseJsonConfigFile(new FileReader(configFile), false, false);
            if (CompareJson.equal((JsonElement)json, oldConfig)) {
                return;
            }
            String newFileText = JSON.getString((JsonElement)json, "\t");
            if (newFileText.equals(oldFileText = new String(Files.readAllBytes(configFile.toPath())))) {
                return;
            }
            if (saveOld != null && oldFileText.length() > 0) {
                Files.write(new File(saveOld).toPath(), oldFileText.getBytes(), new OpenOption[0]);
            }
            Files.write(configFile.toPath(), newFileText.getBytes(), new OpenOption[0]);
        }
        catch (JsonParseException | IOException e) {
            Logger.warn("Could not write the config file: " + e.getMessage());
        }
    }

    private boolean createConfigFile(File configFile) {
        try {
            configFile.getParentFile().mkdirs();
            configFile.createNewFile();
            return true;
        }
        catch (IOException e) {
            Logger.warn("Could not create the config file: " + e.getMessage());
            return false;
        }
    }

    private Map<Class<?>, Object> createConfigClassMap(List<Class<?>> classes) {
        HashMap result = new HashMap();
        for (Class<?> cls : classes) {
            result.put(cls, null);
        }
        return result;
    }

    private static List<Class<?>> getSerializableClasses(ASMDataTable asmDataTable) {
        ArrayList classes = new ArrayList();
        String annotationClassName = ConfigFile.class.getCanonicalName();
        Set asmDatas = asmDataTable.getAll(annotationClassName);
        for (ASMDataTable.ASMData asmData : asmDatas) {
            try {
                Class<?> asmClass = Class.forName(asmData.getClassName());
                classes.add(asmClass);
            }
            catch (ClassNotFoundException | LinkageError e) {
                Logger.warn("Failed to get class from ASM data: " + asmData.getClassName() + e);
            }
        }
        return classes;
    }

    private static Map<Field, Class<?>> getConfigInjections(ASMDataTable asmDataTable, String id) {
        HashMap result = new HashMap();
        List<Class<?>> classes = Config.getInjectedClasses(asmDataTable, id);
        for (Class<?> injectionClass : classes) {
            for (Field field : injectionClass.getDeclaredFields()) {
                ConfigInjected.Inject injectAnnotation = field.getAnnotation(ConfigInjected.Inject.class);
                if (injectAnnotation == null) continue;
                Class<?> classToInject = injectAnnotation.value() == ConfigInjected.Inject.class ? field.getType() : injectAnnotation.value();
                result.put(field, classToInject);
            }
        }
        return result;
    }

    private static List<Class<?>> getInjectedClasses(ASMDataTable asmDataTable, String id) {
        ArrayList classes = new ArrayList();
        String annotationClassName = ConfigInjected.class.getCanonicalName();
        Set asmDatas = asmDataTable.getAll(annotationClassName);
        for (ASMDataTable.ASMData asmData : asmDatas) {
            try {
                Class<?> annotatedClass = Class.forName(asmData.getClassName());
                ConfigInjected injected = annotatedClass.getAnnotation(ConfigInjected.class);
                if (!injected.value().equals(id)) continue;
                classes.add(annotatedClass);
            }
            catch (ClassNotFoundException | LinkageError | NullPointerException e) {
                Logger.warn("Failed to get class from ASM data: " + asmData.getClassName() + e);
            }
        }
        return classes;
    }

    private static Map<String, List<Class<?>>> getConfigFileClasses(ASMDataTable asmDataTable, String id) {
        Logger.scopes.push("Config File class registration");
        HashMap result = new HashMap();
        List<Class<?>> classes = Config.getSerializableClasses(asmDataTable);
        for (Class<?> cls : classes) {
            String configFileId = ConfigFileUtil.getConfigId(cls);
            if (!id.equals(configFileId)) continue;
            String configFile = ConfigFileUtil.getConfigFile(cls);
            if (configFile == null) {
                Logger.warn("Cannot get the config file for '" + cls.getSimpleName() + "'");
                continue;
            }
            ArrayList configFileClasses = (ArrayList)result.get(configFile);
            if (configFileClasses == null) {
                configFileClasses = new ArrayList();
                result.put(configFile, configFileClasses);
            }
            configFileClasses.add(cls);
        }
        Logger.scopes.pop();
        return result;
    }

    private Map<Class<?>, Object> filterConfigMap(List<Class<?>> validKeys) {
        return this.CONFIGS.entrySet().stream().filter(e -> validKeys.contains(e.getKey())).collect(HashMap::new, (m, v) -> m.put(v.getKey(), v.getValue()), HashMap::putAll);
    }
}

