/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.block;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.util.IStringSerializable;
import yuudaari.soulus.common.util.serializer.FieldSerializer;

public enum EndersteelType implements IStringSerializable
{
    NORMAL(0, "normal"),
    EARTHY(1, "earthy"),
    SPOOKY(2, "spooky"),
    ENDER(3, "ender"),
    BLAZING(4, "blazing"),
    SORROW(5, "sorrow"),
    MADNESS(6, "madness");

    private final int meta;
    private final String name;

    private EndersteelType(int meta, String name) {
        this.meta = meta;
        this.name = name;
    }

    public int getMeta() {
        return this.meta;
    }

    public String func_176610_l() {
        return this.name;
    }

    public static EndersteelType byMetadata(int meta) {
        return meta < 0 || meta >= EndersteelType.values().length ? NORMAL : EndersteelType.values()[meta];
    }

    public static EndersteelType byName(String name) {
        Optional<EndersteelType> endersteelType = Arrays.asList(EndersteelType.values()).stream().filter(type -> type.func_176610_l().equalsIgnoreCase(name)).findFirst();
        return endersteelType.isPresent() ? endersteelType.get() : NORMAL;
    }

    public static class Serializer
    extends FieldSerializer<EndersteelType> {
        @Override
        public JsonElement serialize(Class<?> objectType, EndersteelType type) {
            return new JsonPrimitive(type.name);
        }

        @Override
        public EndersteelType deserialize(Class<?> requestedType, JsonElement element) {
            return EndersteelType.byName(element.getAsString());
        }
    }
}

