/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.client.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import yuudaari.soulus.client.util.TileEntityRenderer;
import yuudaari.soulus.common.block.soul_inquirer.SoulInquirerTileEntity;

@SideOnly(value=Side.CLIENT)
public class SoulInquirerRenderer
extends TileEntityRenderer<SoulInquirerTileEntity> {
    @Override
    public Class<SoulInquirerTileEntity> getTileEntityClass() {
        return SoulInquirerTileEntity.class;
    }

    private void spawnRenderMob(SoulInquirerTileEntity tileEntity) {
        NBTTagCompound entityNbt = tileEntity.getEntityNbt();
        World world = tileEntity.func_145831_w();
        tileEntity.renderMob = (EntityLiving)AnvilChunkLoader.func_186051_a((NBTTagCompound)entityNbt, (World)world, (boolean)false);
        String mobName = entityNbt.func_74779_i("id");
        if (tileEntity.renderMob == null) {
            throw new RuntimeException("Unable to summon mobName " + mobName);
        }
        tileEntity.renderMob.func_180482_a(world.func_175649_E(new BlockPos((Entity)tileEntity.renderMob)), null);
    }

    public void render(SoulInquirerTileEntity te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (te.getEssenceType() == null) {
            return;
        }
        if (te.renderMob == null || !te.getEssenceType().equals(te.lastRenderedEssenceType)) {
            te.lastRenderedEssenceType = te.getEssenceType();
            this.spawnRenderMob(te);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y), (float)((float)z + 0.5f));
        this.renderMob(te, x, y, z, partialTicks);
        GlStateManager.func_179121_F();
    }

    public void renderMob(SoulInquirerTileEntity te, double posX, double posY, double posZ, float partialTicks) {
        EntityLiving renderMob = te.renderMob;
        double mobRotation = te.mobRotation;
        double prevMobRotation = te.prevMobRotation;
        float f = 0.4f;
        float f1 = Math.max(renderMob.field_70130_N, renderMob.field_70131_O);
        if ((double)f1 > 1.0) {
            f /= f1;
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.7f, (float)0.0f);
        float rotate = (float)(prevMobRotation + (mobRotation - prevMobRotation) * (double)partialTicks);
        GlStateManager.func_179114_b((float)(rotate * 10.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(rotate * 4.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)(rotate * 0.5f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)-0.2f, (float)0.0f);
        GlStateManager.func_179152_a((float)f, (float)f, (float)f);
        renderMob.func_70012_b(posX, posY, posZ, 0.0f, 0.0f);
        Minecraft.func_71410_x().func_175598_ae().func_188391_a((Entity)renderMob, 0.0, 0.0, 0.0, 0.0f, partialTicks, false);
    }
}

