/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.client.compat.patchouli;

import javax.annotation.Nullable;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.patchouli.api.PatchouliAPI;
import yuudaari.soulus.common.recipe.composer.IRecipeComposer;
import yuudaari.soulus.common.util.Translation;

public class ComposerCraftingPage
implements IComponentProcessor {
    private transient IRecipe recipe;
    @Nullable
    private transient IRecipe recipe2;
    private transient String text;
    @Nullable
    private transient String title;
    @Nullable
    private transient String title2;

    public void setup(IVariableProvider<String> provider) {
        this.text = !provider.has("text") ? "" : (String)provider.get("text");
        this.recipe = this.getRecipe((String)provider.get("recipe"));
        this.recipe2 = !provider.has("recipe2") ? null : this.getRecipe((String)provider.get("recipe2"));
        this.title = this.recipe.func_77571_b().func_82833_r();
        if (provider.has("title")) {
            this.title = (String)provider.get("title");
        } else {
            String string = this.title2 = this.recipe2 == null ? null : this.recipe2.func_77571_b().func_82833_r();
            if (this.title.equalsIgnoreCase(this.title2)) {
                this.title2 = null;
            }
        }
    }

    public String process(String key) {
        return key.startsWith("recipe2_") ? this.processRecipe(this.recipe2, key.substring(8)) : this.processRecipe(this.recipe, key);
    }

    public boolean allowRender(String group) {
        switch (group) {
            case "single_recipe": {
                return this.recipe2 == null;
            }
            case "multi_recipe": {
                return this.recipe2 != null && this.title2 != null;
            }
            case "title2": {
                return this.title2 != null;
            }
            case "multi_recipe_no_title2": {
                return this.recipe2 != null && this.title2 == null;
            }
            case "shapeless": {
                return !(this.recipe instanceof IShapedRecipe);
            }
            case "recipe2_shapeless": {
                return this.recipe2 != null && this.title2 != null && !(this.recipe2 instanceof IShapedRecipe);
            }
            case "recipe2_shapeless_no_title2": {
                return this.recipe2 != null && this.title2 == null && !(this.recipe2 instanceof IShapedRecipe);
            }
        }
        return false;
    }

    private String processRecipe(IRecipe recipe, String key) {
        if (recipe == null) {
            return null;
        }
        if (key.startsWith("input")) {
            return this.processRecipeInput(recipe, Integer.parseInt(key.substring(5)) - 1);
        }
        switch (key) {
            case "output": {
                return PatchouliAPI.instance.serializeItemStack(recipe.func_77571_b());
            }
            case "time": {
                String timeString = "" + (recipe instanceof IRecipeComposer ? ((IRecipeComposer)recipe).getTime() : 1.0f);
                if (timeString.endsWith(".0")) {
                    timeString = timeString.substring(0, timeString.length() - 2);
                }
                timeString = Translation.localize("patchouli.recipe.soulus:composer.recipe_time", timeString);
                return timeString;
            }
            case "name": {
                return recipe != this.recipe2 || this.title2 == null ? this.title : this.title2;
            }
            case "text": {
                return this.text;
            }
        }
        return null;
    }

    private String processRecipeInput(IRecipe recipe, int ingredientId) {
        NonNullList ingredients = recipe.func_192400_c();
        if (ingredients.size() > ingredientId) {
            return PatchouliAPI.instance.serializeIngredient((Ingredient)ingredients.get(ingredientId));
        }
        return null;
    }

    private IRecipe getRecipe(String name) {
        return (IRecipe)ForgeRegistries.RECIPES.getValue(new ResourceLocation(name));
    }
}

