/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.dynamo;

import cofh.core.fluid.FluidTankCore;
import cofh.core.gui.container.ContainerTileAugmentable;
import cofh.core.network.PacketBase;
import cofh.core.render.TextureHelper;
import cofh.core.util.core.EnergyConfig;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.dynamo.TileDynamoBase;
import cofh.thermalexpansion.gui.client.dynamo.GuiDynamoCompression;
import cofh.thermalexpansion.util.managers.device.CoolantManager;
import cofh.thermalexpansion.util.managers.dynamo.CompressionManager;
import cofh.thermalfoundation.init.TFFluids;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileDynamoCompression
extends TileDynamoBase {
    protected static final EnergyConfig ENERGY_CONFIG = new EnergyConfig();
    protected static final HashSet<String> VALID_AUGMENTS = new HashSet();
    public static boolean enable = true;
    public static int basePower = 40;
    public static int fluidAmount = 100;
    private FluidTankCore fuelTank = new FluidTankCore(4000);
    private FluidTankCore coolantTank = new FluidTankCore(4000);
    private FluidStack renderFluid = new FluidStack(FluidRegistry.LAVA, 1000);
    private int coolantRF;
    private int coolantFactor;
    protected boolean augmentCoolant;
    protected boolean augmentFuel;
    protected boolean augmentBiofuel;

    public static void initialize() {
        VALID_AUGMENTS.addAll(VALID_AUGMENTS_BASE);
        VALID_AUGMENTS.add("dynamoBoiler");
        VALID_AUGMENTS.add("dynamoCompressionCoolant");
        VALID_AUGMENTS.add("dynamoCompressionFuel");
        VALID_AUGMENTS.add("dynamoCompressionBiofuel");
        GameRegistry.registerTileEntity(TileDynamoCompression.class, (String)"thermalexpansion:dynamo_compression");
        TileDynamoCompression.config();
    }

    public static void config() {
        String category = "Dynamo.Compression";
        enable = ThermalExpansion.CONFIG.get(category, "Enable", true);
        String comment = "Adjust this value to change the Energy generation (in RF/t) for a Compression Dynamo. This base value will scale with block level and Augments.";
        basePower = ThermalExpansion.CONFIG.getConfiguration().getInt("BasePower", category, basePower, 10, 200, comment);
        ENERGY_CONFIG.setDefaultParams(basePower, smallStorage);
    }

    protected String getTileName() {
        return "tile.thermalexpansion.dynamo.compression.name";
    }

    @Override
    protected EnergyConfig getEnergyConfig() {
        return ENERGY_CONFIG;
    }

    @Override
    protected HashSet<String> getValidAugments() {
        return VALID_AUGMENTS;
    }

    @Override
    protected boolean canStart() {
        return !(this.fuelRF <= 0 && this.fuelTank.getFluidAmount() < fluidAmount || this.coolantRF <= 0 && this.coolantTank.getFluidAmount() < fluidAmount);
    }

    @Override
    protected boolean canFinish() {
        return this.fuelRF <= 0 || this.coolantRF <= 0;
    }

    @Override
    protected void processStart() {
        if (this.fuelRF <= 0) {
            this.fuelRF += CompressionManager.getFuelEnergy100mB(this.fuelTank.getFluid()) * (this.energyMod + this.coolantFactor) / 100;
            this.fuelTank.drain(fluidAmount, true);
        }
        if (this.coolantRF <= 0) {
            this.coolantRF += CoolantManager.getCoolantRF100mB(this.coolantTank.getFluid());
            this.coolantFactor = this.augmentBoiler ? 0 : CoolantManager.getCoolantFactor(this.coolantTank.getFluid()) - 20;
            this.coolantTank.drain(fluidAmount, true);
        }
    }

    @Override
    protected int processTick() {
        if (this.augmentBoiler) {
            this.fuelRF -= this.energyConfig.maxPower;
            this.coolantRF -= this.energyConfig.maxPower;
            this.transferSteam();
            return this.energyConfig.maxPower;
        }
        this.lastEnergy = this.calcEnergy();
        this.energyStorage.modifyEnergyStored(this.lastEnergy);
        this.fuelRF -= this.lastEnergy;
        this.coolantRF -= this.augmentCoolant ? 0 : this.lastEnergy;
        this.transferEnergy();
        return this.lastEnergy;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getBaseUnderlayTexture() {
        return TextureHelper.getTexture((ResourceLocation)this.renderFluid.getFluid().getStill(this.renderFluid));
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiDynamoCompression(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerTileAugmentable(inventory, (TileEntity)this);
    }

    @Override
    public FluidTankCore getTank(int tankIndex) {
        if (tankIndex == 0) {
            return this.fuelTank;
        }
        return this.coolantTank;
    }

    @Override
    public int getFuelEnergy(ItemStack stack) {
        FluidStack fluid = FluidHelper.getFluidForFilledItem((ItemStack)stack);
        if (fluid == null || this.augmentFuel && !TFFluids.fluidFuel.equals(fluid.getFluid())) {
            return 0;
        }
        return CompressionManager.isValidFuel(fluid) ? CompressionManager.getFuelEnergy(fluid) * (this.energyMod + this.coolantFactor) / 100 : 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.coolantRF = nbt.func_74762_e("Coolant");
        this.coolantFactor = nbt.func_74762_e("CoolantFactor");
        this.fuelTank.readFromNBT(nbt.func_74775_l("FuelTank"));
        this.coolantTank.readFromNBT(nbt.func_74775_l("CoolantTank"));
        if (!CompressionManager.isValidFuel(this.fuelTank.getFluid())) {
            this.fuelTank.setFluid(null);
        }
        if (!CoolantManager.isValidCoolant(this.coolantTank.getFluid())) {
            this.coolantTank.setFluid(null);
        }
        if (this.fuelTank.getFluid() != null) {
            this.renderFluid = this.fuelTank.getFluid();
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Coolant", this.coolantRF);
        nbt.func_74768_a("CoolantFactor", this.coolantFactor);
        nbt.func_74782_a("FuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("CoolantTank", (NBTBase)this.coolantTank.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    @Override
    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addFluidStack(this.fuelTank.getFluid());
        payload.addFluidStack(this.coolantTank.getFluid());
        return payload;
    }

    @Override
    public PacketBase getTilePacket() {
        PacketBase payload = super.getTilePacket();
        payload.addFluidStack(this.fuelTank.getFluid());
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.fuelTank.setFluid(payload.getFluidStack());
        this.coolantTank.setFluid(payload.getFluidStack());
        if (!this.augmentBoiler) {
            this.coolantFactor = Math.max(0, CoolantManager.getCoolantFactor(this.coolantTank.getFluid()) - 20);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketBase payload) {
        super.handleTilePacket(payload);
        FluidStack tempRender = payload.getFluidStack();
        this.renderFluid = tempRender == null ? new FluidStack(FluidRegistry.LAVA, 1000) : tempRender;
    }

    @Override
    protected void preAugmentInstall() {
        super.preAugmentInstall();
        this.augmentCoolant = false;
        this.augmentFuel = false;
        this.augmentBiofuel = false;
        this.fuelTank.clearLocked();
        this.coolantTank.clearLocked();
    }

    @Override
    protected void postAugmentInstall() {
        super.postAugmentInstall();
        if (this.augmentBoiler) {
            this.coolantTank.setLock(FluidRegistry.WATER);
            this.coolantFactor = 0;
        } else if (this.augmentFuel) {
            this.fuelTank.setLock(TFFluids.fluidFuel);
        } else if (this.augmentBiofuel) {
            this.fuelTank.setLock(TFFluids.fluidBiofuel);
        }
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if (!this.augmentBoiler && "dynamoBoiler".equals(id)) {
            this.augmentBoiler = true;
            this.hasModeAugment = true;
            this.energyConfig.setDefaultParams(this.energyConfig.maxPower + this.getBasePower(this.level), smallStorage);
            this.energyStorage.setEnergyStored(0);
            this.energyMod -= 40;
            return true;
        }
        if (!this.augmentCoolant && "dynamoCompressionCoolant".equals(id)) {
            this.augmentCoolant = true;
            this.hasModeAugment = true;
            return true;
        }
        if (!this.augmentFuel && "dynamoCompressionFuel".equals(id)) {
            this.augmentFuel = true;
            this.hasModeAugment = true;
            this.energyConfig.setDefaultParams(this.energyConfig.maxPower + 3 * this.getBasePower(this.level), smallStorage);
            this.energyMod += 50;
            return true;
        }
        if (!this.augmentFuel && "dynamoCompressionBiofuel".equals(id)) {
            this.augmentBiofuel = true;
            this.hasModeAugment = true;
            this.energyConfig.setDefaultParams(this.energyConfig.maxPower + 2 * this.getBasePower(this.level), smallStorage);
            this.energyMod += 25;
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    return FluidTankProperties.convert((FluidTankInfo[])new FluidTankInfo[]{TileDynamoCompression.this.fuelTank.getInfo(), TileDynamoCompression.this.coolantTank.getInfo()});
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (from == null || TileDynamoCompression.this.augmentCoilDuct || from.ordinal() != TileDynamoCompression.this.facing) {
                        if (CompressionManager.isValidFuel(resource)) {
                            return TileDynamoCompression.this.fuelTank.fill(resource, doFill);
                        }
                        if (TileDynamoCompression.this.augmentBoiler && resource.getFluid() == FluidRegistry.WATER) {
                            return TileDynamoCompression.this.coolantTank.fill(resource, doFill);
                        }
                        if (CoolantManager.isValidCoolant(resource)) {
                            return TileDynamoCompression.this.coolantTank.fill(resource, doFill);
                        }
                    }
                    return 0;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (from == null || TileDynamoCompression.this.augmentCoilDuct || from.ordinal() != TileDynamoCompression.this.facing) {
                        if (resource.equals((Object)TileDynamoCompression.this.fuelTank.getFluid())) {
                            return TileDynamoCompression.this.fuelTank.drain(resource.amount, doDrain);
                        }
                        if (resource.equals((Object)TileDynamoCompression.this.coolantTank.getFluid())) {
                            return TileDynamoCompression.this.coolantTank.drain(resource.amount, doDrain);
                        }
                    }
                    return null;
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (from == null || TileDynamoCompression.this.augmentCoilDuct || from.ordinal() != TileDynamoCompression.this.facing) {
                        FluidStack ret = TileDynamoCompression.this.fuelTank.drain(maxDrain, doDrain);
                        return ret != null ? ret : TileDynamoCompression.this.coolantTank.drain(maxDrain, doDrain);
                    }
                    return null;
                }
            });
        }
        return super.getCapability(capability, from);
    }
}

