/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.coordselector;

import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.ChatUtil;
import com.enderio.core.common.util.UserIdent;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.gui.handler.IEioGuiHandler;
import crazypants.enderio.base.init.ModObjectRegistry;
import crazypants.enderio.base.item.coordselector.GuiLocationPrintout;
import crazypants.enderio.base.item.coordselector.ICoordinateAware;
import crazypants.enderio.base.item.coordselector.TelepadTarget;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.util.Prep;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemLocationPrintout
extends Item
implements IEioGuiHandler {
    static final int GUI_ID_LOCATION_PRINTOUT_CREATE = 1337;
    static final int GUI_ID_LOCATION_PRINTOUT = 31337;

    public static ItemLocationPrintout create(@Nonnull IModObject modObject) {
        return new ItemLocationPrintout(modObject);
    }

    protected ItemLocationPrintout(@Nonnull IModObject modObject) {
        Prep.setNoCreativeTab(this);
        modObject.apply(this);
        this.func_77625_d(1);
    }

    public boolean doesSneakBypassUse(@Nonnull ItemStack stack, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        return true;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af() && TelepadTarget.readFromNBT(stack) != null) {
            ModObjectRegistry.getModObjectNN(this).openClientGui(world, player, 31337, hand.ordinal(), 0);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull EntityPlayer player, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        TelepadTarget targ = TelepadTarget.readFromNBT(stack);
        if (targ == null) {
            player.func_145747_a((ITextComponent)new TextComponentString("No location? but how.."));
            return EnumActionResult.SUCCESS;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof ICoordinateAware.SingleTarget) {
            ICoordinateAware.SingleTarget tile = (ICoordinateAware.SingleTarget)te;
            return this.onTelepadClicked(stack, player, worldIn, tile, targ);
        }
        if (te instanceof ICoordinateAware.MultipleTargets) {
            ICoordinateAware.MultipleTargets dd = (ICoordinateAware.MultipleTargets)te;
            dd.addTarget(targ);
            if (worldIn.field_72995_K) {
                player.func_145747_a((ITextComponent)Lang.PRINTOUT_ADDTARGET.toChat(targ.getChatString()));
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @Nonnull
    private EnumActionResult onTelepadClicked(@Nonnull ItemStack stack, @Nonnull EntityPlayer player, @Nonnull World worldIn, @Nonnull ICoordinateAware.SingleTarget tile, @Nonnull TelepadTarget targ) {
        if (tile.canBlockBeAccessed(player)) {
            tile.setTarget(targ);
            if (worldIn.field_72995_K) {
                player.func_145747_a((ITextComponent)Lang.PRINTOUT_SETTARGET.toChat(targ.getChatString()));
            }
        } else {
            ItemLocationPrintout.sendPrivateChatMessage(player, tile.getOwner());
        }
        return EnumActionResult.SUCCESS;
    }

    public static void sendPrivateChatMessage(@Nonnull EntityPlayer player, @Nonnull UserIdent owner) {
        if (!player.func_70093_af()) {
            ChatUtil.sendNoSpam((EntityPlayer)player, (String[])new String[]{Lang.PRINTOUT_PRIVATE.get(TextFormatting.RED, owner.getPlayerName(), TextFormatting.WHITE)});
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        TelepadTarget target = TelepadTarget.readFromNBT(stack);
        if (target != null && target.isValid()) {
            tooltip.add(BlockCoord.chatString((BlockPos)new BlockPos((Vec3i)target.getLocation()), (TextFormatting)TextFormatting.GRAY));
            tooltip.add(TelepadTarget.getDimenionName(target.getDimension()));
        }
    }

    @Override
    @Nullable
    public Object getGuiElement(boolean server, @Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int ID, int handID, int param3) {
        if (server) {
            return null;
        }
        if (1337 == ID) {
            int foundPaper = -1;
            for (int paperIndex = 0; paperIndex < player.field_71069_bz.field_75151_b.size() && foundPaper < 0; ++paperIndex) {
                ItemStack invItem = ((Slot)player.field_71069_bz.field_75151_b.get(paperIndex)).func_75211_c();
                if (invItem.func_77973_b() != Items.field_151121_aF) continue;
                foundPaper = paperIndex;
            }
            if (foundPaper < 0) {
                player.func_145747_a((ITextComponent)Lang.PRINTOUT_NOPAPER.toChat());
                return null;
            }
            TelepadTarget target = new TelepadTarget(pos, world.field_73011_w.getDimension());
            ItemStack stack = new ItemStack((Item)this);
            target.writeToNBT(stack);
            return new GuiLocationPrintout(target, stack, foundPaper);
        }
        if (31337 == ID) {
            EnumHand hand = handID == 0 ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
            EntityEquipmentSlot slot = hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND;
            TelepadTarget target = TelepadTarget.readFromNBT(player.func_184582_a(slot));
            if (target != null) {
                return new GuiLocationPrintout(target, player, slot);
            }
            return null;
        }
        return null;
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> subItems) {
    }

    @Nonnull
    public CreativeTabs[] getCreativeTabs() {
        return new CreativeTabs[0];
    }
}

