/*
 * Decompiled with CFR 0.152.
 */
package terrails.terracore.base.registry;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.potion.Potion;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import terrails.terracore.base.IModEntry;
import terrails.terracore.base.registry.RegistryType;
import terrails.terracore.block.item.ItemBlockBase;
import terrails.terracore.registry.IItemBlock;
import terrails.terracore.registry.IPostRegistry;

public class RegistryEventHandler {
    private final IModEntry modEntry;

    public RegistryEventHandler(IModEntry modEntry) {
        this.modEntry = modEntry;
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        List blocks = this.getRegistry(RegistryType.BLOCK);
        event.getRegistry().registerAll((IForgeRegistryEntry[])blocks.toArray(new Block[0]));
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        List items = this.getRegistry(RegistryType.ITEM);
        event.getRegistry().registerAll((IForgeRegistryEntry[])items.toArray(new Item[0]));
        items.stream().filter(IPostRegistry.class::isInstance).map(IPostRegistry.class::cast).forEach(IPostRegistry::initEntry);
        List blocks = this.getRegistry(RegistryType.BLOCK);
        event.getRegistry().registerAll((IForgeRegistryEntry[])blocks.stream().filter(IItemBlock.class::isInstance).map(IItemBlock.class::cast).map(IItemBlock::getItemBlock).toArray(ItemBlock[]::new));
        event.getRegistry().registerAll((IForgeRegistryEntry[])blocks.stream().filter(((Predicate<Block>)IItemBlock.class::isInstance).negate()).map(ItemBlockBase::new).toArray(ItemBlock[]::new));
        blocks.stream().filter(IPostRegistry.class::isInstance).map(IPostRegistry.class::cast).forEach(IPostRegistry::initEntry);
    }

    @SubscribeEvent
    public void registerPotions(RegistryEvent.Register<Potion> event) {
        List potions = this.getRegistry(RegistryType.POTION);
        event.getRegistry().registerAll((IForgeRegistryEntry[])potions.toArray(new Potion[0]));
        potions.stream().filter(IPostRegistry.class::isInstance).map(IPostRegistry.class::cast).forEach(IPostRegistry::initEntry);
    }

    @SubscribeEvent
    public void registerBiomes(RegistryEvent.Register<Biome> event) {
        List biomes = this.getRegistry(RegistryType.BIOME);
        event.getRegistry().registerAll((IForgeRegistryEntry[])biomes.toArray(new Biome[0]));
        biomes.stream().filter(IPostRegistry.class::isInstance).map(IPostRegistry.class::cast).forEach(IPostRegistry::initEntry);
    }

    @SubscribeEvent
    public void registerSoundEvents(RegistryEvent.Register<SoundEvent> event) {
        List soundEvents = this.getRegistry(RegistryType.SOUND_EVENT);
        event.getRegistry().registerAll((IForgeRegistryEntry[])soundEvents.toArray(new SoundEvent[0]));
        soundEvents.stream().filter(IPostRegistry.class::isInstance).map(IPostRegistry.class::cast).forEach(IPostRegistry::initEntry);
    }

    @SubscribeEvent
    public void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        List enchantments = this.getRegistry(RegistryType.ENCHANTMENT);
        event.getRegistry().registerAll((IForgeRegistryEntry[])enchantments.toArray(new Enchantment[0]));
        enchantments.stream().filter(IPostRegistry.class::isInstance).map(IPostRegistry.class::cast).forEach(IPostRegistry::initEntry);
    }

    private <R extends IForgeRegistryEntry> List<R> getRegistry(RegistryType type) {
        return this.modEntry.getRegistry().getForgeEntries(Lists.newArrayList(), type);
    }
}

