/*
 * Decompiled with CFR 0.152.
 */
package com.setycz.chickens.registry;

import com.setycz.chickens.handler.SpawnType;
import com.setycz.chickens.registry.ChickensRegistryItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;

public final class ChickensRegistry {
    private static final Map<ResourceLocation, ChickensRegistryItem> items = new HashMap<ResourceLocation, ChickensRegistryItem>();
    private static final Map<String, ChickensRegistryItem> STRING_TO_ITEM = new HashMap<String, ChickensRegistryItem>();
    public static final ResourceLocation SMART_CHICKEN_ID = new ResourceLocation("chickens", "SmartChicken");
    private static final Random rand = new Random();

    public static void register(ChickensRegistryItem entity) {
        ChickensRegistry.validate(entity);
        items.put(entity.getRegistryName(), entity);
        STRING_TO_ITEM.put(entity.getRegistryName().toString(), entity);
    }

    private static void validate(ChickensRegistryItem entity) {
        for (ChickensRegistryItem item : items.values()) {
            if (entity.getRegistryName().toString().compareToIgnoreCase(item.getRegistryName().toString()) == 0) {
                throw new RuntimeException("Duplicated ID [" + entity.getRegistryName().toString() + "] of [" + entity.getEntityName() + "] with [" + item.getRegistryName().toString() + "] of [" + item.getEntityName() + "]!");
            }
            if (entity.getEntityName().compareToIgnoreCase(item.getEntityName()) != 0) continue;
            throw new RuntimeException("Duplicated name [" + entity.getEntityName() + "] of [" + entity.getRegistryName().toString() + "] with [" + item.getRegistryName().toString() + "]!");
        }
    }

    @Nullable
    public static ChickensRegistryItem getByResourceLocation(ResourceLocation type) {
        ChickensRegistryItem chicken = items.get(type);
        return chicken != null ? items.get(type) : ChickensRegistry.getByRegistryName(type.toString());
    }

    @Nullable
    public static ChickensRegistryItem getByRegistryName(String type) {
        return STRING_TO_ITEM.get(type);
    }

    public static Collection<ChickensRegistryItem> getItems() {
        ArrayList<ChickensRegistryItem> result = new ArrayList<ChickensRegistryItem>();
        for (ChickensRegistryItem chicken : items.values()) {
            if (!chicken.isEnabled()) continue;
            result.add(chicken);
        }
        return result;
    }

    private static List<ChickensRegistryItem> getChildren(ChickensRegistryItem parent1, ChickensRegistryItem parent2) {
        ArrayList<ChickensRegistryItem> result = new ArrayList<ChickensRegistryItem>();
        if (parent1.isEnabled()) {
            result.add(parent1);
        }
        if (parent2.isEnabled()) {
            result.add(parent2);
        }
        for (ChickensRegistryItem item : items.values()) {
            if (!item.isEnabled() || !item.isChildOf(parent1, parent2)) continue;
            result.add(item);
        }
        return result;
    }

    @Nullable
    public static ChickensRegistryItem findDyeChicken(int dyeMetadata) {
        for (ChickensRegistryItem chicken : items.values()) {
            if (!chicken.isDye(dyeMetadata)) continue;
            return chicken;
        }
        return null;
    }

    public static List<ChickensRegistryItem> getPossibleChickensToSpawn(SpawnType spawnType) {
        ArrayList<ChickensRegistryItem> result = new ArrayList<ChickensRegistryItem>();
        for (ChickensRegistryItem chicken : items.values()) {
            if (!chicken.canSpawn() || chicken.getSpawnType() != spawnType || !chicken.isEnabled()) continue;
            result.add(chicken);
        }
        return result;
    }

    public static SpawnType getSpawnType(Biome biome) {
        if (biome == Biomes.field_76778_j) {
            return SpawnType.HELL;
        }
        if (biome == Biomes.field_76770_e || biome.func_150559_j()) {
            return SpawnType.SNOW;
        }
        return SpawnType.NORMAL;
    }

    public static float getChildChance(ChickensRegistryItem child) {
        if (child.getTier() <= 1) {
            return 0.0f;
        }
        List<ChickensRegistryItem> possibleChildren = ChickensRegistry.getChildren(child.getParent1(), child.getParent2());
        int maxChance = ChickensRegistry.getMaxChance(possibleChildren);
        int maxDiceValue = ChickensRegistry.getMaxDiceValue(possibleChildren, maxChance);
        return (float)(maxChance - child.getTier()) * 100.0f / (float)maxDiceValue;
    }

    @Nullable
    public static ChickensRegistryItem getRandomChild(ChickensRegistryItem parent1, ChickensRegistryItem parent2) {
        List<ChickensRegistryItem> possibleChildren = ChickensRegistry.getChildren(parent1, parent2);
        if (possibleChildren.size() == 0) {
            return null;
        }
        int maxChance = ChickensRegistry.getMaxChance(possibleChildren);
        int maxDiceValue = ChickensRegistry.getMaxDiceValue(possibleChildren, maxChance);
        int diceValue = rand.nextInt(maxDiceValue);
        return ChickensRegistry.getChickenToBeBorn(possibleChildren, maxChance, diceValue);
    }

    @Nullable
    private static ChickensRegistryItem getChickenToBeBorn(List<ChickensRegistryItem> possibleChildren, int maxChance, int diceValue) {
        int currentVale = 0;
        for (ChickensRegistryItem child : possibleChildren) {
            if (diceValue >= (currentVale += maxChance - child.getTier())) continue;
            return child;
        }
        return null;
    }

    private static int getMaxDiceValue(List<ChickensRegistryItem> possibleChildren, int maxChance) {
        int maxDiceValue = 0;
        for (ChickensRegistryItem child : possibleChildren) {
            maxDiceValue += maxChance - child.getTier();
        }
        return maxDiceValue;
    }

    private static int getMaxChance(List<ChickensRegistryItem> possibleChildren) {
        int maxChance = 0;
        for (ChickensRegistryItem child : possibleChildren) {
            maxChance = Math.max(maxChance, child.getTier());
        }
        return ++maxChance;
    }

    public static boolean isAnyIn(SpawnType spawnType) {
        for (ChickensRegistryItem chicken : items.values()) {
            if (!chicken.canSpawn() || !chicken.isEnabled() || chicken.getSpawnType() != spawnType) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static ChickensRegistryItem getSmartChicken() {
        return items.get(SMART_CHICKEN_ID);
    }

    public static Collection<ChickensRegistryItem> getDisabledItems() {
        ArrayList<ChickensRegistryItem> result = new ArrayList<ChickensRegistryItem>();
        for (ChickensRegistryItem chicken : items.values()) {
            if (chicken.isEnabled()) continue;
            result.add(chicken);
        }
        return result;
    }
}

