/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.satellite;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import zmaster587.advancedRocketry.api.DataStorage;
import zmaster587.advancedRocketry.api.SatelliteRegistry;
import zmaster587.advancedRocketry.api.satellite.IDataHandler;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.api.satellite.SatelliteProperties;
import zmaster587.advancedRocketry.util.IDataInventory;
import zmaster587.libVulpes.util.ZUtils;

public abstract class SatelliteData
extends SatelliteBase {
    DataStorage data;
    long lastActionTime;
    long prevLastActionTime;

    @Override
    public String getInfo(World world) {
        return "Power: " + this.satelliteProperties.getPowerStorage() + "\nData Storage: " + ZUtils.formatNumber((int)this.data.getMaxData()) + "\nData: " + ZUtils.formatNumber((int)(this.data.getData() + this.dataCreated(world)));
    }

    private int dataCreated(World world) {
        return Math.min(this.data.getMaxData() - this.data.getData(), (int)Math.max(0L, (world.func_82737_E() - this.lastActionTime) / 200L));
    }

    @Override
    public boolean acceptsItemInConstruction(ItemStack item) {
        int flag = SatelliteRegistry.getSatelliteProperty(item).getPropertyFlag();
        return super.acceptsItemInConstruction(item) || SatelliteProperties.Property.DATA.isOfType(flag) || SatelliteProperties.Property.POWER_GEN.isOfType(flag);
    }

    @Override
    public void setProperties(ItemStack satelliteProperties) {
        super.setProperties(satelliteProperties);
        this.data.setMaxData(this.satelliteProperties.getMaxDataStorage());
    }

    @Override
    public boolean performAction(EntityPlayer player, World world, BlockPos pos) {
        TileEntity tile;
        int dataCreated = this.dataCreated(world);
        if (dataCreated > 0) {
            this.data.addData(this.dataCreated(world), this.data.getDataType(), true);
            this.lastActionTime = world.func_82737_E();
        }
        if ((tile = world.func_175625_s(pos)) instanceof IDataHandler) {
            IDataInventory dataInv = (IDataInventory)tile;
            this.data.removeData(dataInv.addData(this.data.getData(), this.data.getDataType(), EnumFacing.DOWN, true), true);
        }
        return false;
    }

    @Override
    public void setDimensionId(World world) {
        super.setDimensionId(world);
        this.lastActionTime = world.func_82737_E();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.data.readFromNBT(nbt.func_74775_l("data"));
        this.lastActionTime = nbt.func_74763_f("lastActionTime");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        NBTTagCompound data = new NBTTagCompound();
        this.data.writeToNBT(data);
        nbt.func_74782_a("data", (NBTBase)data);
        nbt.func_74772_a("lastActionTime", this.lastActionTime);
    }

    @Override
    public int numberChangesToSend() {
        return 4;
    }

    @Override
    public void onChangeRecieved(int slot, int value) {
        this.lastActionTime = this.lastActionTime & (65535L << slot * 16 ^ 0xFFFFFFFFFFFFFFFFL) | (long)value << slot * 16;
    }

    @Override
    public void sendChanges(Container container, IContainerListener crafter, int variableId, int localId) {
        crafter.func_71112_a(container, variableId, (int)((short)(this.lastActionTime >>> localId * 16 & 0xFFFFL)));
        if (localId == 3) {
            this.prevLastActionTime = this.lastActionTime;
        }
    }

    @Override
    public boolean isUpdateRequired(int localId) {
        return this.lastActionTime != this.prevLastActionTime;
    }
}

