/*
 * Decompiled with CFR 0.152.
 */
package terrails.statskeeper.event;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import terrails.statskeeper.StatsKeeper;
import terrails.statskeeper.config.configs.SKTANConfig;
import terrails.statskeeper.packet.StatsMessageTAN;
import toughasnails.api.TANCapabilities;
import toughasnails.api.stat.IPlayerStat;
import toughasnails.api.stat.capability.ITemperature;
import toughasnails.api.stat.capability.IThirst;

public class TANEvent {
    @SubscribeEvent
    public void onClonePlayer(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        IThirst oldThirst = (IThirst)event.getOriginal().getCapability(TANCapabilities.THIRST, null);
        IThirst thirst = (IThirst)event.getEntityPlayer().getCapability(TANCapabilities.THIRST, null);
        ITemperature oldTemp = (ITemperature)event.getOriginal().getCapability(TANCapabilities.TEMPERATURE, null);
        ITemperature temp = (ITemperature)event.getEntityPlayer().getCapability(TANCapabilities.TEMPERATURE, null);
        if (oldThirst == null || thirst == null) {
            return;
        }
        if (oldTemp == null || temp == null) {
            return;
        }
        if (SKTANConfig.keep_thirst) {
            int value = Math.max(SKTANConfig.lowest_thirst, oldThirst.getThirst());
            thirst.setThirst(value);
        }
        if (SKTANConfig.keep_hydration) {
            float value = Math.max((float)SKTANConfig.lowest_hydration, oldThirst.getHydration());
            thirst.setHydration(value);
        }
        if (SKTANConfig.keep_temperature) {
            temp.setTemperature(oldTemp.getTemperature());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (SKTANConfig.keep_thirst || SKTANConfig.keep_hydration) {
            this.readAndSyncData(TANCapabilities.THIRST, event.player);
        }
        if (SKTANConfig.keep_temperature) {
            this.readAndSyncData(TANCapabilities.TEMPERATURE, event.player);
        }
    }

    @SubscribeEvent
    public void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (SKTANConfig.keep_thirst || SKTANConfig.keep_hydration) {
            this.readAndSyncData(TANCapabilities.THIRST, event.player);
        }
        if (SKTANConfig.keep_temperature) {
            this.readAndSyncData(TANCapabilities.TEMPERATURE, event.player);
        }
    }

    @SubscribeEvent
    public void onWorldChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (SKTANConfig.keep_thirst || SKTANConfig.keep_hydration) {
            this.readAndSyncData(TANCapabilities.THIRST, event.player);
        }
        if (SKTANConfig.keep_temperature) {
            this.readAndSyncData(TANCapabilities.TEMPERATURE, event.player);
        }
    }

    private <T extends IPlayerStat> void readAndSyncData(Capability<T> capability, EntityPlayer player) {
        IPlayerStat data = (IPlayerStat)player.getCapability(capability, null);
        if (data != null) {
            capability.getStorage().readNBT(capability, (Object)data, null, (NBTBase)player.getEntityData().func_74775_l(capability.getName()));
            NBTTagCompound nbt = (NBTTagCompound)capability.getStorage().writeNBT(capability, (Object)data, null);
            StatsKeeper.networkWrapper.sendTo((IMessage)new StatsMessageTAN(capability, nbt), (EntityPlayerMP)player);
        }
    }
}

