/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.client;

import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.RenderCaveSpider;
import net.minecraft.client.renderer.entity.RenderEnderman;
import net.minecraft.client.renderer.entity.RenderSlime;
import net.minecraft.client.renderer.entity.RenderSpider;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import xt9.deepmoblearning.client.gui.DataOverlay;
import xt9.deepmoblearning.client.gui.DeepLearnerGui;
import xt9.deepmoblearning.client.gui.ExtractionChamberGui;
import xt9.deepmoblearning.client.gui.SimulationChamberGui;
import xt9.deepmoblearning.client.gui.TrialKeystoneGui;
import xt9.deepmoblearning.client.gui.TrialOverlay;
import xt9.deepmoblearning.client.particle.ParticleGlitch;
import xt9.deepmoblearning.client.particle.ParticleScalableSmoke;
import xt9.deepmoblearning.client.renders.RenderEntityGlitch;
import xt9.deepmoblearning.client.renders.RenderEntityGlitchOrb;
import xt9.deepmoblearning.client.renders.TESRTrialKeystone;
import xt9.deepmoblearning.common.CommonProxy;
import xt9.deepmoblearning.common.capabilities.IPlayerTrial;
import xt9.deepmoblearning.common.capabilities.PlayerTrialProvider;
import xt9.deepmoblearning.common.entity.EntityGlitch;
import xt9.deepmoblearning.common.entity.EntityGlitchOrb;
import xt9.deepmoblearning.common.entity.EntityTrialCaveSpider;
import xt9.deepmoblearning.common.entity.EntityTrialEnderman;
import xt9.deepmoblearning.common.entity.EntityTrialSlime;
import xt9.deepmoblearning.common.entity.EntityTrialSpider;
import xt9.deepmoblearning.common.items.ItemDeepLearner;
import xt9.deepmoblearning.common.tiles.TileEntityExtractionChamber;
import xt9.deepmoblearning.common.tiles.TileEntitySimulationChamber;
import xt9.deepmoblearning.common.tiles.TileEntityTrialKeystone;

public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit() {
        super.preInit();
        RenderingRegistry.registerEntityRenderingHandler(EntityGlitch.class, RenderEntityGlitch::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityGlitchOrb.class, RenderEntityGlitchOrb::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityTrialEnderman.class, RenderEnderman::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityTrialSpider.class, RenderSpider::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityTrialCaveSpider.class, RenderCaveSpider::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityTrialSlime.class, RenderSlime::new);
    }

    @Override
    public void registerRenderers() {
        MinecraftForge.EVENT_BUS.register((Object)new DataOverlay(Minecraft.func_71410_x()));
        MinecraftForge.EVENT_BUS.register((Object)new TrialOverlay(Minecraft.func_71410_x()));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTrialKeystone.class, (TileEntitySpecialRenderer)new TESRTrialKeystone());
    }

    @Override
    public void registerItemRenderer(Item item, ResourceLocation location, int meta) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(location, "inventory"));
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        EntityEquipmentSlot slot = EntityEquipmentSlot.values()[ID / 100];
        ItemStack item = player.func_184582_a(slot);
        if (ID % 100 == 1 && item.func_77973_b() instanceof ItemDeepLearner) {
            return new DeepLearnerGui(player.field_71071_by, world, slot, item);
        }
        switch (ID) {
            case 2: {
                return new SimulationChamberGui((TileEntitySimulationChamber)world.func_175625_s(new BlockPos(x, y, z)), player.field_71071_by, world);
            }
            case 3: {
                return new ExtractionChamberGui((TileEntityExtractionChamber)world.func_175625_s(new BlockPos(x, y, z)), player.field_71071_by, world);
            }
            case 4: {
                return new TrialKeystoneGui((TileEntityTrialKeystone)world.func_175625_s(new BlockPos(x, y, z)), player.field_71071_by, world);
            }
        }
        return null;
    }

    @Override
    public IPlayerTrial getClientPlayerTrialCapability() {
        return (IPlayerTrial)FMLClientHandler.instance().getClientPlayerEntity().getCapability(PlayerTrialProvider.PLAYER_TRIAL_CAP, null);
    }

    @Override
    public void spawnGlitchParticle(World world, double x, double y, double z, double mx, double my, double mz) {
        ParticleGlitch particle = new ParticleGlitch(world, x, y, z, mx, my, mz);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
    }

    @Override
    public void spawnSmokeParticle(World world, double x, double y, double z, double mx, double my, double mz, String type) {
        Object particle;
        switch (type) {
            case "smoke": {
                particle = this.getSmokeParticle(world, x, y, z, mx, my, mz);
                break;
            }
            case "mixed": {
                particle = this.getMixedParticle(world, x, y, z, mx, my, mz);
                break;
            }
            case "cyan": {
                particle = this.getCyanParticle(world, x, y, z, mx, my, mz);
                break;
            }
            default: {
                particle = new ParticleScalableSmoke(world, x, y, z, mx, my, mz, 1.4f);
            }
        }
        Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
    }

    private Particle getCyanParticle(World world, double x, double y, double z, double mx, double my, double mz) {
        ParticleScalableSmoke particle = new ParticleScalableSmoke(world, x, y, z, mx, my, mz, 1.4f);
        particle.func_70538_b(0.0f, 1.0f, 0.75f);
        return particle;
    }

    private Particle getMixedParticle(World world, double x, double y, double z, double mx, double my, double mz) {
        ParticleScalableSmoke particle = new ParticleScalableSmoke(world, x, y, z, mx, my, mz, 1.4f);
        particle.func_70538_b(0.09f, 0.09f, 0.09f);
        if (ThreadLocalRandom.current().nextInt(0, 3) == 0) {
            particle.func_70538_b(0.0f, 1.0f, 0.75f);
        }
        return particle;
    }

    private Particle getSmokeParticle(World world, double x, double y, double z, double mx, double my, double mz) {
        ParticleScalableSmoke particle = new ParticleScalableSmoke(world, x, y, z, mx, my, mz, 1.6f);
        particle.func_70538_b(0.09f, 0.09f, 0.09f);
        if (ThreadLocalRandom.current().nextInt(0, 3) == 0) {
            particle.func_70538_b(0.29f, 0.05f, 0.01f);
        }
        if (ThreadLocalRandom.current().nextInt(0, 4) == 0) {
            particle.func_70538_b(0.02f, 0.02f, 0.02f);
        }
        return particle;
    }
}

